/*
 * Decompiled with CFR 0.152.
 */
package com.bikeemotion.quartz.jobstore.hazelcast;

import com.bikeemotion.quartz.jobstore.hazelcast.util.TriggerByJobPredicate;
import com.bikeemotion.quartz.jobstore.hazelcast.util.TriggerState;
import com.bikeemotion.quartz.jobstore.hazelcast.util.TriggerWrapper;
import com.bikeemotion.quartz.jobstore.hazelcast.util.TriggersPredicate;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.core.ISet;
import com.hazelcast.core.MultiMap;
import com.hazelcast.query.Predicate;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.quartz.Calendar;
import org.quartz.DateBuilder;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.JobPersistenceException;
import org.quartz.ObjectAlreadyExistsException;
import org.quartz.SchedulerConfigException;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerKey;
import org.quartz.impl.matchers.GroupMatcher;
import org.quartz.impl.matchers.StringMatcher;
import org.quartz.spi.ClassLoadHelper;
import org.quartz.spi.JobStore;
import org.quartz.spi.OperableTrigger;
import org.quartz.spi.SchedulerSignaler;
import org.quartz.spi.TriggerFiredBundle;
import org.quartz.spi.TriggerFiredResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HazelcastJobStore
implements JobStore,
Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(HazelcastJobStore.class);
    private static final long serialVersionUID = -1113941051117911896L;
    private static HazelcastInstance hazelcastClient;
    private static final String HC_JOB_STORE_MAP_JOB = "job-store-map-job";
    private static final String HC_JOB_STORE_MAP_JOB_BY_GROUP_MAP = "job-store-map-job-by-group-map";
    private static final String HC_JOB_STORE_TRIGGER_BY_KEY_MAP = "job-store-trigger-by-key-map";
    private static final String HC_JOB_STORE_TRIGGER_KEY_BY_GROUP_MAP = "job-trigger-key-by-group-map";
    private static final String HC_JOB_STORE_PAUSED_TRIGGER_GROUPS = "job-paused-trigger-groups";
    private static final String HC_JOB_STORE_PAUSED_JOB_GROUPS = "job-paused-job-groups";
    private static final String HC_JOB_CALENDAR_MAP = "job-calendar-map";
    private static long ftrCtr;
    private SchedulerSignaler schedSignaler;
    private IMap<JobKey, JobDetail> jobsByKey;
    private IMap<TriggerKey, TriggerWrapper> triggersByKey;
    private MultiMap<String, JobKey> jobsByGroup;
    private MultiMap<String, TriggerKey> triggersByGroup;
    private IMap<String, Calendar> calendarsByName;
    private ISet<String> pausedTriggerGroups;
    private ISet<String> pausedJobGroups;
    private volatile boolean schedulerRunning = false;
    private long misfireThreshold = 5000L;
    private long triggerReleaseThreshold = 60000L;
    private String instanceId;
    private String instanceName;
    private boolean shutdownHazelcastOnShutdown = true;

    public void initialize(ClassLoadHelper loadHelper, SchedulerSignaler signaler) throws SchedulerConfigException {
        LOG.debug("Initializing Hazelcast Job Store..");
        this.schedSignaler = signaler;
        if (hazelcastClient == null) {
            LOG.warn("Starting new local hazelcast client since not hazelcast instance setted before starting scheduler.");
            hazelcastClient = Hazelcast.newHazelcastInstance();
        }
        LOG.debug("Initializing hazelcast maps...");
        this.jobsByKey = hazelcastClient.getMap(HC_JOB_STORE_MAP_JOB);
        this.triggersByKey = hazelcastClient.getMap(HC_JOB_STORE_TRIGGER_BY_KEY_MAP);
        this.jobsByGroup = hazelcastClient.getMultiMap(HC_JOB_STORE_MAP_JOB_BY_GROUP_MAP);
        this.triggersByGroup = hazelcastClient.getMultiMap(HC_JOB_STORE_TRIGGER_KEY_BY_GROUP_MAP);
        this.pausedTriggerGroups = hazelcastClient.getSet(HC_JOB_STORE_PAUSED_TRIGGER_GROUPS);
        this.pausedJobGroups = hazelcastClient.getSet(HC_JOB_STORE_PAUSED_JOB_GROUPS);
        this.calendarsByName = hazelcastClient.getMap(HC_JOB_CALENDAR_MAP);
        this.triggersByKey.addIndex("nextFireTime", true);
        LOG.debug("Hazelcast Job Store Initialized.");
    }

    public void schedulerStarted() throws SchedulerException {
        LOG.info("Hazelcast Job Store started successfully");
        this.schedulerRunning = true;
    }

    public void schedulerPaused() {
        this.schedulerRunning = false;
    }

    public void schedulerResumed() {
        this.schedulerRunning = true;
    }

    public void shutdown() {
        if (this.shutdownHazelcastOnShutdown) {
            hazelcastClient.shutdown();
        }
    }

    public boolean supportsPersistence() {
        return true;
    }

    public long getEstimatedTimeToReleaseAndAcquireTrigger() {
        return 25L;
    }

    public boolean isClustered() {
        return true;
    }

    public void storeJobAndTrigger(JobDetail newJob, OperableTrigger newTrigger) throws ObjectAlreadyExistsException, JobPersistenceException {
        this.storeJob(newJob, false);
        this.storeTrigger(newTrigger, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeJob(JobDetail job, boolean replaceExisting) throws ObjectAlreadyExistsException, JobPersistenceException {
        JobDetail newJob = (JobDetail)job.clone();
        JobKey newJobKey = newJob.getKey();
        if (this.jobsByKey.containsKey((Object)newJobKey) && !replaceExisting) {
            throw new ObjectAlreadyExistsException(newJob);
        }
        this.jobsByKey.lock((Object)newJobKey, 5L, TimeUnit.SECONDS);
        try {
            this.jobsByKey.set((Object)newJobKey, (Object)newJob);
            this.jobsByGroup.put((Object)newJobKey.getGroup(), (Object)newJobKey);
        }
        finally {
            try {
                this.jobsByKey.unlock((Object)newJobKey);
            }
            catch (IllegalMonitorStateException ex) {
                LOG.warn("Error unlocking since it is already released.", (Throwable)ex);
            }
        }
    }

    public void storeJobsAndTriggers(Map<JobDetail, Set<? extends Trigger>> triggersAndJobs, boolean replace) throws ObjectAlreadyExistsException, JobPersistenceException {
        if (!replace) {
            for (Map.Entry<JobDetail, Set<? extends Trigger>> e : triggersAndJobs.entrySet()) {
                JobDetail jobDetail = e.getKey();
                if (this.checkExists(jobDetail.getKey())) {
                    throw new ObjectAlreadyExistsException(jobDetail);
                }
                for (Trigger trigger : e.getValue()) {
                    if (!this.checkExists(trigger.getKey())) continue;
                    throw new ObjectAlreadyExistsException(trigger);
                }
            }
        }
        for (Map.Entry<JobDetail, Set<? extends Trigger>> e : triggersAndJobs.entrySet()) {
            this.storeJob(e.getKey(), true);
            for (Trigger trigger : e.getValue()) {
                this.storeTrigger((OperableTrigger)trigger, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeJob(JobKey jobKey) throws JobPersistenceException {
        boolean removed = false;
        if (this.jobsByKey.containsKey((Object)jobKey)) {
            List<OperableTrigger> triggersForJob = this.getTriggersForJob(jobKey);
            for (OperableTrigger trigger : triggersForJob) {
                if (this.removeTrigger(trigger.getKey(), false)) continue;
                LOG.warn("Error deleting trigger [{}] of job [{}] .", (Object)trigger, (Object)jobKey);
                return false;
            }
            this.jobsByKey.lock((Object)jobKey, 5L, TimeUnit.MILLISECONDS);
            try {
                this.jobsByGroup.remove((Object)jobKey.getGroup(), (Object)jobKey);
                removed = this.jobsByKey.remove((Object)jobKey) != null;
            }
            finally {
                try {
                    this.jobsByKey.unlock((Object)jobKey);
                }
                catch (IllegalMonitorStateException ex) {
                    LOG.warn("Error unlocking since it is already released.", (Throwable)ex);
                }
            }
        }
        return removed;
    }

    public boolean removeJobs(List<JobKey> jobKeys) throws JobPersistenceException {
        boolean allRemoved = true;
        for (JobKey key : jobKeys) {
            allRemoved = this.removeJob(key) && allRemoved;
        }
        return allRemoved;
    }

    public JobDetail retrieveJob(JobKey jobKey) throws JobPersistenceException {
        return jobKey != null && this.jobsByKey.containsKey((Object)jobKey) ? (JobDetail)((JobDetail)this.jobsByKey.get((Object)jobKey)).clone() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeTrigger(OperableTrigger trigger, boolean replaceExisting) throws ObjectAlreadyExistsException, JobPersistenceException {
        OperableTrigger newTrigger = (OperableTrigger)trigger.clone();
        TriggerKey triggerKey = newTrigger.getKey();
        this.triggersByKey.lock((Object)triggerKey, 5L, TimeUnit.SECONDS);
        try {
            boolean containsKey = this.triggersByKey.containsKey((Object)triggerKey);
            if (containsKey && !replaceExisting) {
                throw new ObjectAlreadyExistsException((Trigger)newTrigger);
            }
            if (this.retrieveJob(newTrigger.getJobKey()) == null) {
                throw new JobPersistenceException("The job (" + newTrigger.getJobKey() + ") referenced by the trigger does not exist.");
            }
            boolean shouldBePaused = this.pausedJobGroups.contains((Object)newTrigger.getJobKey().getGroup()) || this.pausedTriggerGroups.contains((Object)triggerKey.getGroup());
            TriggerState state = shouldBePaused ? TriggerState.PAUSED : TriggerState.NORMAL;
            TriggerWrapper newTriggerWrapper = TriggerWrapper.newTriggerWrapper(newTrigger, state);
            this.triggersByKey.set((Object)newTriggerWrapper.key, (Object)newTriggerWrapper);
            this.triggersByGroup.put((Object)triggerKey.getGroup(), (Object)triggerKey);
        }
        finally {
            try {
                this.triggersByKey.unlock((Object)triggerKey);
            }
            catch (IllegalMonitorStateException ex) {
                LOG.warn("Error unlocking since it is already released.", (Throwable)ex);
            }
        }
    }

    public boolean removeTrigger(TriggerKey triggerKey) throws JobPersistenceException {
        return this.removeTrigger(triggerKey, true);
    }

    public boolean removeTriggers(List<TriggerKey> triggerKeys) throws JobPersistenceException {
        boolean allRemoved = true;
        for (TriggerKey key : triggerKeys) {
            allRemoved = this.removeTrigger(key) && allRemoved;
        }
        return allRemoved;
    }

    public boolean replaceTrigger(TriggerKey triggerKey, OperableTrigger newTrigger) throws JobPersistenceException {
        newTrigger.setKey(triggerKey);
        this.storeTrigger(newTrigger, true);
        return true;
    }

    public OperableTrigger retrieveTrigger(TriggerKey triggerKey) throws JobPersistenceException {
        return triggerKey != null && this.triggersByKey.containsKey((Object)triggerKey) ? (OperableTrigger)((TriggerWrapper)this.triggersByKey.get((Object)triggerKey)).getTrigger().clone() : null;
    }

    public boolean checkExists(JobKey jobKey) throws JobPersistenceException {
        return this.jobsByKey.containsKey((Object)jobKey);
    }

    public boolean checkExists(TriggerKey triggerKey) throws JobPersistenceException {
        return this.triggersByKey.containsKey((Object)triggerKey);
    }

    public void clearAllSchedulingData() throws JobPersistenceException {
        this.jobsByKey.clear();
        this.triggersByKey.clear();
        this.jobsByGroup.clear();
        this.triggersByGroup.clear();
        this.calendarsByName.clear();
        this.pausedTriggerGroups.clear();
        this.pausedJobGroups.clear();
    }

    public void storeCalendar(String calName, Calendar cal, boolean replaceExisting, boolean updateTriggers) throws ObjectAlreadyExistsException, JobPersistenceException {
        Calendar calendar = (Calendar)cal.clone();
        if (this.calendarsByName.containsKey((Object)calName) && !replaceExisting) {
            throw new ObjectAlreadyExistsException("Calendar with name '" + calName + "' already exists.");
        }
        this.calendarsByName.set((Object)calName, (Object)calendar);
    }

    public boolean removeCalendar(String calName) throws JobPersistenceException {
        int numRefs = 0;
        for (TriggerWrapper trigger : this.triggersByKey.values()) {
            OperableTrigger trigg = trigger.trigger;
            if (trigg.getCalendarName() == null || !trigg.getCalendarName().equals(calName)) continue;
            ++numRefs;
        }
        if (numRefs > 0) {
            throw new JobPersistenceException("Calender cannot be removed if it referenced by a Trigger!");
        }
        return this.calendarsByName.remove((Object)calName) != null;
    }

    public Calendar retrieveCalendar(String calName) throws JobPersistenceException {
        return (Calendar)this.calendarsByName.get((Object)calName);
    }

    public int getNumberOfJobs() throws JobPersistenceException {
        return this.jobsByKey.size();
    }

    public int getNumberOfTriggers() throws JobPersistenceException {
        return this.triggersByKey.size();
    }

    public int getNumberOfCalendars() throws JobPersistenceException {
        return this.calendarsByName.size();
    }

    public Set<JobKey> getJobKeys(GroupMatcher<JobKey> matcher) throws JobPersistenceException {
        HashSet<JobKey> outList = null;
        StringMatcher.StringOperatorName operator = matcher.getCompareWithOperator();
        String groupNameCompareValue = matcher.getCompareToValue();
        switch (operator) {
            case EQUALS: {
                Collection jobKeys = this.jobsByGroup.get((Object)groupNameCompareValue);
                if (jobKeys == null) break;
                outList = new HashSet<JobKey>();
                for (JobKey jobKey : jobKeys) {
                    if (jobKey == null) continue;
                    outList.add(jobKey);
                }
                break;
            }
            default: {
                for (String groupName : this.jobsByGroup.keySet()) {
                    if (!operator.evaluate(groupName, groupNameCompareValue)) continue;
                    if (outList == null) {
                        outList = new HashSet();
                    }
                    for (JobKey jobKey : this.jobsByGroup.get((Object)groupName)) {
                        if (jobKey == null) continue;
                        outList.add(jobKey);
                    }
                }
            }
        }
        return outList == null ? Collections.emptySet() : outList;
    }

    public Set<TriggerKey> getTriggerKeys(GroupMatcher<TriggerKey> matcher) throws JobPersistenceException {
        HashSet outList = null;
        StringMatcher.StringOperatorName operator = matcher.getCompareWithOperator();
        String groupNameCompareValue = matcher.getCompareToValue();
        switch (operator) {
            case EQUALS: {
                Collection triggerKeys = this.triggersByGroup.get((Object)groupNameCompareValue);
                if (triggerKeys == null) break;
                outList = Sets.newHashSet();
                for (TriggerKey triggerKey : triggerKeys) {
                    if (triggerKey == null) continue;
                    outList.add(triggerKey);
                }
                break;
            }
            default: {
                for (String groupName : this.triggersByGroup.keySet()) {
                    if (!operator.evaluate(groupName, groupNameCompareValue)) continue;
                    if (outList == null) {
                        outList = Sets.newHashSet();
                    }
                    for (TriggerKey triggerKey : this.triggersByGroup.get((Object)groupName)) {
                        if (triggerKey == null) continue;
                        outList.add(triggerKey);
                    }
                }
            }
        }
        return outList == null ? Collections.emptySet() : outList;
    }

    public List<String> getJobGroupNames() throws JobPersistenceException {
        return Lists.newArrayList((Iterable)this.jobsByGroup.keySet());
    }

    public List<String> getTriggerGroupNames() throws JobPersistenceException {
        return new LinkedList<String>(this.triggersByGroup.keySet());
    }

    public List<String> getCalendarNames() throws JobPersistenceException {
        return new LinkedList<String>(this.calendarsByName.keySet());
    }

    public List<OperableTrigger> getTriggersForJob(JobKey jobKey) throws JobPersistenceException {
        if (jobKey == null) {
            return Collections.emptyList();
        }
        ArrayList<OperableTrigger> returnList = new ArrayList<OperableTrigger>();
        for (TriggerWrapper v : this.triggersByKey.values((Predicate)new TriggerByJobPredicate(jobKey))) {
            returnList.add(v.getTrigger());
        }
        return returnList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pauseTrigger(TriggerKey triggerKey) throws JobPersistenceException {
        this.triggersByKey.lock((Object)triggerKey, 5L, TimeUnit.SECONDS);
        try {
            TriggerWrapper newTrigger = TriggerWrapper.newTriggerWrapper((TriggerWrapper)this.triggersByKey.get((Object)triggerKey), TriggerState.PAUSED);
            this.triggersByKey.set((Object)triggerKey, (Object)newTrigger);
        }
        finally {
            try {
                this.triggersByKey.unlock((Object)triggerKey);
            }
            catch (IllegalMonitorStateException ex) {
                LOG.warn("Error unlocking since it is already released.", (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Trigger.TriggerState getTriggerState(TriggerKey triggerKey) throws JobPersistenceException {
        this.triggersByKey.lock((Object)triggerKey, 5L, TimeUnit.SECONDS);
        Trigger.TriggerState result = Trigger.TriggerState.NONE;
        try {
            TriggerWrapper tw = (TriggerWrapper)this.triggersByKey.get((Object)triggerKey);
            if (tw != null) {
                result = TriggerState.toClassicTriggerState(tw.getState());
            }
        }
        finally {
            try {
                this.triggersByKey.unlock((Object)triggerKey);
            }
            catch (IllegalMonitorStateException ex) {
                LOG.warn("Error unlocking since it is already released.", (Throwable)ex);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeTrigger(TriggerKey triggerKey) throws JobPersistenceException {
        this.triggersByKey.lock((Object)triggerKey, 5L, TimeUnit.SECONDS);
        try {
            if (this.schedulerRunning) {
                TriggerWrapper newTrigger = TriggerWrapper.newTriggerWrapper((TriggerWrapper)this.triggersByKey.get((Object)triggerKey), TriggerState.NORMAL);
                this.triggersByKey.set((Object)newTrigger.key, (Object)newTrigger);
            }
        }
        finally {
            try {
                this.triggersByKey.unlock((Object)triggerKey);
            }
            catch (IllegalMonitorStateException ex) {
                LOG.warn("Error unlocking since it is already released.", (Throwable)ex);
            }
        }
    }

    public Collection<String> pauseTriggers(GroupMatcher<TriggerKey> matcher) throws JobPersistenceException {
        LinkedList<String> pausedGroups = new LinkedList<String>();
        StringMatcher.StringOperatorName operator = matcher.getCompareWithOperator();
        switch (operator) {
            case EQUALS: {
                if (!this.pausedTriggerGroups.add((Object)matcher.getCompareToValue())) break;
                pausedGroups.add(matcher.getCompareToValue());
                break;
            }
            default: {
                for (String group : this.triggersByGroup.keySet()) {
                    if (!operator.evaluate(group, matcher.getCompareToValue()) || !this.pausedTriggerGroups.add((Object)matcher.getCompareToValue())) continue;
                    pausedGroups.add(group);
                }
            }
        }
        for (String pausedGroup : pausedGroups) {
            Set<TriggerKey> keys = this.getTriggerKeys((GroupMatcher<TriggerKey>)GroupMatcher.triggerGroupEquals((String)pausedGroup));
            for (TriggerKey key : keys) {
                this.pauseTrigger(key);
            }
        }
        return pausedGroups;
    }

    public Collection<String> resumeTriggers(GroupMatcher<TriggerKey> matcher) throws JobPersistenceException {
        HashSet<String> resumeGroups = new HashSet<String>();
        Set<TriggerKey> keys = this.getTriggerKeys(matcher);
        for (TriggerKey triggerKey : keys) {
            resumeGroups.add(triggerKey.getGroup());
            TriggerWrapper tw = (TriggerWrapper)this.triggersByKey.get((Object)triggerKey);
            OperableTrigger trigger = tw.getTrigger();
            String jobGroup = trigger.getJobKey().getGroup();
            if (this.pausedJobGroups.contains((Object)jobGroup)) continue;
            this.resumeTrigger(triggerKey);
        }
        for (String group : resumeGroups) {
            this.pausedTriggerGroups.remove((Object)group);
        }
        return new ArrayList<String>(resumeGroups);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pauseJob(JobKey jobKey) throws JobPersistenceException {
        boolean found = this.jobsByKey.containsKey((Object)jobKey);
        if (!found) {
            return;
        }
        this.jobsByKey.lock((Object)jobKey, 5L, TimeUnit.SECONDS);
        try {
            List<OperableTrigger> triggersForJob = this.getTriggersForJob(jobKey);
            for (OperableTrigger trigger : triggersForJob) {
                this.pauseTrigger(trigger.getKey());
            }
        }
        finally {
            try {
                this.jobsByKey.unlock((Object)jobKey);
            }
            catch (IllegalMonitorStateException ex) {
                LOG.warn("Error unlocking since it is already released.", (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeJob(JobKey jobKey) throws JobPersistenceException {
        boolean found = this.jobsByKey.containsKey((Object)jobKey);
        if (!found) {
            return;
        }
        this.jobsByKey.lock((Object)jobKey, 5L, TimeUnit.SECONDS);
        try {
            List<OperableTrigger> triggersForJob = this.getTriggersForJob(jobKey);
            for (OperableTrigger trigger : triggersForJob) {
                this.resumeTrigger(trigger.getKey());
            }
        }
        finally {
            try {
                this.jobsByKey.unlock((Object)jobKey);
            }
            catch (IllegalMonitorStateException ex) {
                LOG.warn("Error unlocking since it is already released.", (Throwable)ex);
            }
        }
    }

    public Collection<String> pauseJobs(GroupMatcher<JobKey> groupMatcher) throws JobPersistenceException {
        LinkedList<String> pausedGroups = new LinkedList<String>();
        StringMatcher.StringOperatorName operator = groupMatcher.getCompareWithOperator();
        switch (operator) {
            case EQUALS: {
                if (!this.pausedJobGroups.add((Object)groupMatcher.getCompareToValue())) break;
                pausedGroups.add(groupMatcher.getCompareToValue());
                break;
            }
            default: {
                for (String jobGroup : this.jobsByGroup.keySet()) {
                    if (!operator.evaluate(jobGroup, groupMatcher.getCompareToValue()) || !this.pausedJobGroups.add((Object)jobGroup)) continue;
                    pausedGroups.add(jobGroup);
                }
            }
        }
        for (String groupName : pausedGroups) {
            for (JobKey jobKey : this.getJobKeys((GroupMatcher<JobKey>)GroupMatcher.jobGroupEquals((String)groupName))) {
                this.pauseJob(jobKey);
            }
        }
        return pausedGroups;
    }

    public Collection<String> resumeJobs(GroupMatcher<JobKey> matcher) throws JobPersistenceException {
        HashSet<String> resumeGroups = new HashSet<String>();
        Set<JobKey> jobKeys = this.getJobKeys(matcher);
        for (JobKey jobKey : jobKeys) {
            resumeGroups.add(jobKey.getGroup());
            this.resumeJob(jobKey);
        }
        for (String group : resumeGroups) {
            this.pausedJobGroups.remove((Object)group);
        }
        return new ArrayList<String>(resumeGroups);
    }

    public Set<String> getPausedTriggerGroups() throws JobPersistenceException {
        return new HashSet<String>((Collection<String>)this.pausedTriggerGroups);
    }

    public void pauseAll() throws JobPersistenceException {
        for (String triggerGroup : this.triggersByGroup.keySet()) {
            this.pauseTriggers((GroupMatcher<TriggerKey>)GroupMatcher.triggerGroupEquals((String)triggerGroup));
        }
    }

    public void resumeAll() throws JobPersistenceException {
        List<String> triggerGroupNames = this.getTriggerGroupNames();
        for (String triggerGroup : triggerGroupNames) {
            this.resumeTriggers((GroupMatcher<TriggerKey>)GroupMatcher.triggerGroupEquals((String)triggerGroup));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<OperableTrigger> acquireNextTriggers(long noLaterThan, int maxCount, long timeWindow) throws JobPersistenceException {
        if (this.triggersByKey.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        long limit = noLaterThan + timeWindow;
        ArrayList<OperableTrigger> result = new ArrayList<OperableTrigger>();
        HashSet<JobKey> acquiredJobKeysForNoConcurrentExec = new HashSet<JobKey>();
        ArrayList orderedTriggers = new ArrayList(this.triggersByKey.values((Predicate)new TriggersPredicate(limit)));
        Collections.sort(orderedTriggers);
        for (int i = 0; i < orderedTriggers.size(); ++i) {
            TriggerWrapper tw = (TriggerWrapper)orderedTriggers.get(i);
            this.triggersByKey.lock((Object)tw.key, 5L, TimeUnit.SECONDS);
            try {
                if (tw.getState() == TriggerState.ACQUIRED && (tw.getAcquiredAt() == null || tw.getAcquiredAt() + this.triggerReleaseThreshold + timeWindow < limit)) {
                    LOG.warn("Found a lost trigger [{}] that should be released at [{}]", (Object)tw, (Object)limit);
                    this.releaseAcquiredTrigger(tw.trigger);
                    tw = (TriggerWrapper)this.triggersByKey.get((Object)tw.key);
                }
                if (tw.getState() != TriggerState.NORMAL && tw.getState() != TriggerState.WAITING || tw.trigger.getNextFireTime() == null) continue;
                if (this.applyMisfire(tw)) {
                    LOG.debug("Misfire applied {}", (Object)tw);
                    if (tw.trigger.getNextFireTime() == null) continue;
                    tw = TriggerWrapper.newTriggerWrapper(tw, TriggerState.NORMAL);
                }
                if (tw.getTrigger().getNextFireTime().getTime() > limit) {
                    this.storeTriggerWrapper(TriggerWrapper.newTriggerWrapper(tw, TriggerState.NORMAL));
                    continue;
                }
                JobKey jobKey = tw.trigger.getJobKey();
                JobDetail job = (JobDetail)this.jobsByKey.get((Object)tw.trigger.getJobKey());
                if (job == null) {
                    LOG.debug("Job not found");
                    continue;
                }
                if (job.isConcurrentExectionDisallowed()) {
                    if (acquiredJobKeysForNoConcurrentExec.contains(jobKey)) continue;
                    acquiredJobKeysForNoConcurrentExec.add(jobKey);
                }
                OperableTrigger trig = (OperableTrigger)tw.trigger.clone();
                trig.setFireInstanceId(this.getFiredTriggerRecordId());
                this.storeTriggerWrapper(TriggerWrapper.newTriggerWrapper(trig, TriggerState.ACQUIRED));
                result.add(trig);
                if (result.size() != maxCount) continue;
                break;
            }
            finally {
                try {
                    this.triggersByKey.unlock((Object)tw.key);
                }
                catch (IllegalMonitorStateException ex) {
                    LOG.warn("Error unlocking since it is already released.", (Throwable)ex);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseAcquiredTrigger(OperableTrigger trigger) {
        TriggerKey triggerKey = trigger.getKey();
        this.triggersByKey.lock((Object)triggerKey, 5L, TimeUnit.SECONDS);
        try {
            this.storeTriggerWrapper(TriggerWrapper.newTriggerWrapper(trigger, TriggerState.WAITING));
        }
        finally {
            try {
                this.triggersByKey.unlock((Object)triggerKey);
            }
            catch (IllegalMonitorStateException ex) {
                LOG.warn("Error unlocking since it is already released.", (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TriggerFiredResult> triggersFired(List<OperableTrigger> firedTriggers) throws JobPersistenceException {
        ArrayList<TriggerFiredResult> results = new ArrayList<TriggerFiredResult>();
        for (OperableTrigger trigger : firedTriggers) {
            this.triggersByKey.lock((Object)trigger.getKey(), 5L, TimeUnit.SECONDS);
            try {
                TriggerWrapper tw = (TriggerWrapper)this.triggersByKey.get((Object)trigger.getKey());
                if (tw == null || tw.trigger == null || tw.getState() != TriggerState.ACQUIRED) continue;
                Calendar cal = null;
                if (tw.trigger.getCalendarName() != null && (cal = this.retrieveCalendar(tw.trigger.getCalendarName())) == null) continue;
                Date prevFireTime = trigger.getPreviousFireTime();
                tw.trigger.triggered(cal);
                trigger.triggered(cal);
                JobDetail job = this.retrieveJob(tw.jobKey);
                if (job.isConcurrentExectionDisallowed()) {
                    ArrayList<TriggerWrapper> trigs = this.getTriggerWrappersForJob(job.getKey());
                    for (TriggerWrapper ttw : trigs) {
                        if (ttw.getState() == TriggerState.WAITING) {
                            ttw = TriggerWrapper.newTriggerWrapper(ttw, TriggerState.BLOCKED);
                            continue;
                        }
                        if (ttw.getState() != TriggerState.PAUSED) continue;
                        ttw = TriggerWrapper.newTriggerWrapper(ttw, TriggerState.PAUSED_BLOCKED);
                    }
                    tw = TriggerWrapper.newTriggerWrapper(trigger, TriggerState.ACQUIRED);
                } else {
                    tw = TriggerWrapper.newTriggerWrapper(trigger, TriggerState.WAITING);
                }
                if (tw.trigger.getNextFireTime() != null) {
                    this.storeTriggerWrapper(tw);
                }
                TriggerFiredBundle bndle = new TriggerFiredBundle(this.retrieveJob(tw.jobKey), trigger, cal, false, new Date(), trigger.getPreviousFireTime(), prevFireTime, trigger.getNextFireTime());
                results.add(new TriggerFiredResult(bndle));
            }
            finally {
                try {
                    this.triggersByKey.unlock((Object)trigger.getKey());
                }
                catch (IllegalMonitorStateException ex) {
                    LOG.warn("Error unlocking since it is already released.", (Throwable)ex);
                }
            }
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void triggeredJobComplete(OperableTrigger trigger, JobDetail jobDetail, Trigger.CompletedExecutionInstruction triggerInstCode) {
        block25: {
            TriggerWrapper tw = (TriggerWrapper)this.triggersByKey.get((Object)trigger.getKey());
            if (jobDetail.isPersistJobDataAfterExecution()) {
                JobKey jobKey = jobDetail.getKey();
                this.jobsByKey.lock((Object)jobKey, 5L, TimeUnit.SECONDS);
                try {
                    this.jobsByKey.set((Object)jobKey, (Object)jobDetail);
                    this.jobsByGroup.put((Object)jobKey.getGroup(), (Object)jobKey);
                }
                finally {
                    try {
                        this.jobsByKey.unlock((Object)jobKey);
                    }
                    catch (IllegalMonitorStateException ex) {
                        LOG.warn("Error unlocking since it is already released.", (Throwable)ex);
                    }
                }
            }
            if (jobDetail.isConcurrentExectionDisallowed()) {
                ArrayList<TriggerWrapper> trigs = this.getTriggerWrappersForJob(jobDetail.getKey());
                for (TriggerWrapper ttw : trigs) {
                    if (ttw.getState() == TriggerState.BLOCKED || ttw.getState() == TriggerState.ACQUIRED) {
                        this.storeTriggerWrapper(TriggerWrapper.newTriggerWrapper(ttw, TriggerState.WAITING));
                        continue;
                    }
                    if (ttw.getState() != TriggerState.PAUSED_BLOCKED) continue;
                    this.storeTriggerWrapper(TriggerWrapper.newTriggerWrapper(ttw, TriggerState.PAUSED));
                }
                this.schedSignaler.signalSchedulingChange(0L);
            }
            if (tw != null) {
                if (triggerInstCode == Trigger.CompletedExecutionInstruction.DELETE_TRIGGER) {
                    try {
                        if (trigger.getNextFireTime() == null) {
                            if (tw.getTrigger().getNextFireTime() == null) {
                                this.removeTrigger(trigger.getKey());
                            }
                            break block25;
                        }
                        this.removeTrigger(trigger.getKey());
                        this.schedSignaler.signalSchedulingChange(0L);
                    }
                    catch (JobPersistenceException ex) {
                        LOG.error("Error removing trigger", (Throwable)ex);
                    }
                } else if (triggerInstCode == Trigger.CompletedExecutionInstruction.SET_TRIGGER_COMPLETE) {
                    this.storeTriggerWrapper(TriggerWrapper.newTriggerWrapper(tw, TriggerState.STATE_COMPLETED));
                    this.schedSignaler.signalSchedulingChange(0L);
                } else if (triggerInstCode == Trigger.CompletedExecutionInstruction.SET_TRIGGER_ERROR) {
                    LOG.warn("Trigger " + trigger.getKey() + " set to ERROR state.");
                    this.storeTriggerWrapper(TriggerWrapper.newTriggerWrapper(tw, TriggerState.BLOCKED));
                    this.schedSignaler.signalSchedulingChange(0L);
                } else if (triggerInstCode == Trigger.CompletedExecutionInstruction.SET_ALL_JOB_TRIGGERS_ERROR) {
                    LOG.info("All triggers of Job " + trigger.getJobKey() + " set to ERROR state.");
                    this.storeTriggerWrapper(TriggerWrapper.newTriggerWrapper(tw, TriggerState.BLOCKED));
                    this.schedSignaler.signalSchedulingChange(0L);
                } else if (triggerInstCode == Trigger.CompletedExecutionInstruction.SET_ALL_JOB_TRIGGERS_COMPLETE) {
                    this.storeTriggerWrapper(TriggerWrapper.newTriggerWrapper(tw, TriggerState.STATE_COMPLETED));
                    this.schedSignaler.signalSchedulingChange(0L);
                }
            }
        }
    }

    public void setInstanceName(String instanceName) {
        this.instanceName = instanceName;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public void setShutdownHazelcastOnShutdown(boolean shutdownHazelcastOnShutdown) {
        this.shutdownHazelcastOnShutdown = shutdownHazelcastOnShutdown;
    }

    public long getMisfireThreshold() {
        return this.misfireThreshold;
    }

    public void setMisfireThreshold(long misfireThreshold) {
        this.misfireThreshold = misfireThreshold;
    }

    public void setThreadPoolSize(int poolSize) {
    }

    private ArrayList<TriggerWrapper> getTriggerWrappersForJob(JobKey jobKey) {
        ArrayList<TriggerWrapper> trigList = new ArrayList<TriggerWrapper>();
        for (TriggerWrapper trigger : this.triggersByKey.values()) {
            if (!trigger.jobKey.equals((Object)jobKey)) continue;
            trigList.add(trigger);
        }
        return trigList;
    }

    private boolean applyMisfire(TriggerWrapper tw) throws JobPersistenceException {
        Date tnft;
        long misfireTime = DateBuilder.newDate().build().getTime();
        if (this.misfireThreshold > 0L) {
            misfireTime -= this.misfireThreshold;
        }
        if ((tnft = tw.trigger.getNextFireTime()) == null || tnft.getTime() > misfireTime || tw.trigger.getMisfireInstruction() == -1) {
            return false;
        }
        Calendar cal = null;
        if (tw.trigger.getCalendarName() != null) {
            cal = this.retrieveCalendar(tw.trigger.getCalendarName());
        }
        this.schedSignaler.notifyTriggerListenersMisfired((Trigger)((OperableTrigger)tw.trigger.clone()));
        tw.trigger.updateAfterMisfire(cal);
        if (tw.trigger.getNextFireTime() == null) {
            this.storeTriggerWrapper(TriggerWrapper.newTriggerWrapper(tw, TriggerState.STATE_COMPLETED));
            this.schedSignaler.notifySchedulerListenersFinalized((Trigger)tw.trigger);
        } else if (tnft.equals(tw.trigger.getNextFireTime())) {
            return false;
        }
        return true;
    }

    private synchronized String getFiredTriggerRecordId() {
        return this.instanceId + ftrCtr++;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeTrigger(TriggerKey key, boolean removeOrphanedJob) throws JobPersistenceException {
        boolean removed = false;
        this.triggersByKey.lock((Object)key, 5L, TimeUnit.SECONDS);
        try {
            TriggerWrapper tw = (TriggerWrapper)this.triggersByKey.remove((Object)key);
            boolean bl = removed = tw != null;
            if (removed) {
                this.triggersByGroup.remove((Object)key.getGroup(), (Object)key);
                if (removeOrphanedJob) {
                    JobDetail job = (JobDetail)this.jobsByKey.get((Object)tw.jobKey);
                    List<OperableTrigger> trigs = this.getTriggersForJob(tw.jobKey);
                    if ((trigs == null || trigs.isEmpty()) && !job.isDurable() && this.removeJob(job.getKey())) {
                        this.schedSignaler.notifySchedulerListenersJobDeleted(job.getKey());
                    }
                }
            }
        }
        finally {
            try {
                this.triggersByKey.unlock((Object)key);
            }
            catch (IllegalMonitorStateException ex) {
                LOG.warn("Error unlocking since it is already released.", (Throwable)ex);
            }
        }
        return removed;
    }

    private void storeTriggerWrapper(TriggerWrapper tw) {
        this.triggersByKey.set((Object)tw.key, (Object)tw);
    }

    public void setTriggerReleaseThreshold(long triggerReleaseThreshold) {
        if (triggerReleaseThreshold > 30000L) {
            LOG.warn("Try to increase your trigger release time threashold since quartz acquireNextTriggers in a 30000 interval");
        }
        this.triggerReleaseThreshold = triggerReleaseThreshold;
    }

    public static void setHazelcastClient(HazelcastInstance aHazelcastClient) {
        hazelcastClient = aHazelcastClient;
    }

    static {
        ftrCtr = System.currentTimeMillis();
    }
}

