/*
 * Decompiled with CFR 0.152.
 */
package com.github.esap120.scala_elo;

import com.github.esap120.scala_elo.Game;
import com.github.esap120.scala_elo.KFactor$;
import com.github.esap120.scala_elo.Player;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.collection.LinearSeqOptimized;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction2;

public final class EloEngine$ {
    public static EloEngine$ MODULE$;

    static {
        new EloEngine$();
    }

    public int calculateRating(Player player, Enumeration.Value kFactorType) {
        double kFactorResult = this.calculateKFactor(player.rating(), player.gamesPlayed(), kFactorType);
        return this.calculateRating(player.rating(), player.tournamentHistory(), player.gamesPlayed(), kFactorResult);
    }

    public int calculateRating(Player player, double kFactor) {
        return this.calculateRating(player.rating(), player.tournamentHistory(), player.gamesPlayed(), kFactor);
    }

    public int calculateRating(int playerRating, List<Game> playedGames, int totalGamesPlayed, double kFactor) {
        if (playedGames.isEmpty()) {
            return playerRating;
        }
        double actualScoreSum = BoxesRunTime.unboxToDouble((Object)((LinearSeqOptimized)playedGames.map((Function1 & java.io.Serializable & Serializable)game -> BoxesRunTime.boxToDouble((double)game.score()), List$.MODULE$.canBuildFrom())).foldLeft((Object)BoxesRunTime.boxToDouble((double)0.0), (Function2)(JFunction2.mcDDD.sp & java.io.Serializable & Serializable)(x$1, x$2) -> x$1 + x$2));
        double expectedScoreSum = BoxesRunTime.unboxToDouble((Object)((LinearSeqOptimized)playedGames.map((Function1 & java.io.Serializable & Serializable)game -> BoxesRunTime.boxToDouble((double)EloEngine$.MODULE$.calculateExpectedScore(game.playerRating(), game.opponentRating())), List$.MODULE$.canBuildFrom())).foldLeft((Object)BoxesRunTime.boxToDouble((double)0.0), (Function2)(JFunction2.mcDDD.sp & java.io.Serializable & Serializable)(x$3, x$4) -> x$3 + x$4));
        return this.calculateRating(playerRating, actualScoreSum, expectedScoreSum, kFactor);
    }

    public int calculateRating(int currentRating, int totalGamesPlayed, double actualScore, double expectedScore, Enumeration.Value kFactor) {
        double kFactorResult = this.calculateKFactor(currentRating, totalGamesPlayed, kFactor);
        return this.calculateRating(currentRating, actualScore, expectedScore, kFactorResult);
    }

    public int calculateRating(int currentRating, double actualScore, double expectedScore, double kFactor) {
        return (int)Math.round((double)currentRating + kFactor * (actualScore - expectedScore));
    }

    public Enumeration.Value calculateRating$default$2() {
        return KFactor$.MODULE$.SIMPLE();
    }

    public double calculateExpectedScore(int playerRating, int opponentRating) {
        return 1.0 / (1.0 + Math.pow(10.0, (double)(opponentRating - playerRating) / 400.0));
    }

    public double calculateKFactor(int currentRating, int totalGamesPlayed, Enumeration.Value kFactor) {
        double d;
        Predef$.MODULE$.require(totalGamesPlayed > 0, (Function0 & java.io.Serializable & Serializable)() -> "A player cannot have negative or zero games played");
        Enumeration.Value value = kFactor;
        Enumeration.Value value2 = KFactor$.MODULE$.SIMPLE();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            double kFactor2 = 800.0 / (double)totalGamesPlayed;
            d = kFactor2 < (double)10 ? 10.0 : kFactor2;
        } else {
            Enumeration.Value value4 = KFactor$.MODULE$.USCF();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                d = currentRating < 2100 ? 32.0 : (currentRating >= 2100 && currentRating < 2400 ? 24.0 : 16.0);
            } else {
                Enumeration.Value value6 = KFactor$.MODULE$.FIDE();
                Enumeration.Value value7 = value;
                if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                    d = totalGamesPlayed < 30 ? 40.0 : (currentRating < 2400 ? 20.0 : 10.0);
                } else {
                    throw new MatchError((Object)value);
                }
            }
        }
        return d;
    }

    public Enumeration.Value calculateKFactor$default$3() {
        return KFactor$.MODULE$.SIMPLE();
    }

    private EloEngine$() {
        MODULE$ = this;
    }
}

