/*
 * Decompiled with CFR 0.152.
 */
package javax.validation.constraints;

import java.lang.reflect.Field;
import java.util.Objects;
import javax.persistence.EntityManager;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.constraints.Unique;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.ReflectionUtils;

public class UniqueValidator
implements ConstraintValidator<Unique, Object> {
    final Logger log = LoggerFactory.getLogger(UniqueValidator.class);
    @Autowired
    private EntityManager entityManager;
    private String primaryKey;
    private String[] fields;
    private String message;
    private Class clazz;

    public void initialize(Unique annotation) {
        this.primaryKey = annotation.primaryKey();
        this.fields = annotation.fields();
        this.message = annotation.message();
        this.clazz = annotation.clazz();
    }

    public boolean isValid(Object object, ConstraintValidatorContext context) {
        if (Objects.isNull(this.entityManager)) {
            return true;
        }
        boolean isValid = false;
        int validationCount = this.fields.length;
        try {
            for (String field : this.fields) {
                Field fieldId = ReflectionUtils.findField((Class)this.clazz, (String)this.primaryKey);
                Field fieldName = ReflectionUtils.findField((Class)this.clazz, (String)field);
                fieldId.setAccessible(true);
                fieldName.setAccessible(true);
                Long fieldIdValue = (Long)fieldId.get(object);
                String fieldNameValue = (String)fieldName.get(object);
                Object result = null;
                try {
                    result = this.entityManager.createQuery(String.format("FROM %s m WHERE m.%s = :field", this.clazz.getSimpleName(), field)).setParameter("field", (Object)fieldNameValue).getSingleResult();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (Objects.isNull(fieldIdValue)) {
                    isValid = !Objects.nonNull(result);
                } else if (Objects.nonNull(result)) {
                    Field fieldResult = ReflectionUtils.findField((Class)this.clazz, (String)this.primaryKey);
                    fieldResult.setAccessible(true);
                    Long fieldResultId = (Long)fieldResult.get(result);
                    isValid = fieldIdValue == fieldResultId;
                } else {
                    isValid = true;
                }
                if (isValid) continue;
                --validationCount;
                context.disableDefaultConstraintViolation();
                context.buildConstraintViolationWithTemplate(String.format(this.message, field)).addPropertyNode(field).addConstraintViolation();
            }
            return validationCount == this.fields.length;
        }
        catch (Exception e) {
            this.log.error(e.getMessage());
            return isValid;
        }
    }
}

