/*
 * Decompiled with CFR 0.152.
 */
package com.github.estebanwasinger.http.bridge.api;

import com.github.estebanwasinger.http.bridge.api.HttpClientBridgeFactory;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import org.mule.api.MuleContext;
import org.mule.module.http.internal.request.HttpClient;

public class DefaultHttpClientBridgeFactory
implements HttpClientBridgeFactory {
    private final ArrayList<String> factories;
    private MuleContext muleContext;

    public DefaultHttpClientBridgeFactory(MuleContext muleContext) {
        this.muleContext = muleContext;
        this.factories = new ArrayList();
        this.factories.add("com.github.estebanwasinger.http.bridge.api.HttpClientFactory380");
        this.factories.add("com.github.estebanwasinger.http.bridge.api.HttpClientFactory370");
        this.factories.add("com.github.estebanwasinger.http.bridge.api.HttpClientFactory360");
    }

    public HttpClient createClient(int maxConnections, boolean usePersistentConnections, int connectionIdleTimeout, String threadNamePrefix, String ownerName) {
        HttpClientBridgeFactory bridgeFactory = this.getHttpClientBridgeFactory();
        if (bridgeFactory == null) {
            throw new RuntimeException("Unable to create the HTTP Client");
        }
        return bridgeFactory.createClient(maxConnections, usePersistentConnections, connectionIdleTimeout, threadNamePrefix, ownerName);
    }

    private HttpClientBridgeFactory getHttpClientBridgeFactory() {
        for (String factoryClass : this.factories) {
            try {
                Class<?> aClass = Thread.currentThread().getContextClassLoader().loadClass(factoryClass);
                Constructor<?> constructor = aClass.getConstructor(MuleContext.class);
                return (HttpClientBridgeFactory)constructor.newInstance(this.muleContext);
            }
            catch (Exception e) {
                System.out.println("Unable to create: " + factoryClass);
            }
        }
        return null;
    }
}

