/*
 * Decompiled with CFR 0.152.
 */
package com.etashkinov.hubspot;

import com.etashkinov.hubspot.HubspotAssociation;
import com.etashkinov.hubspot.companies.CompaniesClient;
import com.etashkinov.hubspot.contacts.ContactsClient;
import com.etashkinov.hubspot.transport.HttpClient;
import com.etashkinov.hubspot.transport.RootPathHttpClient;
import com.etashkinov.hubspot.transport.SimpleHttpClient;

public class HubspotClient {
    public static final String ROOT_PATH = "https://api.hubapi.com";
    private final String hubspotApiKey;
    private final HttpClient httpClient;

    public HubspotClient(String rootPath, HttpClient httpClient, String hubspotApiKey) {
        this.httpClient = new RootPathHttpClient(rootPath, httpClient);
        this.hubspotApiKey = hubspotApiKey;
    }

    public HubspotClient(String hubspotApiKey) {
        this(new SimpleHttpClient(), hubspotApiKey);
    }

    public HubspotClient(HttpClient httpClient, String hubspotApiKey) {
        this(ROOT_PATH, httpClient, hubspotApiKey);
    }

    public void createAssociation(String from, String to, int definition) {
        this.put("/crm-associations/v1/associations", new HubspotAssociation(from, to, definition));
    }

    public <T> T postForObject(String path, Object body, Class<T> clazz) {
        return this.httpClient.postForObject(this.getPathWithParam(path), body, clazz);
    }

    public void put(String path, Object body) {
        this.httpClient.put(this.getPathWithParam(path), body);
    }

    public void delete(String path) {
        this.httpClient.delete(this.getPathWithParam(path));
    }

    public <T> T getForObject(String path, Class<T> clazz) {
        return this.httpClient.getForObject(this.getPathWithParam(path), clazz);
    }

    private String getPathWithParam(String path) {
        return path + "?hapikey=" + this.hubspotApiKey;
    }

    public ContactsClient getContacts() {
        return new ContactsClient(this);
    }

    public CompaniesClient getCompanies() {
        return new CompaniesClient(this);
    }
}

