/*
 * Decompiled with CFR 0.152.
 */
package com.etashkinov.hubspot.contacts;

import com.etashkinov.hubspot.HubspotClient;
import com.etashkinov.hubspot.contacts.HubspotContactProfile;
import com.etashkinov.hubspot.contacts.HubspotContactUpdate;
import com.etashkinov.hubspot.contacts.HubspotCreatedContact;
import java.util.Map;

public class ContactsClient {
    private static final String PATH_CONTACT = "/contacts/v1/contact/";
    private static final String PATH_CONTACT_VID = "/contacts/v1/contact/vid/";
    private static final String PATH_CONTACT_EMAIL = "/contacts/v1/contact/email/";
    private static final int ASSOCIATION_COMPANY = 1;
    private final HubspotClient client;

    public ContactsClient(HubspotClient client) {
        this.client = client;
    }

    public HubspotCreatedContact createOrUpdate(String email, HubspotContactUpdate newContact) {
        String path = "/contacts/v1/contact/createOrUpdate/email/" + email;
        return this.client.postForObject(path, newContact, HubspotCreatedContact.class);
    }

    public HubspotContactProfile getByEmail(String email) {
        return this.client.getForObject(PATH_CONTACT_EMAIL + email + "/profile", HubspotContactProfile.class);
    }

    public HubspotContactProfile getById(String vid) {
        return this.client.getForObject(PATH_CONTACT_VID + vid + "/profile", HubspotContactProfile.class);
    }

    public void delete(String vid) {
        this.client.delete(PATH_CONTACT_VID + vid);
    }

    public void addToCompany(String vid, String companyId) {
        this.client.createAssociation(vid, companyId, 1);
    }

    public void update(String vid, HubspotContactUpdate update) {
        this.client.postForObject(PATH_CONTACT_VID + vid, update, Map.class);
    }
}

