/*
 * Decompiled with CFR 0.152.
 */
package com.etashkinov.hubspot.transport;

import com.etashkinov.hubspot.transport.HttpClient;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public abstract class JacksonHttpClient
implements HttpClient {
    private static final ObjectMapper MAPPER = new ObjectMapper();

    @Override
    public <T> T postForObject(String path, Object body, Class<T> clazz) {
        return this.toObject(this.post(path, this.fromObject(body)), clazz);
    }

    @Override
    public void put(String path, Object body) {
        this.put(path, this.fromObject(body));
    }

    @Override
    public <T> T getForObject(String path, Class<T> clazz) {
        return this.toObject(this.get(path), clazz);
    }

    protected abstract InputStream post(String var1, InputStream var2);

    protected abstract void put(String var1, InputStream var2);

    protected abstract InputStream get(String var1);

    private InputStream fromObject(Object object) {
        try {
            return new ByteArrayInputStream(MAPPER.writeValueAsBytes(object));
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException("Failed to write " + object, e);
        }
    }

    private <T> T toObject(InputStream is, Class<T> clazz) {
        if (is == null) {
            return null;
        }
        try {
            Object object = MAPPER.readValue(is, clazz);
            return (T)object;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to read " + clazz, e);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
    }
}

