/*
 * Decompiled with CFR 0.152.
 */
package com.etashkinov.hubspot.transport;

import com.etashkinov.hubspot.transport.HttpClient;

public class RootPathHttpClient
implements HttpClient {
    private final String rootPath;
    private final HttpClient httpClient;

    public RootPathHttpClient(String rootPath, HttpClient httpClient) {
        this.httpClient = httpClient;
        this.rootPath = rootPath;
    }

    @Override
    public <T> T postForObject(String path, Object body, Class<T> clazz) {
        return this.httpClient.postForObject(this.getAbsolutePath(path), body, clazz);
    }

    private String getAbsolutePath(String path) {
        return this.rootPath + path;
    }

    @Override
    public void put(String path, Object body) {
        this.httpClient.put(this.getAbsolutePath(path), body);
    }

    @Override
    public void delete(String path) {
        this.httpClient.delete(this.getAbsolutePath(path));
    }

    @Override
    public <T> T getForObject(String path, Class<T> clazz) {
        return this.httpClient.getForObject(this.getAbsolutePath(path), clazz);
    }
}

