/*
 * Decompiled with CFR 0.152.
 */
package redis;

import akka.actor.ActorRef;
import akka.actor.ActorRefFactory;
import akka.actor.Props$;
import akka.actor.ScalaActorRef;
import akka.actor.package$;
import java.net.InetSocketAddress;
import redis.ActorRequest;
import redis.ActorRequest$class;
import redis.BufferedRequest;
import redis.BufferedRequest$class;
import redis.ByteStringDeserializer;
import redis.ByteStringSerializer;
import redis.ByteStringSerializer$;
import redis.Cursor;
import redis.Operation;
import redis.Redis$;
import redis.RedisCommand;
import redis.RedisCommands;
import redis.RedisReplyDeserializer;
import redis.actors.RedisClientActor;
import redis.api.Aggregate;
import redis.api.BitOperator;
import redis.api.Limit;
import redis.api.LimitOffsetCount;
import redis.api.ListPivot;
import redis.api.Order;
import redis.api.ShutdownModifier;
import redis.api.scripting.RedisScript;
import redis.commands.Connection$class;
import redis.commands.Hashes$class;
import redis.commands.HyperLogLog$class;
import redis.commands.Keys$class;
import redis.commands.Lists$class;
import redis.commands.Publish$class;
import redis.commands.Scripting$class;
import redis.commands.Server$class;
import redis.commands.Sets$class;
import redis.commands.SortedSets$class;
import redis.commands.Strings$class;
import redis.protocol.RedisReply;
import redis.protocol.Status;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Queue;
import scala.collection.mutable.Builder;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.Future;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005]c!B\u0001\u0003\u0003\u0003)!\u0001\u0006*fI&\u001c8\t\\5f]R\f5\r^8s\u0019&\\WMC\u0001\u0004\u0003\u0015\u0011X\rZ5t\u0007\u0001\u00192\u0001\u0001\u0004\r!\t9!\"D\u0001\t\u0015\u0005I\u0011!B:dC2\f\u0017BA\u0006\t\u0005\u0019\te.\u001f*fMB\u0011QBD\u0007\u0002\u0005%\u0011qB\u0001\u0002\r\u0003\u000e$xN\u001d*fcV,7\u000f\u001e\u0005\t#\u0001\u0011\t\u0011)A\u0005%\u000511/_:uK6\u0004\"a\u0005\r\u000e\u0003QQ!!\u0006\f\u0002\u000b\u0005\u001cGo\u001c:\u000b\u0003]\tA!Y6lC&\u0011\u0011\u0004\u0006\u0002\u0010\u0003\u000e$xN\u001d*fM\u001a\u000b7\r^8ss\")1\u0004\u0001C\u00019\u00051A(\u001b8jiz\"\"!\b\u0010\u0011\u00055\u0001\u0001\"B\t\u001b\u0001\u0004\u0011\u0002b\u0002\u0011\u0001\u0001\u00045\t!I\u0001\u0005Q>\u001cH/F\u0001#!\t\u0019cE\u0004\u0002\bI%\u0011Q\u0005C\u0001\u0007!J,G-\u001a4\n\u0005\u001dB#AB*ue&twM\u0003\u0002&\u0011!9!\u0006\u0001a\u0001\u000e\u0003Y\u0013\u0001\u00035pgR|F%Z9\u0015\u00051z\u0003CA\u0004.\u0013\tq\u0003B\u0001\u0003V]&$\bb\u0002\u0019*\u0003\u0003\u0005\rAI\u0001\u0004q\u0012\n\u0004b\u0002\u001a\u0001\u0001\u00045\taM\u0001\u0005a>\u0014H/F\u00015!\t9Q'\u0003\u00027\u0011\t\u0019\u0011J\u001c;\t\u000fa\u0002\u0001\u0019!D\u0001s\u0005A\u0001o\u001c:u?\u0012*\u0017\u000f\u0006\u0002-u!9\u0001gNA\u0001\u0002\u0004!\u0004b\u0002\u001f\u0001\u0005\u00045\t!I\u0001\u0005]\u0006lW\rC\u0004?\u0001\t\u0007I\u0011A \u0002\u0011A\f7o]<pe\u0012,\u0012\u0001\u0011\t\u0004\u000f\u0005\u0013\u0013B\u0001\"\t\u0005\u0019y\u0005\u000f^5p]\"1A\t\u0001Q\u0001\n\u0001\u000b\u0011\u0002]1tg^|'\u000f\u001a\u0011\t\u000f\u0019\u0003!\u0019!C\u0001\u000f\u0006\u0011AMY\u000b\u0002\u0011B\u0019q!\u0011\u001b\t\r)\u0003\u0001\u0015!\u0003I\u0003\r!'\r\t\u0005\b\u0019\u0002\u0011\r\u0011b\u0001N\u0003A)\u00070Z2vi&|gnQ8oi\u0016DH/F\u0001O!\ty%+D\u0001Q\u0015\t\t\u0006\"\u0001\u0006d_:\u001cWO\u001d:f]RL!a\u0015)\u00031\u0015CXmY;uS>t7i\u001c8uKb$X\t_3dkR|'\u000f\u0003\u0004V\u0001\u0001\u0006IAT\u0001\u0012Kb,7-\u001e;j_:\u001cuN\u001c;fqR\u0004\u0003bB,\u0001\u0005\u0004%\t\u0001W\u0001\u0010e\u0016$\u0017n]\"p]:,7\r^5p]V\t\u0011\f\u0005\u0002\u00145&\u00111\f\u0006\u0002\t\u0003\u000e$xN\u001d*fM\"1Q\f\u0001Q\u0001\ne\u000b\u0001C]3eSN\u001cuN\u001c8fGRLwN\u001c\u0011\t\u000b}\u0003A\u0011\u00011\u0002\u0013I,7m\u001c8oK\u000e$Hc\u0001\u0017bE\"9\u0001E\u0018I\u0001\u0002\u0004\u0011\u0003b\u0002\u001a_!\u0003\u0005\r\u0001\u000e\u0005\u0006I\u0002!\t!Z\u0001\n_:\u001cuN\u001c8fGR$\"\u0001\f4\t\u000b\r\u0019\u0007\u0019A4\u0011\u00055A\u0017BA5\u0003\u00055\u0011V\rZ5t\u0007>lW.\u00198eg\")1\u000e\u0001C\u0001Y\u0006yqN\\\"p]:,7\r^*uCR,8\u000fF\u0001n!\u00119a\u000e\u001d\u0017\n\u0005=D!!\u0003$v]\u000e$\u0018n\u001c82!\t9\u0011/\u0003\u0002s\u0011\t9!i\\8mK\u0006t\u0007\"\u0002;\u0001\t\u0003)\u0018\u0001F4fi\u000e{gN\\3di>\u0003XM]1uS>t7/F\u0001w!\r9q/_\u0005\u0003q\"\u0011\u0011BR;oGRLwN\u001c\u0019\u0011\u000bi\f)!a\u0003\u000f\u0007m\f\tA\u0004\u0002}\u007f6\tQP\u0003\u0002\u007f\t\u00051AH]8pizJ\u0011!C\u0005\u0004\u0003\u0007A\u0011a\u00029bG.\fw-Z\u0005\u0005\u0003\u000f\tIAA\u0002TKFT1!a\u0001\ta\u0019\ti!a\u0006\u0002,A9Q\"a\u0004\u0002\u0014\u0005%\u0012bAA\t\u0005\tIq\n]3sCRLwN\u001c\t\u0005\u0003+\t9\u0002\u0004\u0001\u0005\u0017\u0005e1/!A\u0001\u0002\u000b\u0005\u00111\u0004\u0002\u0004?\u0012\n\u0014\u0003BA\u000f\u0003G\u00012aBA\u0010\u0013\r\t\t\u0003\u0003\u0002\b\u001d>$\b.\u001b8h!\r9\u0011QE\u0005\u0004\u0003OA!aA!osB!\u0011QCA\u0016\t-\tic]A\u0001\u0002\u0003\u0015\t!a\u0007\u0003\u0007}##\u0007C\u0004\u00022\u0001!\t!a\r\u0002\tM$x\u000e\u001d\u000b\u0002Y!I\u0011q\u0007\u0001\u0012\u0002\u0013\u0005\u0011\u0011H\u0001\u0014e\u0016\u001cwN\u001c8fGR$C-\u001a4bk2$H%M\u000b\u0003\u0003wQ3AIA\u001fW\t\ty\u0004\u0005\u0003\u0002B\u0005-SBAA\"\u0015\u0011\t)%a\u0012\u0002\u0013Ut7\r[3dW\u0016$'bAA%\u0011\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u00055\u00131\t\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007\"CA)\u0001E\u0005I\u0011AA*\u0003M\u0011XmY8o]\u0016\u001cG\u000f\n3fM\u0006,H\u000e\u001e\u00133+\t\t)FK\u00025\u0003{\u0001")
public abstract class RedisClientActorLike
implements ActorRequest {
    private final ActorRefFactory system;
    private final Option<String> password;
    private final Option<Object> db;
    private final ExecutionContextExecutor executionContext;
    private final ActorRef redisConnection;

    @Override
    public <T> Future<T> send(RedisCommand<? extends RedisReply, T> redisCommand) {
        return ActorRequest$class.send(this, redisCommand);
    }

    public abstract String host();

    public abstract void host_$eq(String var1);

    public abstract int port();

    public abstract void port_$eq(int var1);

    public abstract String name();

    public Option<String> password() {
        return this.password;
    }

    public Option<Object> db() {
        return this.db;
    }

    public ExecutionContextExecutor executionContext() {
        return this.executionContext;
    }

    @Override
    public ActorRef redisConnection() {
        return this.redisConnection;
    }

    public void reconnect(String host, int port) {
        String string = this.host();
        String string2 = host;
        if ((string != null ? !string.equals(string2) : string2 != null) || this.port() != port) {
            this.host_$eq(host);
            this.port_$eq(port);
            ScalaActorRef qual$1 = package$.MODULE$.actorRef2Scala(this.redisConnection());
            InetSocketAddress x$5 = new InetSocketAddress(host, port);
            ActorRef x$6 = qual$1.$bang$default$2((Object)x$5);
            qual$1.$bang((Object)x$5, x$6);
        }
    }

    public String reconnect$default$1() {
        return this.host();
    }

    public int reconnect$default$2() {
        return this.port();
    }

    public void onConnect(RedisCommands redis) {
        this.password().foreach((Function1)new Serializable(this, redis){
            public static final long serialVersionUID = 0L;
            private final RedisCommands redis$1;

            public final Future<Status> apply(String x$1) {
                return this.redis$1.auth(x$1, ByteStringSerializer$.MODULE$.String());
            }
            {
                this.redis$1 = redis$1;
            }
        });
        this.db().foreach((Function1)new Serializable(this, redis){
            public static final long serialVersionUID = 0L;
            private final RedisCommands redis$1;

            public final Future<Object> apply(int x$2) {
                return this.redis$1.select(x$2);
            }
            {
                this.redis$1 = redis$1;
            }
        });
    }

    public Function1<Object, BoxedUnit> onConnectStatus() {
        return new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(boolean status) {
            }
        };
    }

    public Function0<Seq<Operation<?, ?>>> getConnectOperations() {
        return new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RedisClientActorLike $outer;

            public final Queue<Operation<?, ?>> apply() {
                RedisClientActorLike self = this.$outer;
                BufferedRequest redis = new BufferedRequest(this, self){
                    private final ExecutionContext executionContext;
                    private final Builder<Operation<?, ?>, Queue<Operation<?, ?>>> operations;

                    public <V> Future<Object> pfadd(String key, Seq<V> values, ByteStringSerializer<V> evidence$1) {
                        return HyperLogLog$class.pfadd(this, key, values, evidence$1);
                    }

                    public Future<Object> pfcount(Seq<String> keys) {
                        return HyperLogLog$class.pfcount(this, keys);
                    }

                    public Future<Object> pfmerge(String destKey, Seq<String> sourceKeys) {
                        return HyperLogLog$class.pfmerge(this, destKey, sourceKeys);
                    }

                    public Future<String> bgrewriteaof() {
                        return Server$class.bgrewriteaof(this);
                    }

                    public Future<String> bgsave() {
                        return Server$class.bgsave(this);
                    }

                    public Future<Object> clientKill(String ip, int port) {
                        return Server$class.clientKill(this, ip, port);
                    }

                    public Future<Seq<Map<String, String>>> clientList() {
                        return Server$class.clientList(this);
                    }

                    public Future<Option<String>> clientGetname() {
                        return Server$class.clientGetname(this);
                    }

                    public Future<Object> clientSetname(String connectionName) {
                        return Server$class.clientSetname(this, connectionName);
                    }

                    public Future<Map<String, String>> configGet(String parameter) {
                        return Server$class.configGet(this, parameter);
                    }

                    public Future<Object> configSet(String parameter, String value) {
                        return Server$class.configSet(this, parameter, value);
                    }

                    public Future<Object> configResetstat() {
                        return Server$class.configResetstat(this);
                    }

                    public Future<Object> dbsize() {
                        return Server$class.dbsize(this);
                    }

                    public Future<String> debugObject(String key) {
                        return Server$class.debugObject(this, key);
                    }

                    public Future<String> debugSegfault() {
                        return Server$class.debugSegfault(this);
                    }

                    public Future<Object> flushall() {
                        return Server$class.flushall(this);
                    }

                    public Future<Object> flushdb() {
                        return Server$class.flushdb(this);
                    }

                    public Future<String> info() {
                        return Server$class.info(this);
                    }

                    public Future<String> info(String section) {
                        return Server$class.info(this, section);
                    }

                    public Future<Object> lastsave() {
                        return Server$class.lastsave(this);
                    }

                    public Future<Object> save() {
                        return Server$class.save(this);
                    }

                    public Future<Object> shutdown() {
                        return Server$class.shutdown(this);
                    }

                    public Future<Object> shutdown(ShutdownModifier modifier) {
                        return Server$class.shutdown(this, modifier);
                    }

                    public Future<Object> slaveof(String host, int port) {
                        return Server$class.slaveof(this, host, port);
                    }

                    public Future<Object> slaveofNoOne() {
                        return Server$class.slaveofNoOne(this);
                    }

                    public Future<Tuple2<Object, Object>> time() {
                        return Server$class.time(this);
                    }

                    public <V> Future<Status> auth(V value, ByteStringSerializer<V> evidence$1) {
                        return Connection$class.auth(this, value, evidence$1);
                    }

                    public <V, R> Future<Option<R>> echo(V value, ByteStringSerializer<V> evidence$2, ByteStringDeserializer<R> evidence$3) {
                        return Connection$class.echo(this, value, evidence$2, evidence$3);
                    }

                    public Future<String> ping() {
                        return Connection$class.ping(this);
                    }

                    public Future<Object> quit() {
                        return Connection$class.quit(this);
                    }

                    public Future<Object> select(int index) {
                        return Connection$class.select(this, index);
                    }

                    public <R> Future<R> evalshaOrEval(RedisScript redisScript, Seq<String> keys, Seq<String> args, RedisReplyDeserializer<R> evidence$1) {
                        return Scripting$class.evalshaOrEval(this, redisScript, keys, args, evidence$1);
                    }

                    public <R> Future<R> eval(String script, Seq<String> keys, Seq<String> args, RedisReplyDeserializer<R> evidence$2) {
                        return Scripting$class.eval(this, script, keys, args, evidence$2);
                    }

                    public <R> Future<R> evalsha(String sha12, Seq<String> keys, Seq<String> args, RedisReplyDeserializer<R> evidence$3) {
                        return Scripting$class.evalsha(this, sha12, keys, args, evidence$3);
                    }

                    public Future<Object> scriptFlush() {
                        return Scripting$class.scriptFlush(this);
                    }

                    public Future<Object> scriptKill() {
                        return Scripting$class.scriptKill(this);
                    }

                    public Future<String> scriptLoad(String script) {
                        return Scripting$class.scriptLoad(this, script);
                    }

                    public Future<Seq<Object>> scriptExists(Seq<String> sha12) {
                        return Scripting$class.scriptExists(this, sha12);
                    }

                    public <R> Seq<String> evalshaOrEval$default$2() {
                        return Scripting$class.evalshaOrEval$default$2(this);
                    }

                    public <R> Seq<String> evalshaOrEval$default$3() {
                        return Scripting$class.evalshaOrEval$default$3(this);
                    }

                    public <R> Seq<String> evalsha$default$2() {
                        return Scripting$class.evalsha$default$2(this);
                    }

                    public <R> Seq<String> evalsha$default$3() {
                        return Scripting$class.evalsha$default$3(this);
                    }

                    public <R> Seq<String> eval$default$2() {
                        return Scripting$class.eval$default$2(this);
                    }

                    public <R> Seq<String> eval$default$3() {
                        return Scripting$class.eval$default$3(this);
                    }

                    public <V> Future<Object> publish(String channel, V value, ByteStringSerializer<V> evidence$1) {
                        return Publish$class.publish(this, channel, value, evidence$1);
                    }

                    public <V> Future<Object> zadd(String key, Seq<Tuple2<Object, V>> scoreMembers, ByteStringSerializer<V> evidence$1) {
                        return SortedSets$class.zadd(this, key, scoreMembers, evidence$1);
                    }

                    public Future<Object> zcard(String key) {
                        return SortedSets$class.zcard(this, key);
                    }

                    public Future<Object> zcount(String key, Limit min, Limit max) {
                        return SortedSets$class.zcount(this, key, min, max);
                    }

                    public <V> Future<Object> zincrby(String key, double increment, V member, ByteStringSerializer<V> evidence$2) {
                        return SortedSets$class.zincrby(this, key, increment, member, evidence$2);
                    }

                    public Future<Object> zinterstore(String destination, String key, Seq<String> keys, Aggregate aggregate) {
                        return SortedSets$class.zinterstore(this, destination, key, keys, aggregate);
                    }

                    public Future<Object> zinterstoreWeighted(String destination, Map<String, Object> keys, Aggregate aggregate) {
                        return SortedSets$class.zinterstoreWeighted(this, destination, keys, aggregate);
                    }

                    public <R> Future<Seq<R>> zrange(String key, long start, long stop2, ByteStringDeserializer<R> evidence$3) {
                        return SortedSets$class.zrange(this, key, start, stop2, evidence$3);
                    }

                    public <R> Future<Seq<Tuple2<R, Object>>> zrangeWithscores(String key, long start, long stop2, ByteStringDeserializer<R> evidence$4) {
                        return SortedSets$class.zrangeWithscores(this, key, start, stop2, evidence$4);
                    }

                    public <R> Future<Seq<R>> zrangebyscore(String key, Limit min, Limit max, Option<Tuple2<Object, Object>> limit, ByteStringDeserializer<R> evidence$5) {
                        return SortedSets$class.zrangebyscore(this, key, min, max, limit, evidence$5);
                    }

                    public <R> Future<Seq<Tuple2<R, Object>>> zrangebyscoreWithscores(String key, Limit min, Limit max, Option<Tuple2<Object, Object>> limit, ByteStringDeserializer<R> evidence$6) {
                        return SortedSets$class.zrangebyscoreWithscores(this, key, min, max, limit, evidence$6);
                    }

                    public <V> Future<Option<Object>> zrank(String key, V member, ByteStringSerializer<V> evidence$7) {
                        return SortedSets$class.zrank(this, key, member, evidence$7);
                    }

                    public <V> Future<Object> zrem(String key, Seq<V> members, ByteStringSerializer<V> evidence$8) {
                        return SortedSets$class.zrem(this, key, members, evidence$8);
                    }

                    public Future<Object> zremrangebylex(String key, String min, String max) {
                        return SortedSets$class.zremrangebylex(this, key, min, max);
                    }

                    public Future<Object> zremrangebyrank(String key, long start, long stop2) {
                        return SortedSets$class.zremrangebyrank(this, key, start, stop2);
                    }

                    public Future<Object> zremrangebyscore(String key, Limit min, Limit max) {
                        return SortedSets$class.zremrangebyscore(this, key, min, max);
                    }

                    public <R> Future<Seq<R>> zrevrange(String key, long start, long stop2, ByteStringDeserializer<R> evidence$9) {
                        return SortedSets$class.zrevrange(this, key, start, stop2, evidence$9);
                    }

                    public <R> Future<Seq<Tuple2<R, Object>>> zrevrangeWithscores(String key, long start, long stop2, ByteStringDeserializer<R> evidence$10) {
                        return SortedSets$class.zrevrangeWithscores(this, key, start, stop2, evidence$10);
                    }

                    public <R> Future<Seq<R>> zrevrangebyscore(String key, Limit min, Limit max, Option<Tuple2<Object, Object>> limit, ByteStringDeserializer<R> evidence$11) {
                        return SortedSets$class.zrevrangebyscore(this, key, min, max, limit, evidence$11);
                    }

                    public <R> Future<Seq<Tuple2<R, Object>>> zrevrangebyscoreWithscores(String key, Limit min, Limit max, Option<Tuple2<Object, Object>> limit, ByteStringDeserializer<R> evidence$12) {
                        return SortedSets$class.zrevrangebyscoreWithscores(this, key, min, max, limit, evidence$12);
                    }

                    public <V> Future<Option<Object>> zrevrank(String key, V member, ByteStringSerializer<V> evidence$13) {
                        return SortedSets$class.zrevrank(this, key, member, evidence$13);
                    }

                    public <V> Future<Option<Object>> zscore(String key, V member, ByteStringSerializer<V> evidence$14) {
                        return SortedSets$class.zscore(this, key, member, evidence$14);
                    }

                    public Future<Object> zunionstore(String destination, String key, Seq<String> keys, Aggregate aggregate) {
                        return SortedSets$class.zunionstore(this, destination, key, keys, aggregate);
                    }

                    public Future<Object> zunionstoreWeighted(String destination, Map<String, Object> keys, Aggregate aggregate) {
                        return SortedSets$class.zunionstoreWeighted(this, destination, keys, aggregate);
                    }

                    public <R> Future<Seq<R>> zrangebylex(String key, Option<String> min, Option<String> max, Option<Tuple2<Object, Object>> limit, ByteStringDeserializer<R> evidence$15) {
                        return SortedSets$class.zrangebylex(this, key, min, max, limit, evidence$15);
                    }

                    public <R> Future<Seq<R>> zrevrangebylex(String key, Option<String> max, Option<String> min, Option<Tuple2<Object, Object>> limit, ByteStringDeserializer<R> evidence$16) {
                        return SortedSets$class.zrevrangebylex(this, key, max, min, limit, evidence$16);
                    }

                    public <R> Future<Cursor<Seq<Tuple2<Object, R>>>> zscan(String key, int cursor, Option<Object> count, Option<String> matchGlob, ByteStringDeserializer<R> evidence$17) {
                        return SortedSets$class.zscan(this, key, cursor, count, matchGlob, evidence$17);
                    }

                    public Limit zcount$default$2() {
                        return SortedSets$class.zcount$default$2(this);
                    }

                    public Limit zcount$default$3() {
                        return SortedSets$class.zcount$default$3(this);
                    }

                    public Aggregate zinterstore$default$4() {
                        return SortedSets$class.zinterstore$default$4(this);
                    }

                    public Aggregate zinterstoreWeighted$default$3() {
                        return SortedSets$class.zinterstoreWeighted$default$3(this);
                    }

                    public <R> Option<Tuple2<Object, Object>> zrangebyscore$default$4() {
                        return SortedSets$class.zrangebyscore$default$4(this);
                    }

                    public <R> Option<Tuple2<Object, Object>> zrangebyscoreWithscores$default$4() {
                        return SortedSets$class.zrangebyscoreWithscores$default$4(this);
                    }

                    public <R> Option<Tuple2<Object, Object>> zrevrangebyscore$default$4() {
                        return SortedSets$class.zrevrangebyscore$default$4(this);
                    }

                    public <R> Option<Tuple2<Object, Object>> zrevrangebyscoreWithscores$default$4() {
                        return SortedSets$class.zrevrangebyscoreWithscores$default$4(this);
                    }

                    public Aggregate zunionstore$default$4() {
                        return SortedSets$class.zunionstore$default$4(this);
                    }

                    public Aggregate zunionstoreWeighted$default$3() {
                        return SortedSets$class.zunionstoreWeighted$default$3(this);
                    }

                    public <R> Option<Tuple2<Object, Object>> zrangebylex$default$4() {
                        return SortedSets$class.zrangebylex$default$4(this);
                    }

                    public <R> Option<Tuple2<Object, Object>> zrevrangebylex$default$4() {
                        return SortedSets$class.zrevrangebylex$default$4(this);
                    }

                    public <R> int zscan$default$2() {
                        return SortedSets$class.zscan$default$2(this);
                    }

                    public <R> Option<Object> zscan$default$3() {
                        return SortedSets$class.zscan$default$3(this);
                    }

                    public <R> Option<String> zscan$default$4() {
                        return SortedSets$class.zscan$default$4(this);
                    }

                    public <V> Future<Object> sadd(String key, Seq<V> members, ByteStringSerializer<V> evidence$1) {
                        return Sets$class.sadd(this, key, members, evidence$1);
                    }

                    public Future<Object> scard(String key) {
                        return Sets$class.scard(this, key);
                    }

                    public <R> Future<Seq<R>> sdiff(String key, Seq<String> keys, ByteStringDeserializer<R> evidence$2) {
                        return Sets$class.sdiff(this, key, keys, evidence$2);
                    }

                    public Future<Object> sdiffstore(String destination, String key, Seq<String> keys) {
                        return Sets$class.sdiffstore(this, destination, key, keys);
                    }

                    public <R> Future<Seq<R>> sinter(String key, Seq<String> keys, ByteStringDeserializer<R> evidence$3) {
                        return Sets$class.sinter(this, key, keys, evidence$3);
                    }

                    public Future<Object> sinterstore(String destination, String key, Seq<String> keys) {
                        return Sets$class.sinterstore(this, destination, key, keys);
                    }

                    public <V> Future<Object> sismember(String key, V member, ByteStringSerializer<V> evidence$4) {
                        return Sets$class.sismember(this, key, member, evidence$4);
                    }

                    public <R> Future<Seq<R>> smembers(String key, ByteStringDeserializer<R> evidence$5) {
                        return Sets$class.smembers(this, key, evidence$5);
                    }

                    public <V> Future<Object> smove(String source, String destination, V member, ByteStringSerializer<V> evidence$6) {
                        return Sets$class.smove(this, source, destination, member, evidence$6);
                    }

                    public <R> Future<Option<R>> spop(String key, ByteStringDeserializer<R> evidence$7) {
                        return Sets$class.spop(this, key, evidence$7);
                    }

                    public <R> Future<Option<R>> srandmember(String key, ByteStringDeserializer<R> evidence$8) {
                        return Sets$class.srandmember(this, key, evidence$8);
                    }

                    public <R> Future<Seq<R>> srandmember(String key, long count, ByteStringDeserializer<R> evidence$9) {
                        return Sets$class.srandmember(this, key, count, evidence$9);
                    }

                    public <V> Future<Object> srem(String key, Seq<V> members, ByteStringSerializer<V> evidence$10) {
                        return Sets$class.srem(this, key, members, evidence$10);
                    }

                    public <R> Future<Seq<R>> sunion(String key, Seq<String> keys, ByteStringDeserializer<R> evidence$11) {
                        return Sets$class.sunion(this, key, keys, evidence$11);
                    }

                    public Future<Object> sunionstore(String destination, String key, Seq<String> keys) {
                        return Sets$class.sunionstore(this, destination, key, keys);
                    }

                    public <R> Future<Cursor<Seq<R>>> sscan(String key, int cursor, Option<Object> count, Option<String> matchGlob, ByteStringDeserializer<R> evidence$12) {
                        return Sets$class.sscan(this, key, cursor, count, matchGlob, evidence$12);
                    }

                    public <R> int sscan$default$2() {
                        return Sets$class.sscan$default$2(this);
                    }

                    public <R> Option<Object> sscan$default$3() {
                        return Sets$class.sscan$default$3(this);
                    }

                    public <R> Option<String> sscan$default$4() {
                        return Sets$class.sscan$default$4(this);
                    }

                    public <R> Future<Option<R>> lindex(String key, long index, ByteStringDeserializer<R> evidence$1) {
                        return Lists$class.lindex(this, key, index, evidence$1);
                    }

                    public <V> Future<Object> linsertAfter(String key, String pivot, V value, ByteStringSerializer<V> evidence$2) {
                        return Lists$class.linsertAfter(this, key, pivot, value, evidence$2);
                    }

                    public <V> Future<Object> linsertBefore(String key, String pivot, V value, ByteStringSerializer<V> evidence$3) {
                        return Lists$class.linsertBefore(this, key, pivot, value, evidence$3);
                    }

                    public <V> Future<Object> linsert(String key, ListPivot beforeAfter, String pivot, V value, ByteStringSerializer<V> evidence$4) {
                        return Lists$class.linsert(this, key, beforeAfter, pivot, value, evidence$4);
                    }

                    public Future<Object> llen(String key) {
                        return Lists$class.llen(this, key);
                    }

                    public <R> Future<Option<R>> lpop(String key, ByteStringDeserializer<R> evidence$5) {
                        return Lists$class.lpop(this, key, evidence$5);
                    }

                    public <V> Future<Object> lpush(String key, Seq<V> values, ByteStringSerializer<V> evidence$6) {
                        return Lists$class.lpush(this, key, values, evidence$6);
                    }

                    public <V> Future<Object> lpushx(String key, V value, ByteStringSerializer<V> evidence$7) {
                        return Lists$class.lpushx(this, key, value, evidence$7);
                    }

                    public <R> Future<Seq<R>> lrange(String key, long start, long stop2, ByteStringDeserializer<R> evidence$8) {
                        return Lists$class.lrange(this, key, start, stop2, evidence$8);
                    }

                    public <V> Future<Object> lrem(String key, long count, V value, ByteStringSerializer<V> evidence$9) {
                        return Lists$class.lrem(this, key, count, value, evidence$9);
                    }

                    public <V> Future<Object> lset(String key, long index, V value, ByteStringSerializer<V> evidence$10) {
                        return Lists$class.lset(this, key, index, value, evidence$10);
                    }

                    public Future<Object> ltrim(String key, long start, long stop2) {
                        return Lists$class.ltrim(this, key, start, stop2);
                    }

                    public <R> Future<Option<R>> rpop(String key, ByteStringDeserializer<R> evidence$11) {
                        return Lists$class.rpop(this, key, evidence$11);
                    }

                    public <R> Future<Option<R>> rpoplpush(String source, String destination, ByteStringDeserializer<R> evidence$12) {
                        return Lists$class.rpoplpush(this, source, destination, evidence$12);
                    }

                    public <V> Future<Object> rpush(String key, Seq<V> values, ByteStringSerializer<V> evidence$13) {
                        return Lists$class.rpush(this, key, values, evidence$13);
                    }

                    public <V> Future<Object> rpushx(String key, V value, ByteStringSerializer<V> evidence$14) {
                        return Lists$class.rpushx(this, key, value, evidence$14);
                    }

                    public Future<Object> hdel(String key, Seq<String> fields) {
                        return Hashes$class.hdel(this, key, fields);
                    }

                    public Future<Object> hexists(String key, String field) {
                        return Hashes$class.hexists(this, key, field);
                    }

                    public <R> Future<Option<R>> hget(String key, String field, ByteStringDeserializer<R> evidence$1) {
                        return Hashes$class.hget(this, key, field, evidence$1);
                    }

                    public <R> Future<Map<String, R>> hgetall(String key, ByteStringDeserializer<R> evidence$2) {
                        return Hashes$class.hgetall(this, key, evidence$2);
                    }

                    public Future<Object> hincrby(String key, String fields, long increment) {
                        return Hashes$class.hincrby(this, key, fields, increment);
                    }

                    public Future<Object> hincrbyfloat(String key, String fields, double increment) {
                        return Hashes$class.hincrbyfloat(this, key, fields, increment);
                    }

                    public Future<Seq<String>> hkeys(String key) {
                        return Hashes$class.hkeys(this, key);
                    }

                    public Future<Object> hlen(String key) {
                        return Hashes$class.hlen(this, key);
                    }

                    public <R> Future<Seq<Option<R>>> hmget(String key, Seq<String> fields, ByteStringDeserializer<R> evidence$3) {
                        return Hashes$class.hmget(this, key, fields, evidence$3);
                    }

                    public <V> Future<Object> hmset(String key, Map<String, V> keysValues, ByteStringSerializer<V> evidence$4) {
                        return Hashes$class.hmset(this, key, keysValues, evidence$4);
                    }

                    public <V> Future<Object> hset(String key, String field, V value, ByteStringSerializer<V> evidence$5) {
                        return Hashes$class.hset(this, key, field, value, evidence$5);
                    }

                    public <V> Future<Object> hsetnx(String key, String field, V value, ByteStringSerializer<V> evidence$6) {
                        return Hashes$class.hsetnx(this, key, field, value, evidence$6);
                    }

                    public <R> Future<Seq<R>> hvals(String key, ByteStringDeserializer<R> evidence$7) {
                        return Hashes$class.hvals(this, key, evidence$7);
                    }

                    public <R> Future<Cursor<Map<String, R>>> hscan(String key, int cursor, Option<Object> count, Option<String> matchGlob, ByteStringDeserializer<R> evidence$8) {
                        return Hashes$class.hscan(this, key, cursor, count, matchGlob, evidence$8);
                    }

                    public <R> int hscan$default$2() {
                        return Hashes$class.hscan$default$2(this);
                    }

                    public <R> Option<Object> hscan$default$3() {
                        return Hashes$class.hscan$default$3(this);
                    }

                    public <R> Option<String> hscan$default$4() {
                        return Hashes$class.hscan$default$4(this);
                    }

                    public <V> Future<Object> append(String key, V value, ByteStringSerializer<V> evidence$1) {
                        return Strings$class.append(this, key, value, evidence$1);
                    }

                    public Future<Object> bitcount(String key) {
                        return Strings$class.bitcount(this, key);
                    }

                    public Future<Object> bitcount(String key, long start, long end) {
                        return Strings$class.bitcount(this, key, start, end);
                    }

                    public Future<Object> bitopAND(String destkey, Seq<String> keys) {
                        return Strings$class.bitopAND(this, destkey, keys);
                    }

                    public Future<Object> bitopOR(String destkey, Seq<String> keys) {
                        return Strings$class.bitopOR(this, destkey, keys);
                    }

                    public Future<Object> bitopXOR(String destkey, Seq<String> keys) {
                        return Strings$class.bitopXOR(this, destkey, keys);
                    }

                    public Future<Object> bitopNOT(String destkey, String key) {
                        return Strings$class.bitopNOT(this, destkey, key);
                    }

                    public Future<Object> bitop(BitOperator operation, String destkey, Seq<String> keys) {
                        return Strings$class.bitop(this, operation, destkey, keys);
                    }

                    public Future<Object> decr(String key) {
                        return Strings$class.decr(this, key);
                    }

                    public Future<Object> decrby(String key, long decrement) {
                        return Strings$class.decrby(this, key, decrement);
                    }

                    public <R> Future<Option<R>> get(String key, ByteStringDeserializer<R> evidence$2) {
                        return Strings$class.get(this, key, evidence$2);
                    }

                    public Future<Object> getbit(String key, long offset) {
                        return Strings$class.getbit(this, key, offset);
                    }

                    public <R> Future<Option<R>> getrange(String key, long start, long end, ByteStringDeserializer<R> evidence$3) {
                        return Strings$class.getrange(this, key, start, end, evidence$3);
                    }

                    public <V, R> Future<Option<R>> getset(String key, V value, ByteStringSerializer<V> evidence$4, ByteStringDeserializer<R> evidence$5) {
                        return Strings$class.getset(this, key, value, evidence$4, evidence$5);
                    }

                    public Future<Object> incr(String key) {
                        return Strings$class.incr(this, key);
                    }

                    public Future<Object> incrby(String key, long increment) {
                        return Strings$class.incrby(this, key, increment);
                    }

                    public Future<Option<Object>> incrbyfloat(String key, double increment) {
                        return Strings$class.incrbyfloat(this, key, increment);
                    }

                    public <R> Future<Seq<Option<R>>> mget(Seq<String> keys, ByteStringDeserializer<R> evidence$6) {
                        return Strings$class.mget(this, keys, evidence$6);
                    }

                    public <V> Future<Object> mset(Map<String, V> keysValues, ByteStringSerializer<V> evidence$7) {
                        return Strings$class.mset(this, keysValues, evidence$7);
                    }

                    public <V> Future<Object> msetnx(Map<String, V> keysValues, ByteStringSerializer<V> evidence$8) {
                        return Strings$class.msetnx(this, keysValues, evidence$8);
                    }

                    public <V> Future<Object> psetex(String key, long milliseconds, V value, ByteStringSerializer<V> evidence$9) {
                        return Strings$class.psetex(this, key, milliseconds, value, evidence$9);
                    }

                    public <V> Future<Object> set(String key, V value, Option<Object> exSeconds, Option<Object> pxMilliseconds, boolean NX, boolean XX, ByteStringSerializer<V> evidence$10) {
                        return Strings$class.set(this, key, value, exSeconds, pxMilliseconds, NX, XX, evidence$10);
                    }

                    public Future<Object> setbit(String key, long offset, boolean value) {
                        return Strings$class.setbit(this, key, offset, value);
                    }

                    public <V> Future<Object> setex(String key, long seconds, V value, ByteStringSerializer<V> evidence$11) {
                        return Strings$class.setex(this, key, seconds, value, evidence$11);
                    }

                    public <V> Future<Object> setnx(String key, V value, ByteStringSerializer<V> evidence$12) {
                        return Strings$class.setnx(this, key, value, evidence$12);
                    }

                    public <V> Future<Object> setrange(String key, long offset, V value, ByteStringSerializer<V> evidence$13) {
                        return Strings$class.setrange(this, key, offset, value, evidence$13);
                    }

                    public Future<Object> strlen(String key) {
                        return Strings$class.strlen(this, key);
                    }

                    public <V> Option<Object> set$default$3() {
                        return Strings$class.set$default$3(this);
                    }

                    public <V> Option<Object> set$default$4() {
                        return Strings$class.set$default$4(this);
                    }

                    public <V> boolean set$default$5() {
                        return Strings$class.set$default$5(this);
                    }

                    public <V> boolean set$default$6() {
                        return Strings$class.set$default$6(this);
                    }

                    public Future<Object> del(Seq<String> keys) {
                        return Keys$class.del(this, keys);
                    }

                    public <R> Future<Option<R>> dump(String key, ByteStringDeserializer<R> evidence$1) {
                        return Keys$class.dump(this, key, evidence$1);
                    }

                    public Future<Object> exists(String key) {
                        return Keys$class.exists(this, key);
                    }

                    public Future<Object> expire(String key, long seconds) {
                        return Keys$class.expire(this, key, seconds);
                    }

                    public Future<Object> expireat(String key, long seconds) {
                        return Keys$class.expireat(this, key, seconds);
                    }

                    public Future<Seq<String>> keys(String pattern) {
                        return Keys$class.keys(this, pattern);
                    }

                    public Future<Object> migrate(String host, int port, String key, int destinationDB, FiniteDuration timeout) {
                        return Keys$class.migrate(this, host, port, key, destinationDB, timeout);
                    }

                    public Future<Object> move(String key, int db) {
                        return Keys$class.move(this, key, db);
                    }

                    public Future<Option<Object>> objectRefcount(String key) {
                        return Keys$class.objectRefcount(this, key);
                    }

                    public Future<Option<Object>> objectIdletime(String key) {
                        return Keys$class.objectIdletime(this, key);
                    }

                    public Future<Option<String>> objectEncoding(String key) {
                        return Keys$class.objectEncoding(this, key);
                    }

                    public Future<Object> persist(String key) {
                        return Keys$class.persist(this, key);
                    }

                    public Future<Object> pexpire(String key, long milliseconds) {
                        return Keys$class.pexpire(this, key, milliseconds);
                    }

                    public Future<Object> pexpireat(String key, long millisecondsTimestamp) {
                        return Keys$class.pexpireat(this, key, millisecondsTimestamp);
                    }

                    public Future<Object> pttl(String key) {
                        return Keys$class.pttl(this, key);
                    }

                    public <R> Future<Option<R>> randomkey(ByteStringDeserializer<R> evidence$2) {
                        return Keys$class.randomkey(this, evidence$2);
                    }

                    public Future<Object> rename(String key, String newkey) {
                        return Keys$class.rename(this, key, newkey);
                    }

                    public Future<Object> renamenx(String key, String newkey) {
                        return Keys$class.renamenx(this, key, newkey);
                    }

                    public <V> Future<Object> restore(String key, long ttl, V serializedValue, ByteStringSerializer<V> evidence$3) {
                        return Keys$class.restore(this, key, ttl, serializedValue, evidence$3);
                    }

                    public <R> Future<Seq<R>> sort(String key, Option<String> byPattern, Option<LimitOffsetCount> limit, Seq<String> getPatterns, Option<Order> order, boolean alpha, ByteStringDeserializer<R> evidence$4) {
                        return Keys$class.sort(this, key, byPattern, limit, getPatterns, order, alpha, evidence$4);
                    }

                    public Future<Object> sortStore(String key, Option<String> byPattern, Option<LimitOffsetCount> limit, Seq<String> getPatterns, Option<Order> order, boolean alpha, String store) {
                        return Keys$class.sortStore(this, key, byPattern, limit, getPatterns, order, alpha, store);
                    }

                    public Future<Object> ttl(String key) {
                        return Keys$class.ttl(this, key);
                    }

                    public Future<String> type(String key) {
                        return Keys$class.type(this, key);
                    }

                    public Future<Cursor<Seq<String>>> scan(int cursor, Option<Object> count, Option<String> matchGlob) {
                        return Keys$class.scan(this, cursor, count, matchGlob);
                    }

                    public <V> long restore$default$2() {
                        return Keys$class.restore$default$2(this);
                    }

                    public <R> Option<String> sort$default$2() {
                        return Keys$class.sort$default$2(this);
                    }

                    public <R> Option<LimitOffsetCount> sort$default$3() {
                        return Keys$class.sort$default$3(this);
                    }

                    public <R> Seq<String> sort$default$4() {
                        return Keys$class.sort$default$4(this);
                    }

                    public <R> Option<Order> sort$default$5() {
                        return Keys$class.sort$default$5(this);
                    }

                    public <R> boolean sort$default$6() {
                        return Keys$class.sort$default$6(this);
                    }

                    public Option<String> sortStore$default$2() {
                        return Keys$class.sortStore$default$2(this);
                    }

                    public Option<LimitOffsetCount> sortStore$default$3() {
                        return Keys$class.sortStore$default$3(this);
                    }

                    public Seq<String> sortStore$default$4() {
                        return Keys$class.sortStore$default$4(this);
                    }

                    public Option<Order> sortStore$default$5() {
                        return Keys$class.sortStore$default$5(this);
                    }

                    public boolean sortStore$default$6() {
                        return Keys$class.sortStore$default$6(this);
                    }

                    public int scan$default$1() {
                        return Keys$class.scan$default$1(this);
                    }

                    public Option<Object> scan$default$2() {
                        return Keys$class.scan$default$2(this);
                    }

                    public Option<String> scan$default$3() {
                        return Keys$class.scan$default$3(this);
                    }

                    public Builder<Operation<?, ?>, Queue<Operation<?, ?>>> operations() {
                        return this.operations;
                    }

                    public void redis$BufferedRequest$_setter_$operations_$eq(Builder x$1) {
                        this.operations = x$1;
                    }

                    public <T> Future<T> send(RedisCommand<? extends RedisReply, T> redisCommand) {
                        return BufferedRequest$class.send(this, redisCommand);
                    }

                    public ExecutionContext executionContext() {
                        return this.executionContext;
                    }
                    {
                        BufferedRequest$class.$init$(this);
                        Keys$class.$init$(this);
                        Strings$class.$init$(this);
                        Hashes$class.$init$(this);
                        Lists$class.$init$(this);
                        Sets$class.$init$(this);
                        SortedSets$class.$init$(this);
                        Publish$class.$init$(this);
                        Scripting$class.$init$(this);
                        Connection$class.$init$(this);
                        Server$class.$init$(this);
                        HyperLogLog$class.$init$(this);
                        this.executionContext = self$1.executionContext();
                    }
                };
                this.$outer.onConnect((RedisCommands)((Object)redis));
                return (Queue)redis.operations().result();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        };
    }

    public void stop() {
        this.system.stop(this.redisConnection());
    }

    public RedisClientActorLike(ActorRefFactory system) {
        this.system = system;
        ActorRequest$class.$init$(this);
        this.password = None$.MODULE$;
        this.db = None$.MODULE$;
        this.executionContext = system.dispatcher();
        this.redisConnection = system.actorOf(Props$.MODULE$.apply(RedisClientActor.class, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new InetSocketAddress(this.host(), this.port()), this.getConnectOperations(), this.onConnectStatus()})).withDispatcher(Redis$.MODULE$.dispatcher()), new StringBuilder().append((Object)this.name()).append((Object)BoxesRunTime.boxToCharacter((char)'-')).append((Object)Redis$.MODULE$.tempName()).toString());
    }
}

