/*
 * Decompiled with CFR 0.152.
 */
package redis.actors;

import akka.actor.Actor;
import akka.actor.ActorContext;
import akka.actor.ActorLogging;
import akka.actor.ActorRef;
import akka.actor.ExtensionId;
import akka.actor.SupervisorStrategy;
import akka.actor.package$;
import akka.event.LoggingAdapter;
import akka.io.IO$;
import akka.io.Tcp;
import akka.io.Tcp$;
import akka.util.ByteString;
import akka.util.ByteStringBuilder;
import java.net.InetSocketAddress;
import redis.actors.Reconnect$;
import redis.actors.WriteAck$;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Traversable;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005-g!B\u0001\u0003\u0003\u00039!!\u0004*fI&\u001cxk\u001c:lKJLuJ\u0003\u0002\u0004\t\u00051\u0011m\u0019;peNT\u0011!B\u0001\u0006e\u0016$\u0017n]\u0002\u0001'\u0011\u0001\u0001B\u0004\f\u0011\u0005%aQ\"\u0001\u0006\u000b\u0003-\tQa]2bY\u0006L!!\u0004\u0006\u0003\r\u0005s\u0017PU3g!\tyA#D\u0001\u0011\u0015\t\t\"#A\u0003bGR|'OC\u0001\u0014\u0003\u0011\t7n[1\n\u0005U\u0001\"!B!di>\u0014\bCA\b\u0018\u0013\tA\u0002C\u0001\u0007BGR|'\u000fT8hO&tw\r\u0003\u0005\u001b\u0001\t\u0015\r\u0011\"\u0001\u001c\u0003\u001d\tG\r\u001a:fgN,\u0012\u0001\b\t\u0003;\tj\u0011A\b\u0006\u0003?\u0001\n1A\\3u\u0015\u0005\t\u0013\u0001\u00026bm\u0006L!a\t\u0010\u0003#%sW\r^*pG.,G/\u00113ee\u0016\u001c8\u000f\u0003\u0005&\u0001\t\u0005\t\u0015!\u0003\u001d\u0003!\tG\r\u001a:fgN\u0004\u0003\u0002C\u0014\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0015\u0002\u001f=t7i\u001c8oK\u000e$8\u000b^1ukN\u0004B!C\u0015,]%\u0011!F\u0003\u0002\n\rVt7\r^5p]F\u0002\"!\u0003\u0017\n\u00055R!a\u0002\"p_2,\u0017M\u001c\t\u0003\u0013=J!\u0001\r\u0006\u0003\tUs\u0017\u000e\u001e\u0005\u0006e\u0001!\taM\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007Q2t\u0007\u0005\u00026\u00015\t!\u0001C\u0003\u001bc\u0001\u0007A\u0004C\u0003(c\u0001\u0007\u0001\u0006C\u0004:\u0001\u0001\u0007I\u0011B\u000e\u0002\u0017\r,(O]!eIJ,7o\u001d\u0005\bw\u0001\u0001\r\u0011\"\u0003=\u0003=\u0019WO\u001d:BI\u0012\u0014Xm]:`I\u0015\fHC\u0001\u0018>\u0011\u001dq$(!AA\u0002q\t1\u0001\u001f\u00132\u0011\u0019\u0001\u0005\u0001)Q\u00059\u0005a1-\u001e:s\u0003\u0012$'/Z:tA!9!\t\u0001b\u0001\n\u0003\u0019\u0015a\u0001;daV\tA\t\u0005\u0002\u0010\u000b&\u0011a\t\u0005\u0002\t\u0003\u000e$xN\u001d*fM\"1\u0001\n\u0001Q\u0001\n\u0011\u000bA\u0001^2qA!9!\n\u0001a\u0001\n\u0003\u0019\u0015!\u0003;da^{'o[3s\u0011\u001da\u0005\u00011A\u0005\u00025\u000bQ\u0002^2q/>\u00148.\u001a:`I\u0015\fHC\u0001\u0018O\u0011\u001dq4*!AA\u0002\u0011Ca\u0001\u0015\u0001!B\u0013!\u0015A\u0003;da^{'o[3sA!9!\u000b\u0001b\u0001\n\u0003\u0019\u0016a\u00032vM\u001a,'o\u0016:ji\u0016,\u0012\u0001\u0016\t\u0003+bk\u0011A\u0016\u0006\u0003/J\tA!\u001e;jY&\u0011\u0011L\u0016\u0002\u0012\u0005f$Xm\u0015;sS:<')^5mI\u0016\u0014\bBB.\u0001A\u0003%A+\u0001\u0007ck\u001a4WM],sSR,\u0007\u0005C\u0004^\u0001\u0001\u0007I\u0011\u00010\u0002\u0019I,\u0017\rZ=U_^\u0013\u0018\u000e^3\u0016\u0003-Bq\u0001\u0019\u0001A\u0002\u0013\u0005\u0011-\u0001\tsK\u0006$\u0017\u0010V8Xe&$Xm\u0018\u0013fcR\u0011aF\u0019\u0005\b}}\u000b\t\u00111\u0001,\u0011\u0019!\u0007\u0001)Q\u0005W\u0005i!/Z1esR{wK]5uK\u0002BQA\u001a\u0001\u0005B\u001d\f\u0001\u0002\u001d:f'R\f'\u000f\u001e\u000b\u0002]!)\u0011\u000e\u0001C\u0001O\u0006I!/Z2p]:,7\r\u001e\u0005\u0006W\u0002!\teZ\u0001\ta>\u001cHo\u0015;pa\")Q\u000e\u0001C\u0001O\u0006\u0019\u0012N\\5u\u0007>tg.Z2uK\u0012\u0014UO\u001a4fe\")q\u000e\u0001C\u0001a\u00069!/Z2fSZ,W#A9\u0011\t%\u0011HOL\u0005\u0003g*\u0011q\u0002U1si&\fGNR;oGRLwN\u001c\t\u0003\u0013UL!A\u001e\u0006\u0003\u0007\u0005s\u0017\u0010C\u0003y\u0001\u0011\u0005\u00110\u0001\u0006d_:tWm\u0019;j]\u001e,\u0012A\u001f\t\u0003wrl\u0011\u0001A\u0005\u0003{R\u0011qAU3dK&4X\r\u0003\u0004\u0000\u0001\u0011\u0005\u0011\u0011A\u0001\f_:\u001cuN\u001c8fGR,G\rF\u0002/\u0003\u0007Aq!!\u0002\u007f\u0001\u0004\t9!A\u0002d[\u0012\u0004B!!\u0003\u0002\"9!\u00111BA\u000e\u001d\u0011\ti!a\u0006\u000f\t\u0005=\u0011QC\u0007\u0003\u0003#Q1!a\u0005\u0007\u0003\u0019a$o\\8u}%\t1#C\u0002\u0002\u001aI\t!![8\n\t\u0005u\u0011qD\u0001\u0004)\u000e\u0004(bAA\r%%!\u00111EA\u0013\u0005%\u0019uN\u001c8fGR,GM\u0003\u0003\u0002\u001e\u0005}\u0001bBA\u0015\u0001\u0011\u0005\u00111F\u0001\u001a_:\u001cuN\u001c8fGRLgnZ\"p[6\fg\u000e\u001a$bS2,G\rF\u0002/\u0003[A\u0001\"a\f\u0002(\u0001\u0007\u0011\u0011G\u0001\nG6$g)Y5mK\u0012\u0004B!!\u0003\u00024%!\u0011QGA\u0013\u00055\u0019u.\\7b]\u00124\u0015-\u001b7fI\"1\u0011\u0011\b\u0001\u0005\u0002e\f\u0011bY8o]\u0016\u001cG/\u001a3\t\r\u0005u\u0002\u0001\"\u0003z\u0003\u001d\u0011X-\u00193j]\u001eDq!!\u0011\u0001\t\u0003\t\u0019%\u0001\tp]\u0006#GM]3tg\u000eC\u0017M\\4fIR\u0019a&!\u0012\t\u000f\u0005\u001d\u0013q\ba\u00019\u0005!\u0011\r\u001a3s\u0011\u001d\tY\u0005\u0001C\u0001\u0003\u001b\n!c\u001c8D_:tWm\u0019;j_:\u001cEn\\:fIR\u0019a&a\u0014\t\u0011\u0005E\u0013\u0011\na\u0001\u0003'\n\u0011a\u0019\t\u0005\u0003\u0013\t)&\u0003\u0003\u0002X\u0005\u0015\"\u0001E\"p]:,7\r^5p]\u000ecwn]3e\u0011\u001d\tY\u0006\u0001C\u0001\u0003;\n\u0001d\u001c8D_:tWm\u0019;fI\u000e{W.\\1oI\u001a\u000b\u0017\u000e\\3e)\rq\u0013q\f\u0005\t\u0003C\nI\u00061\u0001\u00022\u0005i1m\\7nC:$g)Y5mK\u0012Da!!\u001a\u0001\t\u00039\u0017!E:dQ\u0016$W\u000f\\3SK\u000e|gN\\3di\"1\u0011\u0011\u000e\u0001\u0005\u0002\u001d\f!b\u00197fC:\u001cF/\u0019;f\u0011\u0019\ti\u0007\u0001D\u0001s\u00069qO]5uS:<\u0007BBA&\u0001\u0019\u0005q\rC\u0004\u0002t\u00011\t!!\u001e\u0002\u001d=tG)\u0019;b%\u0016\u001cW-\u001b<fIR\u0019a&a\u001e\t\u0011\u0005e\u0014\u0011\u000fa\u0001\u0003w\na\u0002Z1uC\nKH/Z*ue&tw\rE\u0002V\u0003{J1!a W\u0005)\u0011\u0015\u0010^3TiJLgn\u001a\u0005\b\u0003\u0007\u0003a\u0011AAC\u0003\u0005zg\u000eR1uCJ+7-Z5wK\u0012|en\u00117pg&twmQ8o]\u0016\u001cG/[8o)\rq\u0013q\u0011\u0005\t\u0003s\n\t\t1\u0001\u0002|!1\u00111\u0012\u0001\u0007\u0002\u001d\f\u0011d\u001c8DY>\u001c\u0018N\\4D_:tWm\u0019;j_:\u001cEn\\:fI\"1\u0011q\u0012\u0001\u0007\u0002\u001d\f1b\u001c8Xe&$XmU3oi\"1\u00111\u0013\u0001\u0005\u0002\u001d\f\u0011C]3ti\u0006\u0014HoQ8o]\u0016\u001cG/[8o\u0011\u001d\t9\n\u0001D\u0001\u00033\u000bab\u001c8D_:tWm\u0019;Xe&$X\r\u0006\u0002\u0002|!1\u0011Q\u0014\u0001\u0005\u0002\u001d\fq\u0002\u001e:z\u0013:LG/[1m/JLG/\u001a\u0005\u0007\u0003C\u0003A\u0011A4\u0002\u0011Q\u0014\u0018p\u0016:ji\u0016Dq!!*\u0001\t\u0003\t9+A\u0003xe&$X\rF\u0002/\u0003SC\u0001\"a+\u0002$\u0002\u0007\u00111P\u0001\u000bEf$Xm\u0015;sS:<\u0007bBAX\u0001\u0011\u0005\u0011\u0011W\u0001\u0012e\u0016\u001cwN\u001c8fGR$UO]1uS>tWCAAZ!\u0011\t),a0\u000e\u0005\u0005]&\u0002BA]\u0003w\u000b\u0001\u0002Z;sCRLwN\u001c\u0006\u0004\u0003{S\u0011AC2p]\u000e,(O]3oi&!\u0011\u0011YA\\\u000591\u0015N\\5uK\u0012+(/\u0019;j_:Dq!!2\u0001\t\u0013\t9-A\u0006xe&$XmV8sW\u0016\u0014Hc\u0001\u0018\u0002J\"A\u00111VAb\u0001\u0004\tY\b")
public abstract class RedisWorkerIO
implements Actor,
ActorLogging {
    private final InetSocketAddress address;
    public final Function1<Object, BoxedUnit> redis$actors$RedisWorkerIO$$onConnectStatus;
    private InetSocketAddress currAddress;
    private final ActorRef tcp;
    private ActorRef tcpWorker;
    private final ByteStringBuilder bufferWrite;
    private boolean readyToWrite;
    private LoggingAdapter akka$actor$ActorLogging$$_log;
    private final ActorContext context;
    private final ActorRef self;

    public LoggingAdapter akka$actor$ActorLogging$$_log() {
        return this.akka$actor$ActorLogging$$_log;
    }

    public void akka$actor$ActorLogging$$_log_$eq(LoggingAdapter x$1) {
        this.akka$actor$ActorLogging$$_log = x$1;
    }

    public LoggingAdapter log() {
        return ActorLogging.class.log((ActorLogging)this);
    }

    public ActorContext context() {
        return this.context;
    }

    public final ActorRef self() {
        return this.self;
    }

    public void akka$actor$Actor$_setter_$context_$eq(ActorContext x$1) {
        this.context = x$1;
    }

    public final void akka$actor$Actor$_setter_$self_$eq(ActorRef x$1) {
        this.self = x$1;
    }

    public final ActorRef sender() {
        return Actor.class.sender((Actor)this);
    }

    public void aroundReceive(PartialFunction<Object, BoxedUnit> receive2, Object msg) {
        Actor.class.aroundReceive((Actor)this, receive2, (Object)msg);
    }

    public void aroundPreStart() {
        Actor.class.aroundPreStart((Actor)this);
    }

    public void aroundPostStop() {
        Actor.class.aroundPostStop((Actor)this);
    }

    public void aroundPreRestart(Throwable reason, Option<Object> message) {
        Actor.class.aroundPreRestart((Actor)this, (Throwable)reason, message);
    }

    public void aroundPostRestart(Throwable reason) {
        Actor.class.aroundPostRestart((Actor)this, (Throwable)reason);
    }

    public SupervisorStrategy supervisorStrategy() {
        return Actor.class.supervisorStrategy((Actor)this);
    }

    public void preRestart(Throwable reason, Option<Object> message) throws Exception {
        Actor.class.preRestart((Actor)this, (Throwable)reason, message);
    }

    public void postRestart(Throwable reason) throws Exception {
        Actor.class.postRestart((Actor)this, (Throwable)reason);
    }

    public void unhandled(Object message) {
        Actor.class.unhandled((Actor)this, (Object)message);
    }

    public InetSocketAddress address() {
        return this.address;
    }

    private InetSocketAddress currAddress() {
        return this.currAddress;
    }

    private void currAddress_$eq(InetSocketAddress x$1) {
        this.currAddress = x$1;
    }

    public ActorRef tcp() {
        return this.tcp;
    }

    public ActorRef tcpWorker() {
        return this.tcpWorker;
    }

    public void tcpWorker_$eq(ActorRef x$1) {
        this.tcpWorker = x$1;
    }

    public ByteStringBuilder bufferWrite() {
        return this.bufferWrite;
    }

    public boolean readyToWrite() {
        return this.readyToWrite;
    }

    public void readyToWrite_$eq(boolean x$1) {
        this.readyToWrite = x$1;
    }

    public void preStart() {
        if (this.tcpWorker() != null) {
            package$.MODULE$.actorRef2Scala(this.tcpWorker()).$bang((Object)Tcp.Close$.MODULE$, this.self());
        }
        this.log().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Connect to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.currAddress()})));
        this.currAddress_$eq(new InetSocketAddress(this.currAddress().getHostName(), this.currAddress().getPort()));
        InetSocketAddress x$2 = this.currAddress();
        Tcp.SO$.KeepAlive keepAlive = new Tcp.SO$.KeepAlive(true);
        List x$3 = Nil$.MODULE$.$colon$colon((Object)keepAlive);
        Option x$4 = Tcp.Connect$.MODULE$.apply$default$2();
        Option x$5 = Tcp.Connect$.MODULE$.apply$default$4();
        boolean x$6 = Tcp.Connect$.MODULE$.apply$default$5();
        package$.MODULE$.actorRef2Scala(this.tcp()).$bang((Object)new Tcp.Connect(x$2, x$4, (Traversable)x$3, x$5, x$6), this.self());
    }

    public void reconnect() {
        this.context().become(this.receive());
        this.preStart();
    }

    public void postStop() {
        this.log().info("RedisWorkerIO stop");
    }

    public void initConnectedBuffer() {
        this.readyToWrite_$eq(true);
    }

    public PartialFunction<Object, BoxedUnit> receive() {
        return this.connecting().orElse(this.writing());
    }

    public PartialFunction<Object, BoxedUnit> connecting() {
        return new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RedisWorkerIO $outer;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof InetSocketAddress) {
                    InetSocketAddress inetSocketAddress = (InetSocketAddress)A1;
                    this.$outer.onAddressChanged(inetSocketAddress);
                    object = BoxedUnit.UNIT;
                } else if (A1 instanceof Tcp.Connected) {
                    Tcp.Connected connected = (Tcp.Connected)A1;
                    this.$outer.onConnected(connected);
                    object = BoxedUnit.UNIT;
                } else {
                    Reconnect$ reconnect$ = Reconnect$.MODULE$;
                    A1 A12 = A1;
                    if (!(reconnect$ != null ? !reconnect$.equals(A12) : A12 != null)) {
                        this.$outer.reconnect();
                        object = BoxedUnit.UNIT;
                    } else if (A1 instanceof Tcp.CommandFailed) {
                        Tcp.CommandFailed commandFailed = (Tcp.CommandFailed)A1;
                        this.$outer.onConnectingCommandFailed(commandFailed);
                        object = BoxedUnit.UNIT;
                    } else if (A1 instanceof Tcp.ConnectionClosed) {
                        this.$outer.onClosingConnectionClosed();
                        object = BoxedUnit.UNIT;
                    } else {
                        object = function1.apply(x1);
                    }
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Object x1) {
                boolean bl;
                Object object = x1;
                if (object instanceof InetSocketAddress) {
                    bl = true;
                } else if (object instanceof Tcp.Connected) {
                    bl = true;
                } else {
                    Reconnect$ reconnect$ = Reconnect$.MODULE$;
                    Object object2 = object;
                    bl = !(reconnect$ != null ? !reconnect$.equals(object2) : object2 != null) ? true : (object instanceof Tcp.CommandFailed ? true : object instanceof Tcp.ConnectionClosed);
                }
                return bl;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        };
    }

    public void onConnected(Tcp.Connected cmd) {
        package$.MODULE$.actorRef2Scala(this.sender()).$bang((Object)new Tcp.Register(this.self(), Tcp.Register$.MODULE$.apply$default$2(), Tcp.Register$.MODULE$.apply$default$3()), this.self());
        this.tcpWorker_$eq(this.sender());
        this.initConnectedBuffer();
        this.tryInitialWrite();
        this.context().become(this.connected());
        this.log().info(new StringBuilder().append((Object)"Connected to ").append((Object)cmd.remoteAddress()).toString());
        this.redis$actors$RedisWorkerIO$$onConnectStatus.apply((Object)BoxesRunTime.boxToBoolean((boolean)true));
    }

    public void onConnectingCommandFailed(Tcp.CommandFailed cmdFailed) {
        this.log().error(cmdFailed.toString());
        this.scheduleReconnect();
    }

    public PartialFunction<Object, BoxedUnit> connected() {
        return this.writing().orElse(this.reading());
    }

    private PartialFunction<Object, BoxedUnit> reading() {
        return new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RedisWorkerIO $outer;

            public final <A1, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x2;
                WriteAck$ writeAck$ = WriteAck$.MODULE$;
                A1 A12 = A1;
                if (!(writeAck$ != null ? !writeAck$.equals(A12) : A12 != null)) {
                    this.$outer.tryWrite();
                    object = BoxedUnit.UNIT;
                } else if (A1 instanceof Tcp.Received) {
                    BoxedUnit boxedUnit;
                    Tcp.Received received = (Tcp.Received)A1;
                    ByteString dataByteString = received.data();
                    ActorRef actorRef = this.$outer.sender();
                    ActorRef actorRef2 = this.$outer.tcpWorker();
                    if (!(actorRef != null ? !actorRef.equals(actorRef2) : actorRef2 != null)) {
                        this.$outer.onDataReceived(dataByteString);
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        this.$outer.onDataReceivedOnClosingConnection(dataByteString);
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    object = boxedUnit;
                } else if (A1 instanceof InetSocketAddress) {
                    InetSocketAddress inetSocketAddress = (InetSocketAddress)A1;
                    this.$outer.onAddressChanged(inetSocketAddress);
                    object = BoxedUnit.UNIT;
                } else if (A1 instanceof Tcp.ConnectionClosed) {
                    BoxedUnit boxedUnit;
                    Tcp.ConnectionClosed connectionClosed = (Tcp.ConnectionClosed)A1;
                    ActorRef actorRef = this.$outer.sender();
                    ActorRef actorRef3 = this.$outer.tcpWorker();
                    if (!(actorRef != null ? !actorRef.equals(actorRef3) : actorRef3 != null)) {
                        this.$outer.onConnectionClosed(connectionClosed);
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        this.$outer.redis$actors$RedisWorkerIO$$onConnectStatus.apply((Object)BoxesRunTime.boxToBoolean((boolean)false));
                        this.$outer.onClosingConnectionClosed();
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    object = boxedUnit;
                } else if (A1 instanceof Tcp.CommandFailed) {
                    Tcp.CommandFailed commandFailed = (Tcp.CommandFailed)A1;
                    this.$outer.onConnectedCommandFailed(commandFailed);
                    object = BoxedUnit.UNIT;
                } else {
                    object = function1.apply(x2);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Object x2) {
                Object object = x2;
                WriteAck$ writeAck$ = WriteAck$.MODULE$;
                Object object2 = object;
                boolean bl = !(writeAck$ != null ? !writeAck$.equals(object2) : object2 != null) ? true : (object instanceof Tcp.Received ? true : (object instanceof InetSocketAddress ? true : (object instanceof Tcp.ConnectionClosed ? true : object instanceof Tcp.CommandFailed)));
                return bl;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        };
    }

    public void onAddressChanged(InetSocketAddress addr) {
        this.log().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Address change [old=", ", new=", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.address(), addr})));
        package$.MODULE$.actorRef2Scala(this.tcpWorker()).$bang((Object)Tcp.ConfirmedClose$.MODULE$, this.self());
        this.currAddress_$eq(addr);
        this.scheduleReconnect();
    }

    public void onConnectionClosed(Tcp.ConnectionClosed c) {
        this.log().warning(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ConnectionClosed ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{c})));
        this.scheduleReconnect();
    }

    public void onConnectedCommandFailed(Tcp.CommandFailed commandFailed) {
        this.log().error(commandFailed.toString());
        package$.MODULE$.actorRef2Scala(this.tcpWorker()).$bang((Object)commandFailed.cmd(), this.self());
    }

    public void scheduleReconnect() {
        this.cleanState();
        this.log().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Trying to reconnect in ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.reconnectDuration()})));
        this.context().system().scheduler().scheduleOnce(this.reconnectDuration(), this.self(), (Object)Reconnect$.MODULE$, (ExecutionContext)this.context().dispatcher(), this.self());
        this.context().become(this.receive());
    }

    public void cleanState() {
        this.redis$actors$RedisWorkerIO$$onConnectStatus.apply((Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.onConnectionClosed();
        this.readyToWrite_$eq(false);
        this.bufferWrite().clear();
    }

    public abstract PartialFunction<Object, BoxedUnit> writing();

    public abstract void onConnectionClosed();

    public abstract void onDataReceived(ByteString var1);

    public abstract void onDataReceivedOnClosingConnection(ByteString var1);

    public abstract void onClosingConnectionClosed();

    public abstract void onWriteSent();

    public void restartConnection() {
        this.reconnect();
    }

    public abstract ByteString onConnectWrite();

    public void tryInitialWrite() {
        ByteString data = this.onConnectWrite();
        if (data.nonEmpty()) {
            this.writeWorker(data.$plus$plus(this.bufferWrite().result()));
            this.bufferWrite().clear();
        } else {
            this.tryWrite();
        }
    }

    public void tryWrite() {
        if (this.bufferWrite().length() == 0) {
            this.readyToWrite_$eq(true);
        } else {
            this.writeWorker(this.bufferWrite().result());
            this.bufferWrite().clear();
        }
    }

    public void write(ByteString byteString) {
        if (this.readyToWrite()) {
            this.writeWorker(byteString);
        } else {
            this.bufferWrite().append(byteString);
        }
    }

    public FiniteDuration reconnectDuration() {
        return new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(2)).seconds();
    }

    private void writeWorker(ByteString byteString) {
        this.onWriteSent();
        package$.MODULE$.actorRef2Scala(this.tcpWorker()).$bang((Object)new Tcp.Write(byteString, (Tcp.Event)WriteAck$.MODULE$), this.self());
        this.readyToWrite_$eq(false);
    }

    public RedisWorkerIO(InetSocketAddress address, Function1<Object, BoxedUnit> onConnectStatus2) {
        this.address = address;
        this.redis$actors$RedisWorkerIO$$onConnectStatus = onConnectStatus2;
        Actor.class.$init$((Actor)this);
        ActorLogging.class.$init$((ActorLogging)this);
        this.currAddress = address;
        this.tcp = IO$.MODULE$.apply((ExtensionId)Tcp$.MODULE$, this.context().system());
        this.tcpWorker = null;
        this.bufferWrite = new ByteStringBuilder();
        this.readyToWrite = false;
    }
}

