/*
 * Decompiled with CFR 0.152.
 */
package redis.api.scripting;

import java.io.File;
import java.security.MessageDigest;
import redis.api.scripting.RedisScript$;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\u0005Er!B\u0001\u0003\u0011\u0003I\u0011a\u0003*fI&\u001c8k\u0019:jaRT!a\u0001\u0003\u0002\u0013M\u001c'/\u001b9uS:<'BA\u0003\u0007\u0003\r\t\u0007/\u001b\u0006\u0002\u000f\u0005)!/\u001a3jg\u000e\u0001\u0001C\u0001\u0006\f\u001b\u0005\u0011a!\u0002\u0007\u0003\u0011\u0003i!a\u0003*fI&\u001c8k\u0019:jaR\u001c2a\u0003\b\u0015!\ty!#D\u0001\u0011\u0015\u0005\t\u0012!B:dC2\f\u0017BA\n\u0011\u0005\u0019\te.\u001f*fMB\u0011q\"F\u0005\u0003-A\u0011AbU3sS\u0006d\u0017N_1cY\u0016DQ\u0001G\u0006\u0005\u0002e\ta\u0001P5oSRtD#A\u0005\t\u000bmYA\u0011\u0001\u000f\u0002\u0011\u0019\u0014x.\u001c$jY\u0016$\"!H=\u0011\u0005)qb\u0001\u0002\u0007\u0003\u0001~\u0019BA\b\b!)A\u0011q\"I\u0005\u0003EA\u0011q\u0001\u0015:pIV\u001cG\u000f\u0003\u0005%=\tU\r\u0011\"\u0001&\u0003\u0019\u00198M]5qiV\ta\u0005\u0005\u0002(U9\u0011q\u0002K\u0005\u0003SA\ta\u0001\u0015:fI\u00164\u0017BA\u0016-\u0005\u0019\u0019FO]5oO*\u0011\u0011\u0006\u0005\u0005\t]y\u0011\t\u0012)A\u0005M\u000591o\u0019:jaR\u0004\u0003\"\u0002\r\u001f\t\u0003\u0001DCA\u000f2\u0011\u0015!s\u00061\u0001'\u0011!\u0019d\u0004#b\u0001\n\u0003)\u0013\u0001B:iCFB\u0001\"\u000e\u0010\t\u0002\u0003\u0006KAJ\u0001\u0006g\"\f\u0017\u0007\t\u0005\boy\t\t\u0011\"\u00019\u0003\u0011\u0019w\u000e]=\u0015\u0005uI\u0004b\u0002\u00137!\u0003\u0005\rA\n\u0005\bwy\t\n\u0011\"\u0001=\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\u0012!\u0010\u0016\u0003MyZ\u0013a\u0010\t\u0003\u0001\u0016k\u0011!\u0011\u0006\u0003\u0005\u000e\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0005\u0011\u0003\u0012AC1o]>$\u0018\r^5p]&\u0011a)\u0011\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007b\u0002%\u001f\u0003\u0003%\t%S\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0003)\u0003\"a\u0013)\u000e\u00031S!!\u0014(\u0002\t1\fgn\u001a\u0006\u0002\u001f\u0006!!.\u0019<b\u0013\tYC\nC\u0004S=\u0005\u0005I\u0011A*\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0003Q\u0003\"aD+\n\u0005Y\u0003\"aA%oi\"9\u0001LHA\u0001\n\u0003I\u0016A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u00035v\u0003\"aD.\n\u0005q\u0003\"aA!os\"9alVA\u0001\u0002\u0004!\u0016a\u0001=%c!9\u0001MHA\u0001\n\u0003\n\u0017a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0003\t\u00042a\u00194[\u001b\u0005!'BA3\u0011\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003O\u0012\u0014\u0001\"\u0013;fe\u0006$xN\u001d\u0005\bSz\t\t\u0011\"\u0001k\u0003!\u0019\u0017M\\#rk\u0006dGCA6o!\tyA.\u0003\u0002n!\t9!i\\8mK\u0006t\u0007b\u00020i\u0003\u0003\u0005\rA\u0017\u0005\baz\t\t\u0011\"\u0011r\u0003!A\u0017m\u001d5D_\u0012,G#\u0001+\t\u000fMt\u0012\u0011!C!i\u0006AAo\\*ue&tw\rF\u0001K\u0011\u001d1h$!A\u0005B]\fa!Z9vC2\u001cHCA6y\u0011\u001dqV/!AA\u0002iCQA\u001f\u000eA\u0002m\fAAZ5mKB\u0011Ap`\u0007\u0002{*\u0011aPT\u0001\u0003S>L1!!\u0001~\u0005\u00111\u0015\u000e\\3\t\u000f\u0005\u00151\u0002\"\u0001\u0002\b\u0005aaM]8n%\u0016\u001cx.\u001e:dKR\u0019Q$!\u0003\t\u000f\u0005-\u00111\u0001a\u0001M\u0005!\u0001/\u0019;i\u0011%\tyaCA\u0001\n\u0003\u000b\t\"A\u0003baBd\u0017\u0010F\u0002\u001e\u0003'Aa\u0001JA\u0007\u0001\u00041\u0003\"CA\f\u0017\u0005\u0005I\u0011QA\r\u0003\u001d)h.\u00199qYf$B!a\u0007\u0002\"A!q\"!\b'\u0013\r\ty\u0002\u0005\u0002\u0007\u001fB$\u0018n\u001c8\t\u0013\u0005\r\u0012QCA\u0001\u0002\u0004i\u0012a\u0001=%a!I\u0011qE\u0006\u0002\u0002\u0013%\u0011\u0011F\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0002,A\u00191*!\f\n\u0007\u0005=BJ\u0001\u0004PE*,7\r\u001e")
public class RedisScript
implements Product,
Serializable {
    private final String script;
    private String sha1;
    private volatile boolean bitmap$0;

    public static RedisScript fromResource(String string) {
        return RedisScript$.MODULE$.fromResource(string);
    }

    public static RedisScript fromFile(File file) {
        return RedisScript$.MODULE$.fromFile(file);
    }

    private String sha1$lzycompute() {
        RedisScript redisScript = this;
        synchronized (redisScript) {
            if (!this.bitmap$0) {
                MessageDigest messageDigestSha1 = MessageDigest.getInstance("SHA-1");
                this.sha1 = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.byteArrayOps(messageDigestSha1.digest(this.script().getBytes("UTF-8"))).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(byte x$1) {
                        return new StringOps(Predef$.MODULE$.augmentString("%02x")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToByte((byte)x$1)}));
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).mkString();
                this.bitmap$0 = true;
            }
            return this.sha1;
        }
    }

    public String script() {
        return this.script;
    }

    public String sha1() {
        return this.bitmap$0 ? this.sha1 : this.sha1$lzycompute();
    }

    public RedisScript copy(String script) {
        return new RedisScript(script);
    }

    public String copy$default$1() {
        return this.script();
    }

    public String productPrefix() {
        return "RedisScript";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 0: 
        }
        return this.script();
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof RedisScript;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof RedisScript)) return false;
        boolean bl = true;
        if (!bl) return false;
        RedisScript redisScript = (RedisScript)x$1;
        String string = this.script();
        String string2 = redisScript.script();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        if (!redisScript.canEqual(this)) return false;
        return true;
    }

    public RedisScript(String script) {
        this.script = script;
        Product.class.$init$((Product)this);
    }
}

