/*
 * Decompiled with CFR 0.152.
 */
package redis.protocol;

import akka.util.ByteString;
import redis.protocol.Bulk;
import redis.protocol.DecodeResult;
import redis.protocol.Error;
import redis.protocol.FullyDecoded;
import redis.protocol.Integer;
import redis.protocol.MultiBulk;
import redis.protocol.PartiallyDecoded;
import redis.protocol.RedisProtocolReply$;
import redis.protocol.RedisReply;
import redis.protocol.Status;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Builder;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.runtime.BoxesRunTime;

public final class RedisProtocolReply$ {
    public static final RedisProtocolReply$ MODULE$;
    private final char ERROR;
    private final char STATUS;
    private final char INTEGER;
    private final char BULK;
    private final char MULTIBULK;
    private final byte[] LS;
    private final PartialFunction<ByteString, DecodeResult<RedisReply>> decodeReplyPF;
    private final PartialFunction<ByteString, DecodeResult<Status>> decodeReplyStatus;
    private final PartialFunction<ByteString, DecodeResult<Integer>> decodeReplyInteger;
    private final PartialFunction<ByteString, DecodeResult<Bulk>> decodeReplyBulk;
    private final PartialFunction<ByteString, DecodeResult<MultiBulk>> decodeReplyMultiBulk;
    private final PartialFunction<ByteString, DecodeResult<Error>> decodeReplyError;

    static {
        new RedisProtocolReply$();
    }

    public char ERROR() {
        return this.ERROR;
    }

    public char STATUS() {
        return this.STATUS;
    }

    public char INTEGER() {
        return this.INTEGER;
    }

    public char BULK() {
        return this.BULK;
    }

    public char MULTIBULK() {
        return this.MULTIBULK;
    }

    public byte[] LS() {
        return this.LS;
    }

    public DecodeResult<RedisReply> decodeReply(ByteString bs) {
        block9: {
            DecodeResult<RedisReply> decodeResult;
            block3: {
                DecodeResult<Object> decodeResult2;
                block5: {
                    byte by;
                    block8: {
                        block7: {
                            block6: {
                                block4: {
                                    block2: {
                                        if (!bs.isEmpty()) break block2;
                                        decodeResult = new PartiallyDecoded<RedisReply>(bs, (Function1<ByteString, DecodeResult<RedisReply>>)new Serializable(){
                                            public static final long serialVersionUID = 0L;

                                            public final DecodeResult<RedisReply> apply(ByteString bs) {
                                                return RedisProtocolReply$.MODULE$.decodeReply(bs);
                                            }
                                        });
                                        break block3;
                                    }
                                    by = bs.head();
                                    if (this.ERROR() != by) break block4;
                                    decodeResult2 = this.decodeString(bs.tail()).map(new Serializable(){
                                        public static final long serialVersionUID = 0L;

                                        public final Error apply(ByteString x$3) {
                                            return new Error(x$3);
                                        }
                                    });
                                    break block5;
                                }
                                if (this.INTEGER() != by) break block6;
                                decodeResult2 = this.decodeInteger(bs.tail());
                                break block5;
                            }
                            if (this.STATUS() != by) break block7;
                            decodeResult2 = this.decodeString(bs.tail()).map(new Serializable(){
                                public static final long serialVersionUID = 0L;

                                public final Status apply(ByteString x$4) {
                                    return new Status(x$4);
                                }
                            });
                            break block5;
                        }
                        if (this.BULK() != by) break block8;
                        decodeResult2 = this.decodeBulk(bs.tail());
                        break block5;
                    }
                    if (this.MULTIBULK() != by) break block9;
                    decodeResult2 = this.decodeMultiBulk(bs.tail());
                }
                decodeResult = decodeResult2;
            }
            return decodeResult;
        }
        throw new Exception(new StringBuilder().append((Object)"Redis Protocol error: Got ").append((Object)BoxesRunTime.boxToByte((byte)bs.head())).append((Object)" as initial reply byte >>").append((Object)bs.tail().utf8String()).toString());
    }

    public PartialFunction<ByteString, DecodeResult<RedisReply>> decodeReplyPF() {
        return this.decodeReplyPF;
    }

    public PartialFunction<ByteString, DecodeResult<Status>> decodeReplyStatus() {
        return this.decodeReplyStatus;
    }

    public PartialFunction<ByteString, DecodeResult<Integer>> decodeReplyInteger() {
        return this.decodeReplyInteger;
    }

    public PartialFunction<ByteString, DecodeResult<Bulk>> decodeReplyBulk() {
        return this.decodeReplyBulk;
    }

    public PartialFunction<ByteString, DecodeResult<MultiBulk>> decodeReplyMultiBulk() {
        return this.decodeReplyMultiBulk;
    }

    public PartialFunction<ByteString, DecodeResult<Error>> decodeReplyError() {
        return this.decodeReplyError;
    }

    public DecodeResult<Integer> decodeInteger(ByteString bs) {
        return this.decodeString(bs).map(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Integer apply(ByteString string) {
                return new Integer(string);
            }
        });
    }

    public DecodeResult<ByteString> decodeString(ByteString bs) {
        Product product;
        int index = bs.indexOf((Object)BoxesRunTime.boxToCharacter((char)'\n'));
        if (index >= 0 && bs.length() >= index + 1) {
            ByteString reply = bs.take(index + 1 - this.LS().length);
            ByteString tail = bs.drop(index + 1);
            FullyDecoded<ByteString> r = new FullyDecoded<ByteString>(reply, tail);
            product = r;
        } else {
            product = new PartiallyDecoded<ByteString>(bs, (Function1<ByteString, DecodeResult<ByteString>>)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final DecodeResult<ByteString> apply(ByteString bs) {
                    return RedisProtocolReply$.MODULE$.decodeString(bs);
                }
            });
        }
        return product;
    }

    public DecodeResult<Bulk> decodeBulk(ByteString bs) {
        return this.decodeInteger(bs).flatMap(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final DecodeResult<Bulk> apply(Integer integer, ByteString bsRest) {
                return RedisProtocolReply$.MODULE$.redis$protocol$RedisProtocolReply$$decodeBulkBody$1(integer, bsRest);
            }
        });
    }

    public DecodeResult<MultiBulk> decodeMultiBulk(ByteString bs) {
        return this.decodeInteger(bs).flatMap(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final DecodeResult<MultiBulk> apply(Integer integer, ByteString bsRest) {
                DecodeResult<MultiBulk> decodeResult;
                int i = integer.toInt();
                if (i < 0) {
                    decodeResult = new FullyDecoded<MultiBulk>(new MultiBulk((Option<Vector<RedisReply>>)None$.MODULE$), bsRest);
                } else if (i == 0) {
                    decodeResult = new FullyDecoded<MultiBulk>(new MultiBulk((Option<Vector<RedisReply>>)new Some((Object)package$.MODULE$.Vector().empty())), bsRest);
                } else {
                    Builder builder = package$.MODULE$.Vector().newBuilder();
                    builder.sizeHint(i);
                    decodeResult = RedisProtocolReply$.MODULE$.bulks(i, (Builder<RedisReply, Vector<RedisReply>>)builder, bsRest);
                }
                return decodeResult;
            }
        });
    }

    public DecodeResult<MultiBulk> bulks(int i, Builder<RedisReply, Vector<RedisReply>> builder, ByteString byteString) {
        return this.helper$1(i, byteString, builder).flatMap(new Serializable(builder){
            public static final long serialVersionUID = 0L;
            private final Builder builder$1;

            public final DecodeResult<MultiBulk> apply(int i, ByteString bs) {
                return i > 0 ? RedisProtocolReply$.MODULE$.bulks(i, (Builder<RedisReply, Vector<RedisReply>>)this.builder$1, bs) : new FullyDecoded<MultiBulk>(new MultiBulk((Option<Vector<RedisReply>>)new Some(this.builder$1.result())), bs);
            }
            {
                this.builder$1 = builder$1;
            }
        });
    }

    public final DecodeResult redis$protocol$RedisProtocolReply$$decodeBulkBody$1(Integer integer, ByteString bsRest) {
        FullyDecoded<Bulk> fullyDecoded;
        int i = integer.toInt();
        if (i < 0) {
            fullyDecoded = new FullyDecoded<Bulk>(new Bulk((Option<ByteString>)None$.MODULE$), bsRest);
        } else if (bsRest.length() < i + this.LS().length) {
            fullyDecoded = new PartiallyDecoded(bsRest, new Serializable(integer){
                public static final long serialVersionUID = 0L;
                private final Integer integer$1;

                public final DecodeResult<Bulk> apply(ByteString x$8) {
                    return RedisProtocolReply$.MODULE$.redis$protocol$RedisProtocolReply$$decodeBulkBody$1(this.integer$1, x$8);
                }
                {
                    this.integer$1 = integer$1;
                }
            });
        } else {
            ByteString data = bsRest.take(i);
            fullyDecoded = new FullyDecoded<Bulk>(new Bulk((Option<ByteString>)new Some((Object)data)), bsRest.drop(i).drop(this.LS().length));
        }
        return fullyDecoded;
    }

    private final DecodeResult helper$1(int i, ByteString bs, Builder builder$1) {
        DecodeResult<java.lang.Integer> decodeResult;
        block2: {
            while (i > 0) {
                DecodeResult reply = this.decodeReply(bs).map(new Serializable(builder$1, i){
                    public static final long serialVersionUID = 0L;
                    private final Builder builder$1;
                    private final int i$1;

                    public final int apply(RedisReply r) {
                        this.builder$1.$plus$eq((Object)r);
                        return this.i$1 - 1;
                    }
                    {
                        this.builder$1 = builder$1;
                        this.i$1 = i$1;
                    }
                });
                if (reply.isFullyDecoded()) {
                    bs = reply.rest();
                    --i;
                    continue;
                }
                decodeResult = reply;
                break block2;
            }
            decodeResult = new FullyDecoded<java.lang.Integer>(BoxesRunTime.boxToInteger((int)0), bs);
        }
        return decodeResult;
    }

    private RedisProtocolReply$() {
        MODULE$ = this;
        this.ERROR = (char)45;
        this.STATUS = (char)43;
        this.INTEGER = (char)58;
        this.BULK = (char)36;
        this.MULTIBULK = (char)42;
        this.LS = "\r\n".getBytes("UTF-8");
        this.decodeReplyPF = new anonfun.1();
        this.decodeReplyStatus = new anonfun.2();
        this.decodeReplyInteger = new anonfun.3();
        this.decodeReplyBulk = new anonfun.4();
        this.decodeReplyMultiBulk = new anonfun.5();
        this.decodeReplyError = new anonfun.6();
    }
}

