/*
 * Decompiled with CFR 0.152.
 */
package redis;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.dispatch.MessageDispatcher;
import java.io.Serializable;
import java.net.InetSocketAddress;
import redis.BufferedRequest;
import redis.ByteStringDeserializer;
import redis.ByteStringSerializer;
import redis.ByteStringSerializer$;
import redis.Cursor;
import redis.Operation;
import redis.Redis$;
import redis.RedisCommand;
import redis.RedisCommands;
import redis.RedisConnection;
import redis.RedisDispatcher;
import redis.RedisReplyDeserializer;
import redis.RedisServer;
import redis.actors.RedisClientActor$;
import redis.api.Aggregate;
import redis.api.BitOperator;
import redis.api.Limit;
import redis.api.LimitOffsetCount;
import redis.api.ListPivot;
import redis.api.Order;
import redis.api.ShutdownModifier;
import redis.api.ZaddOption;
import redis.api.clusters.ClusterSlot;
import redis.api.geo.DistUnits;
import redis.api.geo.GeoOptions;
import redis.api.scripting.RedisScript;
import redis.commands.Clusters;
import redis.commands.Connection;
import redis.commands.Geo;
import redis.commands.Hashes;
import redis.commands.HyperLogLog;
import redis.commands.Keys;
import redis.commands.Lists;
import redis.commands.Publish;
import redis.commands.Scripting;
import redis.commands.Server;
import redis.commands.Sets;
import redis.commands.SortedSets;
import redis.commands.Strings;
import redis.protocol.RedisReply;
import redis.protocol.Status;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Queue;
import scala.collection.mutable.Builder;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.stm.Ref;
import scala.concurrent.stm.Ref$;
import scala.reflect.ClassManifestFactory$;
import scala.reflect.OptManifest;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00055g!B\u0001\u0003\u0003\u0003)!a\u0005*fI&\u001c8\t\\5f]R\u0004vn\u001c7MS.,'\"A\u0002\u0002\u000bI,G-[:\u0004\u0001M\u0011\u0001A\u0002\t\u0003\u000f)i\u0011\u0001\u0003\u0006\u0002\u0013\u0005)1oY1mC&\u00111\u0002\u0003\u0002\u0007\u0003:L(+\u001a4\t\u00115\u0001!\u0011!Q\u0001\n9\taa]=ti\u0016l\u0007CA\b\u0015\u001b\u0005\u0001\"BA\t\u0013\u0003\u0015\t7\r^8s\u0015\u0005\u0019\u0012\u0001B1lW\u0006L!!\u0006\t\u0003\u0017\u0005\u001bGo\u001c:TsN$X-\u001c\u0005\t/\u0001\u0011\t\u0011)A\u00051\u0005y!/\u001a3jg\u0012K7\u000f]1uG\",'\u000f\u0005\u0002\u001a55\t!!\u0003\u0002\u001c\u0005\ty!+\u001a3jg\u0012K7\u000f]1uG\",'\u000fC\u0003\u001e\u0001\u0011\u0005a$\u0001\u0004=S:LGO\u0010\u000b\u0004?\u0001\n\u0003CA\r\u0001\u0011\u0015iA\u00041\u0001\u000f\u0011\u00159B\u00041\u0001\u0019\u0011\u0015\u0019\u0003A\"\u0001%\u0003Y\u0011X\rZ5t'\u0016\u0014h/\u001a:D_:tWm\u0019;j_:\u001cX#A\u0013\u0011\t\u0019J3FL\u0007\u0002O)\u0011\u0001\u0006C\u0001\u000bG>dG.Z2uS>t\u0017B\u0001\u0016(\u0005\ri\u0015\r\u001d\t\u000331J!!\f\u0002\u0003\u0017I+G-[:TKJ4XM\u001d\t\u00033=J!\u0001\r\u0002\u0003\u001fI+G-[:D_:tWm\u0019;j_:DqA\r\u0001C\u0002\u001b\u00051'\u0001\u0003oC6,W#\u0001\u001b\u0011\u0005UbdB\u0001\u001c;!\t9\u0004\"D\u00019\u0015\tID!\u0001\u0004=e>|GOP\u0005\u0003w!\ta\u0001\u0015:fI\u00164\u0017BA\u001f?\u0005\u0019\u0019FO]5oO*\u00111\b\u0003\u0005\b\u0001\u0002\u0011\r\u0011b\u0001B\u0003A)\u00070Z2vi&|gnQ8oi\u0016DH/F\u0001C!\t\u0019e)D\u0001E\u0015\t)%#\u0001\u0005eSN\u0004\u0018\r^2i\u0013\t9EIA\tNKN\u001c\u0018mZ3ESN\u0004\u0018\r^2iKJDa!\u0013\u0001!\u0002\u0013\u0011\u0015!E3yK\u000e,H/[8o\u0007>tG/\u001a=uA!91\n\u0001b\u0001\n\u0013a\u0015A\u0005:fI&\u001c8i\u001c8oK\u000e$\u0018n\u001c8SK\u001a,\u0012!\u0014\t\u0004\u001dN+V\"A(\u000b\u0005A\u000b\u0016aA:u[*\u0011!\u000bC\u0001\u000bG>t7-\u001e:sK:$\u0018B\u0001+P\u0005\r\u0011VM\u001a\t\u0004-nsfBA,Z\u001d\t9\u0004,C\u0001\n\u0013\tQ\u0006\"A\u0004qC\u000e\\\u0017mZ3\n\u0005qk&aA*fc*\u0011!\f\u0003\t\u0003\u001f}K!\u0001\u0019\t\u0003\u0011\u0005\u001bGo\u001c:SK\u001aDaA\u0019\u0001!\u0002\u0013i\u0015a\u0005:fI&\u001c8i\u001c8oK\u000e$\u0018n\u001c8SK\u001a\u0004\u0003\"\u00023\u0001\t\u0003)\u0017!\u00032s_\u0006$7-Y:u+\t1g\u000e\u0006\u0002hoB\u0019ak\u00175\u0011\u0007%TG.D\u0001R\u0013\tY\u0017K\u0001\u0004GkR,(/\u001a\t\u0003[:d\u0001\u0001B\u0003pG\n\u0007\u0001OA\u0001U#\t\tH\u000f\u0005\u0002\be&\u00111\u000f\u0003\u0002\b\u001d>$\b.\u001b8h!\t9Q/\u0003\u0002w\u0011\t\u0019\u0011I\\=\t\u000ba\u001c\u0007\u0019A=\u0002\u0019I,G-[:D_6l\u0017M\u001c31\u0005it\b\u0003B\r|{2L!\u0001 \u0002\u0003\u0019I+G-[:D_6l\u0017M\u001c3\u0011\u00055tHAC@x\u0003\u0003\u0005\tQ!\u0001\u0002\u0002\t\u0019q\fJ\u0019\u0012\u0007E\f\u0019\u0001\u0005\u0003\u0002\u0006\u0005-QBAA\u0004\u0015\r\tIAA\u0001\taJ|Go\\2pY&!\u0011QBA\u0004\u0005)\u0011V\rZ5t%\u0016\u0004H.\u001f\u0005\b\u0003#\u0001a\u0011CA\n\u0003\u0011\u0019XM\u001c3\u0016\t\u0005U\u00111\u0004\u000b\u0007\u0003/\ti\"!\t\u0011\t%T\u0017\u0011\u0004\t\u0004[\u0006mAAB8\u0002\u0010\t\u0007\u0001\u000fC\u0004\u0002 \u0005=\u0001\u0019\u00010\u0002\u001fI,G-[:D_:tWm\u0019;j_:Dq\u0001_A\b\u0001\u0004\t\u0019\u0003\r\u0003\u0002&\u0005%\u0002CB\r|\u0003O\tI\u0002E\u0002n\u0003S!A\"a\u000b\u0002\"\u0005\u0005\t\u0011!B\u0001\u0003\u0003\u00111a\u0018\u00133\u0011\u001d\ty\u0003\u0001C\u0001\u0003c\tAcZ3u\u0007>tg.Z2uS>t7/Q2uSZ,W#A+\t\u000f\u0005U\u0002\u0001\"\u0001\u00022\u0005\u0019\"/\u001a3jg\u000e{gN\\3di&|g\u000eU8pY\"9\u0011\u0011\b\u0001\u0005\u0002\u0005m\u0012!C8o\u0007>tg.Z2u)\u0019\ti$a\u0011\u0002LA\u0019q!a\u0010\n\u0007\u0005\u0005\u0003B\u0001\u0003V]&$\bbB\u0002\u00028\u0001\u0007\u0011Q\t\t\u00043\u0005\u001d\u0013bAA%\u0005\ti!+\u001a3jg\u000e{W.\\1oINDq!!\u0014\u00028\u0001\u00071&\u0001\u0004tKJ4XM\u001d\u0005\b\u0003#\u0002A\u0011AA*\u0003=ygnQ8o]\u0016\u001cGo\u0015;biV\u001cHCBA+\u0003C\n\u0019\u0007E\u0004\b\u0003/\nY&!\u0010\n\u0007\u0005e\u0003BA\u0005Gk:\u001cG/[8ocA\u0019q!!\u0018\n\u0007\u0005}\u0003BA\u0004C_>dW-\u00198\t\u000f\u00055\u0013q\na\u0001W!A\u0011QMA(\u0001\u0004\t9'\u0001\u0004bGRLg/\u001a\t\u0005\u001dN\u000bY\u0006C\u0004\u0002l\u0001!\t!!\u001c\u0002%I,gM]3tQ\u000e{gN\\3di&|gn\u001d\u000b\u0003\u0003{Aq!!\u001d\u0001\t\u0003\t\u0019(\u0001\u000bhKR\u001cuN\u001c8fGR|\u0005/\u001a:bi&|gn\u001d\u000b\u0005\u0003k\n\t\nE\u0003\b\u0003o\nY(C\u0002\u0002z!\u0011\u0011BR;oGRLwN\u001c\u0019\u0011\tY[\u0016Q\u0010\u0019\u0007\u0003\u007f\n9)!$\u0011\u000fe\t\t)!\"\u0002\f&\u0019\u00111\u0011\u0002\u0003\u0013=\u0003XM]1uS>t\u0007cA7\u0002\b\u0012Y\u0011\u0011RA8\u0003\u0003\u0005\tQ!\u0001q\u0005\ryFe\r\t\u0004[\u00065EaCAH\u0003_\n\t\u0011!A\u0003\u0002A\u00141a\u0018\u00135\u0011\u001d\ti%a\u001cA\u0002-Bq!!&\u0001\t\u0003\ti'\u0001\u0003ti>\u0004\bbBAM\u0001\u0011\u0005\u00111T\u0001\u0014[\u0006\\WMU3eSN\u001cuN\u001c8fGRLwN\u001c\u000b\u0007\u0003;\u000b\u0019+!*\u0011\u000b\u001d\tyj\u000b\u0018\n\u0007\u0005\u0005\u0006B\u0001\u0004UkBdWM\r\u0005\b\u0003\u001b\n9\n1\u0001,\u0011)\t9+a&\u0011\u0002\u0003\u0007\u00111L\u0001\u000eI\u00164\u0017-\u001e7u\u0003\u000e$\u0018N^3\t\u000f\u0005-\u0006\u0001\"\u0001\u0002.\u0006!R.Y6f%\u0016$\u0017n]\"mS\u0016tG/Q2u_J$RAXAX\u0003cCq!!\u0014\u0002*\u0002\u00071\u0006\u0003\u0005\u0002f\u0005%\u0006\u0019AA4\u0011%\t)\fAI\u0001\n\u0003\t9,A\u000fnC.,'+\u001a3jg\u000e{gN\\3di&|g\u000e\n3fM\u0006,H\u000e\u001e\u00133+\t\tIL\u000b\u0003\u0002\\\u0005m6FAA_!\u0011\ty,!3\u000e\u0005\u0005\u0005'\u0002BAb\u0003\u000b\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005\u001d\u0007\"\u0001\u0006b]:|G/\u0019;j_:LA!a3\u0002B\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3")
public abstract class RedisClientPoolLike {
    private final ActorSystem system;
    private final RedisDispatcher redisDispatcher;
    private final MessageDispatcher executionContext;
    private final Ref<Seq<ActorRef>> redisConnectionRef;

    public abstract Map<RedisServer, RedisConnection> redisServerConnections();

    public abstract String name();

    public MessageDispatcher executionContext() {
        return this.executionContext;
    }

    private Ref<Seq<ActorRef>> redisConnectionRef() {
        return this.redisConnectionRef;
    }

    public <T> Seq<Future<T>> broadcast(RedisCommand<? extends RedisReply, T> redisCommand) {
        return (Seq)this.redisConnectionPool().map((Function1 & Serializable & scala.Serializable)redisConnection -> this.send((ActorRef)redisConnection, redisCommand), Seq$.MODULE$.canBuildFrom());
    }

    public abstract <T> Future<T> send(ActorRef var1, RedisCommand<? extends RedisReply, T> var2);

    public Seq<ActorRef> getConnectionsActive() {
        return ((TraversableOnce)this.redisServerConnections().collect((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Tuple2<RedisServer, RedisConnection>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                RedisConnection redisConnection;
                A1 A1 = x1;
                Object object = A1 != null && BoxesRunTime.unboxToBoolean((Object)(redisConnection = (RedisConnection)A1._2()).active().single().get()) ? redisConnection.actor() : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Tuple2<RedisServer, RedisConnection> x1) {
                RedisConnection redisConnection;
                Tuple2<RedisServer, RedisConnection> tuple2 = x1;
                boolean bl = tuple2 != null && BoxesRunTime.unboxToBoolean((Object)(redisConnection = (RedisConnection)tuple2._2()).active().single().get());
                return bl;
            }
        }, Iterable$.MODULE$.canBuildFrom())).toVector();
    }

    public Seq<ActorRef> redisConnectionPool() {
        return (Seq)this.redisConnectionRef().single().get();
    }

    public void onConnect(RedisCommands redis, RedisServer server) {
        server.password().foreach((Function1 & Serializable & scala.Serializable)x$1 -> redis.auth(x$1, ByteStringSerializer$.MODULE$.String()));
        server.db().foreach((Function1 & Serializable & scala.Serializable)index -> redis.select(BoxesRunTime.unboxToInt((Object)index)));
    }

    public Function1<Object, BoxedUnit> onConnectStatus(RedisServer server, Ref<Object> active) {
        return (Function1 & Serializable & scala.Serializable)status -> {
            RedisClientPoolLike.$anonfun$onConnectStatus$1(this, active, BoxesRunTime.unboxToBoolean((Object)status));
            return BoxedUnit.UNIT;
        };
    }

    public void refreshConnections() {
        Seq<ActorRef> actives = this.getConnectionsActive();
        this.redisConnectionRef().single().set(actives);
    }

    public Function0<Seq<Operation<?, ?>>> getConnectOperations(RedisServer server) {
        return (Function0 & Serializable & scala.Serializable)() -> {
            RedisClientPoolLike self = this;
            BufferedRequest redis = new BufferedRequest(null, self){
                private final ExecutionContext executionContext;
                private final Builder<Operation<?, ?>, Queue<Operation<?, ?>>> operations;

                public <K> Future<Object> geoAdd(String key, double lat, double lng, String loc) {
                    return Geo.geoAdd$(this, key, lat, lng, loc);
                }

                public <K> Future<Seq<String>> geoRadius(String key, double lat, double lng, double radius, DistUnits.Measurement dim) {
                    return Geo.geoRadius$(this, key, lat, lng, radius, dim);
                }

                public <K> Future<Seq<String>> geoRadiusByMember(String key, String member, int dist, DistUnits.Measurement dim) {
                    return Geo.geoRadiusByMember$(this, key, member, dist, dim);
                }

                public <K> Future<Seq<String>> geoRadiusByMemberWithOpt(String key, String member, int dist, DistUnits.Measurement dim, GeoOptions.WithOption opt, int count) {
                    return Geo.geoRadiusByMemberWithOpt$(this, key, member, dist, dim, opt, count);
                }

                public <K> Future<Object> geoDist(String key, String member1, String member2, DistUnits.Measurement unit) {
                    return Geo.geoDist$(this, key, member1, member2, unit);
                }

                public <K> Future<Seq<String>> geoHash(String key, Seq<String> members) {
                    return Geo.geoHash$(this, key, members);
                }

                public <K> Future<Seq<String>> geoPos(String key, Seq<String> members) {
                    return Geo.geoPos$(this, key, members);
                }

                public <K> DistUnits.Measurement geoRadius$default$5() {
                    return Geo.geoRadius$default$5$(this);
                }

                public <K> DistUnits.Measurement geoRadiusByMember$default$4() {
                    return Geo.geoRadiusByMember$default$4$(this);
                }

                public <K> DistUnits.Measurement geoRadiusByMemberWithOpt$default$4() {
                    return Geo.geoRadiusByMemberWithOpt$default$4$(this);
                }

                public <K> GeoOptions.WithOption geoRadiusByMemberWithOpt$default$5() {
                    return Geo.geoRadiusByMemberWithOpt$default$5$(this);
                }

                public <K> int geoRadiusByMemberWithOpt$default$6() {
                    return Geo.geoRadiusByMemberWithOpt$default$6$(this);
                }

                public <K> DistUnits.Measurement geoDist$default$4() {
                    return Geo.geoDist$default$4$(this);
                }

                public Future<Seq<ClusterSlot>> clusterSlots() {
                    return Clusters.clusterSlots$(this);
                }

                public <V> Future<Object> pfadd(String key, Seq<V> values, ByteStringSerializer<V> evidence$1) {
                    return HyperLogLog.pfadd$(this, key, values, evidence$1);
                }

                public Future<Object> pfcount(Seq<String> keys) {
                    return HyperLogLog.pfcount$(this, keys);
                }

                public Future<Object> pfmerge(String destKey, Seq<String> sourceKeys) {
                    return HyperLogLog.pfmerge$(this, destKey, sourceKeys);
                }

                public Future<String> bgrewriteaof() {
                    return Server.bgrewriteaof$(this);
                }

                public Future<String> bgsave() {
                    return Server.bgsave$(this);
                }

                public Future<Object> clientKill(String ip, int port) {
                    return Server.clientKill$(this, ip, port);
                }

                public Future<Seq<scala.collection.immutable.Map<String, String>>> clientList() {
                    return Server.clientList$(this);
                }

                public Future<Option<String>> clientGetname() {
                    return Server.clientGetname$(this);
                }

                public Future<Object> clientSetname(String connectionName) {
                    return Server.clientSetname$(this, connectionName);
                }

                public Future<scala.collection.immutable.Map<String, String>> configGet(String parameter) {
                    return Server.configGet$(this, parameter);
                }

                public Future<Object> configSet(String parameter, String value) {
                    return Server.configSet$(this, parameter, value);
                }

                public Future<Object> configResetstat() {
                    return Server.configResetstat$(this);
                }

                public Future<Object> dbsize() {
                    return Server.dbsize$(this);
                }

                public Future<String> debugObject(String key) {
                    return Server.debugObject$(this, key);
                }

                public Future<String> debugSegfault() {
                    return Server.debugSegfault$(this);
                }

                public Future<Object> flushall() {
                    return Server.flushall$(this);
                }

                public Future<Object> flushdb() {
                    return Server.flushdb$(this);
                }

                public Future<String> info() {
                    return Server.info$(this);
                }

                public Future<String> info(String section) {
                    return Server.info$(this, section);
                }

                public Future<Object> lastsave() {
                    return Server.lastsave$(this);
                }

                public Future<Object> save() {
                    return Server.save$(this);
                }

                public Future<Object> shutdown() {
                    return Server.shutdown$(this);
                }

                public Future<Object> shutdown(ShutdownModifier modifier) {
                    return Server.shutdown$(this, modifier);
                }

                public Future<Object> slaveof(String host, int port) {
                    return Server.slaveof$(this, host, port);
                }

                public Future<Object> slaveofNoOne() {
                    return Server.slaveofNoOne$(this);
                }

                public Future<Tuple2<Object, Object>> time() {
                    return Server.time$(this);
                }

                public <V> Future<Status> auth(V value, ByteStringSerializer<V> evidence$1) {
                    return Connection.auth$(this, value, evidence$1);
                }

                public <V, R> Future<Option<R>> echo(V value, ByteStringSerializer<V> evidence$2, ByteStringDeserializer<R> evidence$3) {
                    return Connection.echo$(this, value, evidence$2, evidence$3);
                }

                public Future<String> ping() {
                    return Connection.ping$(this);
                }

                public Future<Object> quit() {
                    return Connection.quit$(this);
                }

                public Future<Object> select(int index) {
                    return Connection.select$(this, index);
                }

                public <R> Future<R> evalshaOrEval(RedisScript redisScript, Seq<String> keys, Seq<String> args, RedisReplyDeserializer<R> evidence$1) {
                    return Scripting.evalshaOrEval$(this, redisScript, keys, args, evidence$1);
                }

                public <R> Future<R> eval(String script, Seq<String> keys, Seq<String> args, RedisReplyDeserializer<R> evidence$2) {
                    return Scripting.eval$(this, script, keys, args, evidence$2);
                }

                public <R> Future<R> evalsha(String sha1, Seq<String> keys, Seq<String> args, RedisReplyDeserializer<R> evidence$3) {
                    return Scripting.evalsha$(this, sha1, keys, args, evidence$3);
                }

                public Future<Object> scriptFlush() {
                    return Scripting.scriptFlush$(this);
                }

                public Future<Object> scriptKill() {
                    return Scripting.scriptKill$(this);
                }

                public Future<String> scriptLoad(String script) {
                    return Scripting.scriptLoad$(this, script);
                }

                public Future<Seq<Object>> scriptExists(Seq<String> sha1) {
                    return Scripting.scriptExists$(this, sha1);
                }

                public <R> Seq<String> evalshaOrEval$default$2() {
                    return Scripting.evalshaOrEval$default$2$(this);
                }

                public <R> Seq<String> evalshaOrEval$default$3() {
                    return Scripting.evalshaOrEval$default$3$(this);
                }

                public <R> Seq<String> evalsha$default$2() {
                    return Scripting.evalsha$default$2$(this);
                }

                public <R> Seq<String> evalsha$default$3() {
                    return Scripting.evalsha$default$3$(this);
                }

                public <R> Seq<String> eval$default$2() {
                    return Scripting.eval$default$2$(this);
                }

                public <R> Seq<String> eval$default$3() {
                    return Scripting.eval$default$3$(this);
                }

                public <V> Future<Object> publish(String channel, V value, ByteStringSerializer<V> evidence$1) {
                    return Publish.publish$(this, channel, value, evidence$1);
                }

                public <V> Future<Object> zadd(String key, Seq<Tuple2<Object, V>> scoreMembers, ByteStringSerializer<V> evidence$1) {
                    return SortedSets.zadd$(this, key, scoreMembers, evidence$1);
                }

                public <V> Future<Object> zaddWithOptions(String key, Seq<ZaddOption> options, Seq<Tuple2<Object, V>> scoreMembers, ByteStringSerializer<V> evidence$2) {
                    return SortedSets.zaddWithOptions$(this, key, options, scoreMembers, evidence$2);
                }

                public Future<Object> zcard(String key) {
                    return SortedSets.zcard$(this, key);
                }

                public Future<Object> zcount(String key, Limit min, Limit max) {
                    return SortedSets.zcount$(this, key, min, max);
                }

                public <V> Future<Object> zincrby(String key, double increment, V member, ByteStringSerializer<V> evidence$3) {
                    return SortedSets.zincrby$(this, key, increment, member, evidence$3);
                }

                public Future<Object> zinterstore(String destination, String key, Seq<String> keys, Aggregate aggregate) {
                    return SortedSets.zinterstore$(this, destination, key, keys, aggregate);
                }

                public Future<Object> zinterstoreWeighted(String destination, scala.collection.immutable.Map<String, Object> keys, Aggregate aggregate) {
                    return SortedSets.zinterstoreWeighted$(this, destination, keys, aggregate);
                }

                public <R> Future<Seq<R>> zrange(String key, long start, long stop, ByteStringDeserializer<R> evidence$4) {
                    return SortedSets.zrange$(this, key, start, stop, evidence$4);
                }

                public <R> Future<Seq<Tuple2<R, Object>>> zrangeWithscores(String key, long start, long stop, ByteStringDeserializer<R> evidence$5) {
                    return SortedSets.zrangeWithscores$(this, key, start, stop, evidence$5);
                }

                public <R> Future<Seq<R>> zrangebyscore(String key, Limit min, Limit max, Option<Tuple2<Object, Object>> limit, ByteStringDeserializer<R> evidence$6) {
                    return SortedSets.zrangebyscore$(this, key, min, max, limit, evidence$6);
                }

                public <R> Future<Seq<Tuple2<R, Object>>> zrangebyscoreWithscores(String key, Limit min, Limit max, Option<Tuple2<Object, Object>> limit, ByteStringDeserializer<R> evidence$7) {
                    return SortedSets.zrangebyscoreWithscores$(this, key, min, max, limit, evidence$7);
                }

                public <V> Future<Option<Object>> zrank(String key, V member, ByteStringSerializer<V> evidence$8) {
                    return SortedSets.zrank$(this, key, member, evidence$8);
                }

                public <V> Future<Object> zrem(String key, Seq<V> members, ByteStringSerializer<V> evidence$9) {
                    return SortedSets.zrem$(this, key, members, evidence$9);
                }

                public Future<Object> zremrangebylex(String key, String min, String max) {
                    return SortedSets.zremrangebylex$(this, key, min, max);
                }

                public Future<Object> zremrangebyrank(String key, long start, long stop) {
                    return SortedSets.zremrangebyrank$(this, key, start, stop);
                }

                public Future<Object> zremrangebyscore(String key, Limit min, Limit max) {
                    return SortedSets.zremrangebyscore$(this, key, min, max);
                }

                public <R> Future<Seq<R>> zrevrange(String key, long start, long stop, ByteStringDeserializer<R> evidence$10) {
                    return SortedSets.zrevrange$(this, key, start, stop, evidence$10);
                }

                public <R> Future<Seq<Tuple2<R, Object>>> zrevrangeWithscores(String key, long start, long stop, ByteStringDeserializer<R> evidence$11) {
                    return SortedSets.zrevrangeWithscores$(this, key, start, stop, evidence$11);
                }

                public <R> Future<Seq<R>> zrevrangebyscore(String key, Limit min, Limit max, Option<Tuple2<Object, Object>> limit, ByteStringDeserializer<R> evidence$12) {
                    return SortedSets.zrevrangebyscore$(this, key, min, max, limit, evidence$12);
                }

                public <R> Future<Seq<Tuple2<R, Object>>> zrevrangebyscoreWithscores(String key, Limit min, Limit max, Option<Tuple2<Object, Object>> limit, ByteStringDeserializer<R> evidence$13) {
                    return SortedSets.zrevrangebyscoreWithscores$(this, key, min, max, limit, evidence$13);
                }

                public <V> Future<Option<Object>> zrevrank(String key, V member, ByteStringSerializer<V> evidence$14) {
                    return SortedSets.zrevrank$(this, key, member, evidence$14);
                }

                public <V> Future<Option<Object>> zscore(String key, V member, ByteStringSerializer<V> evidence$15) {
                    return SortedSets.zscore$(this, key, member, evidence$15);
                }

                public Future<Object> zunionstore(String destination, String key, Seq<String> keys, Aggregate aggregate) {
                    return SortedSets.zunionstore$(this, destination, key, keys, aggregate);
                }

                public Future<Object> zunionstoreWeighted(String destination, scala.collection.immutable.Map<String, Object> keys, Aggregate aggregate) {
                    return SortedSets.zunionstoreWeighted$(this, destination, keys, aggregate);
                }

                public <R> Future<Seq<R>> zrangebylex(String key, Option<String> min, Option<String> max, Option<Tuple2<Object, Object>> limit, ByteStringDeserializer<R> evidence$16) {
                    return SortedSets.zrangebylex$(this, key, min, max, limit, evidence$16);
                }

                public <R> Future<Seq<R>> zrevrangebylex(String key, Option<String> max, Option<String> min, Option<Tuple2<Object, Object>> limit, ByteStringDeserializer<R> evidence$17) {
                    return SortedSets.zrevrangebylex$(this, key, max, min, limit, evidence$17);
                }

                public <R> Future<Cursor<Seq<Tuple2<Object, R>>>> zscan(String key, int cursor, Option<Object> count, Option<String> matchGlob, ByteStringDeserializer<R> evidence$18) {
                    return SortedSets.zscan$(this, key, cursor, count, matchGlob, evidence$18);
                }

                public Limit zcount$default$2() {
                    return SortedSets.zcount$default$2$(this);
                }

                public Limit zcount$default$3() {
                    return SortedSets.zcount$default$3$(this);
                }

                public Aggregate zinterstore$default$4() {
                    return SortedSets.zinterstore$default$4$(this);
                }

                public Aggregate zinterstoreWeighted$default$3() {
                    return SortedSets.zinterstoreWeighted$default$3$(this);
                }

                public <R> Option<Tuple2<Object, Object>> zrangebyscore$default$4() {
                    return SortedSets.zrangebyscore$default$4$(this);
                }

                public <R> Option<Tuple2<Object, Object>> zrangebyscoreWithscores$default$4() {
                    return SortedSets.zrangebyscoreWithscores$default$4$(this);
                }

                public <R> Option<Tuple2<Object, Object>> zrevrangebyscore$default$4() {
                    return SortedSets.zrevrangebyscore$default$4$(this);
                }

                public <R> Option<Tuple2<Object, Object>> zrevrangebyscoreWithscores$default$4() {
                    return SortedSets.zrevrangebyscoreWithscores$default$4$(this);
                }

                public Aggregate zunionstore$default$4() {
                    return SortedSets.zunionstore$default$4$(this);
                }

                public Aggregate zunionstoreWeighted$default$3() {
                    return SortedSets.zunionstoreWeighted$default$3$(this);
                }

                public <R> Option<Tuple2<Object, Object>> zrangebylex$default$4() {
                    return SortedSets.zrangebylex$default$4$(this);
                }

                public <R> Option<Tuple2<Object, Object>> zrevrangebylex$default$4() {
                    return SortedSets.zrevrangebylex$default$4$(this);
                }

                public <R> int zscan$default$2() {
                    return SortedSets.zscan$default$2$(this);
                }

                public <R> Option<Object> zscan$default$3() {
                    return SortedSets.zscan$default$3$(this);
                }

                public <R> Option<String> zscan$default$4() {
                    return SortedSets.zscan$default$4$(this);
                }

                public <V> Future<Object> sadd(String key, Seq<V> members, ByteStringSerializer<V> evidence$1) {
                    return Sets.sadd$(this, key, members, evidence$1);
                }

                public Future<Object> scard(String key) {
                    return Sets.scard$(this, key);
                }

                public <R> Future<Seq<R>> sdiff(String key, Seq<String> keys, ByteStringDeserializer<R> evidence$2) {
                    return Sets.sdiff$(this, key, keys, evidence$2);
                }

                public Future<Object> sdiffstore(String destination, String key, Seq<String> keys) {
                    return Sets.sdiffstore$(this, destination, key, keys);
                }

                public <R> Future<Seq<R>> sinter(String key, Seq<String> keys, ByteStringDeserializer<R> evidence$3) {
                    return Sets.sinter$(this, key, keys, evidence$3);
                }

                public Future<Object> sinterstore(String destination, String key, Seq<String> keys) {
                    return Sets.sinterstore$(this, destination, key, keys);
                }

                public <V> Future<Object> sismember(String key, V member, ByteStringSerializer<V> evidence$4) {
                    return Sets.sismember$(this, key, member, evidence$4);
                }

                public <R> Future<Seq<R>> smembers(String key, ByteStringDeserializer<R> evidence$5) {
                    return Sets.smembers$(this, key, evidence$5);
                }

                public <V> Future<Object> smove(String source, String destination, V member, ByteStringSerializer<V> evidence$6) {
                    return Sets.smove$(this, source, destination, member, evidence$6);
                }

                public <R> Future<Option<R>> spop(String key, ByteStringDeserializer<R> evidence$7) {
                    return Sets.spop$(this, key, evidence$7);
                }

                public <R> Future<Option<R>> srandmember(String key, ByteStringDeserializer<R> evidence$8) {
                    return Sets.srandmember$(this, key, evidence$8);
                }

                public <R> Future<Seq<R>> srandmember(String key, long count, ByteStringDeserializer<R> evidence$9) {
                    return Sets.srandmember$(this, key, count, evidence$9);
                }

                public <V> Future<Object> srem(String key, Seq<V> members, ByteStringSerializer<V> evidence$10) {
                    return Sets.srem$(this, key, members, evidence$10);
                }

                public <R> Future<Seq<R>> sunion(String key, Seq<String> keys, ByteStringDeserializer<R> evidence$11) {
                    return Sets.sunion$(this, key, keys, evidence$11);
                }

                public Future<Object> sunionstore(String destination, String key, Seq<String> keys) {
                    return Sets.sunionstore$(this, destination, key, keys);
                }

                public <R> Future<Cursor<Seq<R>>> sscan(String key, int cursor, Option<Object> count, Option<String> matchGlob, ByteStringDeserializer<R> evidence$12) {
                    return Sets.sscan$(this, key, cursor, count, matchGlob, evidence$12);
                }

                public <R> int sscan$default$2() {
                    return Sets.sscan$default$2$(this);
                }

                public <R> Option<Object> sscan$default$3() {
                    return Sets.sscan$default$3$(this);
                }

                public <R> Option<String> sscan$default$4() {
                    return Sets.sscan$default$4$(this);
                }

                public <R> Future<Option<R>> lindex(String key, long index, ByteStringDeserializer<R> evidence$1) {
                    return Lists.lindex$(this, key, index, evidence$1);
                }

                public <V> Future<Object> linsertAfter(String key, String pivot, V value, ByteStringSerializer<V> evidence$2) {
                    return Lists.linsertAfter$(this, key, pivot, value, evidence$2);
                }

                public <V> Future<Object> linsertBefore(String key, String pivot, V value, ByteStringSerializer<V> evidence$3) {
                    return Lists.linsertBefore$(this, key, pivot, value, evidence$3);
                }

                public <V> Future<Object> linsert(String key, ListPivot beforeAfter, String pivot, V value, ByteStringSerializer<V> evidence$4) {
                    return Lists.linsert$(this, key, beforeAfter, pivot, value, evidence$4);
                }

                public Future<Object> llen(String key) {
                    return Lists.llen$(this, key);
                }

                public <R> Future<Option<R>> lpop(String key, ByteStringDeserializer<R> evidence$5) {
                    return Lists.lpop$(this, key, evidence$5);
                }

                public <V> Future<Object> lpush(String key, Seq<V> values, ByteStringSerializer<V> evidence$6) {
                    return Lists.lpush$(this, key, values, evidence$6);
                }

                public <V> Future<Object> lpushx(String key, V value, ByteStringSerializer<V> evidence$7) {
                    return Lists.lpushx$(this, key, value, evidence$7);
                }

                public <R> Future<Seq<R>> lrange(String key, long start, long stop, ByteStringDeserializer<R> evidence$8) {
                    return Lists.lrange$(this, key, start, stop, evidence$8);
                }

                public <V> Future<Object> lrem(String key, long count, V value, ByteStringSerializer<V> evidence$9) {
                    return Lists.lrem$(this, key, count, value, evidence$9);
                }

                public <V> Future<Object> lset(String key, long index, V value, ByteStringSerializer<V> evidence$10) {
                    return Lists.lset$(this, key, index, value, evidence$10);
                }

                public Future<Object> ltrim(String key, long start, long stop) {
                    return Lists.ltrim$(this, key, start, stop);
                }

                public <R> Future<Option<R>> rpop(String key, ByteStringDeserializer<R> evidence$11) {
                    return Lists.rpop$(this, key, evidence$11);
                }

                public <R> Future<Option<R>> rpoplpush(String source, String destination, ByteStringDeserializer<R> evidence$12) {
                    return Lists.rpoplpush$(this, source, destination, evidence$12);
                }

                public <V> Future<Object> rpush(String key, Seq<V> values, ByteStringSerializer<V> evidence$13) {
                    return Lists.rpush$(this, key, values, evidence$13);
                }

                public <V> Future<Object> rpushx(String key, V value, ByteStringSerializer<V> evidence$14) {
                    return Lists.rpushx$(this, key, value, evidence$14);
                }

                public Future<Object> hdel(String key, Seq<String> fields) {
                    return Hashes.hdel$(this, key, fields);
                }

                public Future<Object> hexists(String key, String field) {
                    return Hashes.hexists$(this, key, field);
                }

                public <R> Future<Option<R>> hget(String key, String field, ByteStringDeserializer<R> evidence$1) {
                    return Hashes.hget$(this, key, field, evidence$1);
                }

                public <R> Future<scala.collection.immutable.Map<String, R>> hgetall(String key, ByteStringDeserializer<R> evidence$2) {
                    return Hashes.hgetall$(this, key, evidence$2);
                }

                public Future<Object> hincrby(String key, String fields, long increment) {
                    return Hashes.hincrby$(this, key, fields, increment);
                }

                public Future<Object> hincrbyfloat(String key, String fields, double increment) {
                    return Hashes.hincrbyfloat$(this, key, fields, increment);
                }

                public Future<Seq<String>> hkeys(String key) {
                    return Hashes.hkeys$(this, key);
                }

                public Future<Object> hlen(String key) {
                    return Hashes.hlen$(this, key);
                }

                public <R> Future<Seq<Option<R>>> hmget(String key, Seq<String> fields, ByteStringDeserializer<R> evidence$3) {
                    return Hashes.hmget$(this, key, fields, evidence$3);
                }

                public <V> Future<Object> hmset(String key, scala.collection.immutable.Map<String, V> keysValues, ByteStringSerializer<V> evidence$4) {
                    return Hashes.hmset$(this, key, keysValues, evidence$4);
                }

                public <V> Future<Object> hset(String key, String field, V value, ByteStringSerializer<V> evidence$5) {
                    return Hashes.hset$(this, key, field, value, evidence$5);
                }

                public <V> Future<Object> hsetnx(String key, String field, V value, ByteStringSerializer<V> evidence$6) {
                    return Hashes.hsetnx$(this, key, field, value, evidence$6);
                }

                public <R> Future<Seq<R>> hvals(String key, ByteStringDeserializer<R> evidence$7) {
                    return Hashes.hvals$(this, key, evidence$7);
                }

                public <R> Future<Cursor<scala.collection.immutable.Map<String, R>>> hscan(String key, int cursor, Option<Object> count, Option<String> matchGlob, ByteStringDeserializer<R> evidence$8) {
                    return Hashes.hscan$(this, key, cursor, count, matchGlob, evidence$8);
                }

                public <R> int hscan$default$2() {
                    return Hashes.hscan$default$2$(this);
                }

                public <R> Option<Object> hscan$default$3() {
                    return Hashes.hscan$default$3$(this);
                }

                public <R> Option<String> hscan$default$4() {
                    return Hashes.hscan$default$4$(this);
                }

                public <V> Future<Object> append(String key, V value, ByteStringSerializer<V> evidence$1) {
                    return Strings.append$(this, key, value, evidence$1);
                }

                public Future<Object> bitcount(String key) {
                    return Strings.bitcount$(this, key);
                }

                public Future<Object> bitcount(String key, long start, long end) {
                    return Strings.bitcount$(this, key, start, end);
                }

                public Future<Object> bitopAND(String destkey, Seq<String> keys) {
                    return Strings.bitopAND$(this, destkey, keys);
                }

                public Future<Object> bitopOR(String destkey, Seq<String> keys) {
                    return Strings.bitopOR$(this, destkey, keys);
                }

                public Future<Object> bitopXOR(String destkey, Seq<String> keys) {
                    return Strings.bitopXOR$(this, destkey, keys);
                }

                public Future<Object> bitopNOT(String destkey, String key) {
                    return Strings.bitopNOT$(this, destkey, key);
                }

                public Future<Object> bitop(BitOperator operation, String destkey, Seq<String> keys) {
                    return Strings.bitop$(this, operation, destkey, keys);
                }

                public Future<Object> bitpos(String key, long bit, long start, long end) {
                    return Strings.bitpos$(this, key, bit, start, end);
                }

                public Future<Object> decr(String key) {
                    return Strings.decr$(this, key);
                }

                public Future<Object> decrby(String key, long decrement) {
                    return Strings.decrby$(this, key, decrement);
                }

                public <R> Future<Option<R>> get(String key, ByteStringDeserializer<R> evidence$2) {
                    return Strings.get$(this, key, evidence$2);
                }

                public Future<Object> getbit(String key, long offset) {
                    return Strings.getbit$(this, key, offset);
                }

                public <R> Future<Option<R>> getrange(String key, long start, long end, ByteStringDeserializer<R> evidence$3) {
                    return Strings.getrange$(this, key, start, end, evidence$3);
                }

                public <V, R> Future<Option<R>> getset(String key, V value, ByteStringSerializer<V> evidence$4, ByteStringDeserializer<R> evidence$5) {
                    return Strings.getset$(this, key, value, evidence$4, evidence$5);
                }

                public Future<Object> incr(String key) {
                    return Strings.incr$(this, key);
                }

                public Future<Object> incrby(String key, long increment) {
                    return Strings.incrby$(this, key, increment);
                }

                public Future<Option<Object>> incrbyfloat(String key, double increment) {
                    return Strings.incrbyfloat$(this, key, increment);
                }

                public <R> Future<Seq<Option<R>>> mget(Seq<String> keys, ByteStringDeserializer<R> evidence$6) {
                    return Strings.mget$(this, keys, evidence$6);
                }

                public <V> Future<Object> mset(scala.collection.immutable.Map<String, V> keysValues, ByteStringSerializer<V> evidence$7) {
                    return Strings.mset$(this, keysValues, evidence$7);
                }

                public <V> Future<Object> msetnx(scala.collection.immutable.Map<String, V> keysValues, ByteStringSerializer<V> evidence$8) {
                    return Strings.msetnx$(this, keysValues, evidence$8);
                }

                public <V> Future<Object> psetex(String key, long milliseconds, V value, ByteStringSerializer<V> evidence$9) {
                    return Strings.psetex$(this, key, milliseconds, value, evidence$9);
                }

                public <V> Future<Object> set(String key, V value, Option<Object> exSeconds, Option<Object> pxMilliseconds, boolean NX, boolean XX, ByteStringSerializer<V> evidence$10) {
                    return Strings.set$(this, key, value, exSeconds, pxMilliseconds, NX, XX, evidence$10);
                }

                public Future<Object> setbit(String key, long offset, boolean value) {
                    return Strings.setbit$(this, key, offset, value);
                }

                public <V> Future<Object> setex(String key, long seconds, V value, ByteStringSerializer<V> evidence$11) {
                    return Strings.setex$(this, key, seconds, value, evidence$11);
                }

                public <V> Future<Object> setnx(String key, V value, ByteStringSerializer<V> evidence$12) {
                    return Strings.setnx$(this, key, value, evidence$12);
                }

                public <V> Future<Object> setrange(String key, long offset, V value, ByteStringSerializer<V> evidence$13) {
                    return Strings.setrange$(this, key, offset, value, evidence$13);
                }

                public Future<Object> strlen(String key) {
                    return Strings.strlen$(this, key);
                }

                public long bitpos$default$3() {
                    return Strings.bitpos$default$3$(this);
                }

                public long bitpos$default$4() {
                    return Strings.bitpos$default$4$(this);
                }

                public <V> Option<Object> set$default$3() {
                    return Strings.set$default$3$(this);
                }

                public <V> Option<Object> set$default$4() {
                    return Strings.set$default$4$(this);
                }

                public <V> boolean set$default$5() {
                    return Strings.set$default$5$(this);
                }

                public <V> boolean set$default$6() {
                    return Strings.set$default$6$(this);
                }

                public Future<Object> del(Seq<String> keys) {
                    return Keys.del$(this, keys);
                }

                public <R> Future<Option<R>> dump(String key, ByteStringDeserializer<R> evidence$1) {
                    return Keys.dump$(this, key, evidence$1);
                }

                public Future<Object> exists(String key) {
                    return Keys.exists$(this, key);
                }

                public Future<Object> existsMany(Seq<String> keys) {
                    return Keys.existsMany$(this, keys);
                }

                public Future<Object> expire(String key, long seconds) {
                    return Keys.expire$(this, key, seconds);
                }

                public Future<Object> expireat(String key, long seconds) {
                    return Keys.expireat$(this, key, seconds);
                }

                public Future<Seq<String>> keys(String pattern) {
                    return Keys.keys$(this, pattern);
                }

                public Future<Object> migrate(String host, int port, String key, int destinationDB, FiniteDuration timeout) {
                    return Keys.migrate$(this, host, port, key, destinationDB, timeout);
                }

                public Future<Object> move(String key, int db) {
                    return Keys.move$(this, key, db);
                }

                public Future<Option<Object>> objectRefcount(String key) {
                    return Keys.objectRefcount$(this, key);
                }

                public Future<Option<Object>> objectIdletime(String key) {
                    return Keys.objectIdletime$(this, key);
                }

                public Future<Option<String>> objectEncoding(String key) {
                    return Keys.objectEncoding$(this, key);
                }

                public Future<Object> persist(String key) {
                    return Keys.persist$(this, key);
                }

                public Future<Object> pexpire(String key, long milliseconds) {
                    return Keys.pexpire$(this, key, milliseconds);
                }

                public Future<Object> pexpireat(String key, long millisecondsTimestamp) {
                    return Keys.pexpireat$(this, key, millisecondsTimestamp);
                }

                public Future<Object> pttl(String key) {
                    return Keys.pttl$(this, key);
                }

                public <R> Future<Option<R>> randomkey(ByteStringDeserializer<R> evidence$2) {
                    return Keys.randomkey$(this, evidence$2);
                }

                public Future<Object> rename(String key, String newkey) {
                    return Keys.rename$(this, key, newkey);
                }

                public Future<Object> renamenx(String key, String newkey) {
                    return Keys.renamenx$(this, key, newkey);
                }

                public <V> Future<Object> restore(String key, long ttl, V serializedValue, ByteStringSerializer<V> evidence$3) {
                    return Keys.restore$(this, key, ttl, serializedValue, evidence$3);
                }

                public <R> Future<Seq<R>> sort(String key, Option<String> byPattern, Option<LimitOffsetCount> limit, Seq<String> getPatterns, Option<Order> order, boolean alpha, ByteStringDeserializer<R> evidence$4) {
                    return Keys.sort$(this, key, byPattern, limit, getPatterns, order, alpha, evidence$4);
                }

                public Future<Object> sortStore(String key, Option<String> byPattern, Option<LimitOffsetCount> limit, Seq<String> getPatterns, Option<Order> order, boolean alpha, String store) {
                    return Keys.sortStore$(this, key, byPattern, limit, getPatterns, order, alpha, store);
                }

                public Future<Object> ttl(String key) {
                    return Keys.ttl$(this, key);
                }

                public Future<String> type(String key) {
                    return Keys.type$(this, key);
                }

                public Future<Cursor<Seq<String>>> scan(int cursor, Option<Object> count, Option<String> matchGlob) {
                    return Keys.scan$(this, cursor, count, matchGlob);
                }

                public <V> long restore$default$2() {
                    return Keys.restore$default$2$(this);
                }

                public <R> Option<String> sort$default$2() {
                    return Keys.sort$default$2$(this);
                }

                public <R> Option<LimitOffsetCount> sort$default$3() {
                    return Keys.sort$default$3$(this);
                }

                public <R> Seq<String> sort$default$4() {
                    return Keys.sort$default$4$(this);
                }

                public <R> Option<Order> sort$default$5() {
                    return Keys.sort$default$5$(this);
                }

                public <R> boolean sort$default$6() {
                    return Keys.sort$default$6$(this);
                }

                public Option<String> sortStore$default$2() {
                    return Keys.sortStore$default$2$(this);
                }

                public Option<LimitOffsetCount> sortStore$default$3() {
                    return Keys.sortStore$default$3$(this);
                }

                public Seq<String> sortStore$default$4() {
                    return Keys.sortStore$default$4$(this);
                }

                public Option<Order> sortStore$default$5() {
                    return Keys.sortStore$default$5$(this);
                }

                public boolean sortStore$default$6() {
                    return Keys.sortStore$default$6$(this);
                }

                public int scan$default$1() {
                    return Keys.scan$default$1$(this);
                }

                public Option<Object> scan$default$2() {
                    return Keys.scan$default$2$(this);
                }

                public Option<String> scan$default$3() {
                    return Keys.scan$default$3$(this);
                }

                public <T> Future<T> send(RedisCommand<? extends RedisReply, T> redisCommand) {
                    return BufferedRequest.send$(this, redisCommand);
                }

                public Builder<Operation<?, ?>, Queue<Operation<?, ?>>> operations() {
                    return this.operations;
                }

                public void redis$BufferedRequest$_setter_$operations_$eq(Builder<Operation<?, ?>, Queue<Operation<?, ?>>> x$1) {
                    this.operations = x$1;
                }

                public ExecutionContext executionContext() {
                    return this.executionContext;
                }
                {
                    BufferedRequest.$init$(this);
                    Keys.$init$(this);
                    Strings.$init$(this);
                    Hashes.$init$(this);
                    Lists.$init$(this);
                    Sets.$init$(this);
                    SortedSets.$init$(this);
                    Publish.$init$(this);
                    Scripting.$init$(this);
                    Connection.$init$(this);
                    Server.$init$(this);
                    HyperLogLog.$init$(this);
                    Clusters.$init$(this);
                    Geo.$init$(this);
                    this.executionContext = self$1.executionContext();
                }
            };
            this.onConnect((RedisCommands)((Object)redis), server);
            return (Queue)redis.operations().result();
        };
    }

    public void stop() {
        this.redisConnectionPool().foreach((Function1 & Serializable & scala.Serializable)redisConnection -> {
            this.system.stop(redisConnection);
            return BoxedUnit.UNIT;
        });
    }

    public Tuple2<RedisServer, RedisConnection> makeRedisConnection(RedisServer server, boolean defaultActive) {
        Ref active = Ref$.MODULE$.apply(defaultActive);
        return new Tuple2((Object)server, (Object)new RedisConnection(this.makeRedisClientActor(server, (Ref<Object>)active), (Ref<Object>)active));
    }

    public boolean makeRedisConnection$default$2() {
        return false;
    }

    public ActorRef makeRedisClientActor(RedisServer server, Ref<Object> active) {
        return this.system.actorOf(RedisClientActor$.MODULE$.props(new InetSocketAddress(server.host(), server.port()), this.getConnectOperations(server), this.onConnectStatus(server, active), this.redisDispatcher.name(), RedisClientActor$.MODULE$.props$default$5()).withDispatcher(this.redisDispatcher.name()), this.name() + '-' + Redis$.MODULE$.tempName());
    }

    public static final /* synthetic */ void $anonfun$onConnectStatus$1(RedisClientPoolLike $this, Ref active$1, boolean status) {
        block0: {
            if (!active$1.single().compareAndSet((Object)BoxesRunTime.boxToBoolean((!status ? 1 : 0) != 0), (Object)BoxesRunTime.boxToBoolean((boolean)status))) break block0;
            $this.refreshConnections();
        }
    }

    public RedisClientPoolLike(ActorSystem system, RedisDispatcher redisDispatcher) {
        this.system = system;
        this.redisDispatcher = redisDispatcher;
        this.executionContext = system.dispatchers().lookup(redisDispatcher.name());
        this.redisConnectionRef = Ref$.MODULE$.apply((Object)Seq$.MODULE$.empty(), (OptManifest)ClassManifestFactory$.MODULE$.classType(Seq.class, (OptManifest)ClassManifestFactory$.MODULE$.classType(ActorRef.class), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new OptManifest[0])));
    }
}

