/*
 * Decompiled with CFR 0.152.
 */
package redis.protocol;

import akka.util.ByteString;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import redis.protocol.Bulk;
import redis.protocol.DecodeResult;
import redis.protocol.Error;
import redis.protocol.FullyDecoded;
import redis.protocol.Integer;
import redis.protocol.MultiBulk;
import redis.protocol.PartiallyDecoded;
import redis.protocol.RedisReply;
import redis.protocol.Status;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Product;
import scala.Some;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Builder;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;

public final class RedisProtocolReply$ {
    public static RedisProtocolReply$ MODULE$;
    private final char ERROR;
    private final char STATUS;
    private final char INTEGER;
    private final char BULK;
    private final char MULTIBULK;
    private final byte[] LS;
    private final PartialFunction<ByteString, DecodeResult<RedisReply>> decodeReplyPF;
    private final PartialFunction<ByteString, DecodeResult<Status>> decodeReplyStatus;
    private final PartialFunction<ByteString, DecodeResult<Integer>> decodeReplyInteger;
    private final PartialFunction<ByteString, DecodeResult<Bulk>> decodeReplyBulk;
    private final PartialFunction<ByteString, DecodeResult<MultiBulk>> decodeReplyMultiBulk;
    private final PartialFunction<ByteString, DecodeResult<Error>> decodeReplyError;

    static {
        new RedisProtocolReply$();
    }

    public char ERROR() {
        return this.ERROR;
    }

    public char STATUS() {
        return this.STATUS;
    }

    public char INTEGER() {
        return this.INTEGER;
    }

    public char BULK() {
        return this.BULK;
    }

    public char MULTIBULK() {
        return this.MULTIBULK;
    }

    public byte[] LS() {
        return this.LS;
    }

    public DecodeResult<RedisReply> decodeReply(ByteString bs2) {
        DecodeResult<RedisReply> decodeResult;
        if (bs2.isEmpty()) {
            decodeResult = new PartiallyDecoded<RedisReply>(bs2, (Function1 & Serializable & scala.Serializable)bs -> this.decodeReply((ByteString)bs));
        } else {
            DecodeResult<Object> decodeResult2;
            byte by = bs2.head();
            if (this.ERROR() == by) {
                decodeResult2 = this.decodeString(bs2.tail()).map((Function1 & Serializable & scala.Serializable)x$3 -> new Error((ByteString)x$3));
            } else if (this.INTEGER() == by) {
                decodeResult2 = this.decodeInteger(bs2.tail());
            } else if (this.STATUS() == by) {
                decodeResult2 = this.decodeString(bs2.tail()).map((Function1 & Serializable & scala.Serializable)x$4 -> new Status((ByteString)x$4));
            } else if (this.BULK() == by) {
                decodeResult2 = this.decodeBulk(bs2.tail());
            } else if (this.MULTIBULK() == by) {
                decodeResult2 = this.decodeMultiBulk(bs2.tail());
            } else {
                throw new Exception("Redis Protocol error: Got " + bs2.head() + " as initial reply byte >>" + bs2.tail().utf8String());
            }
            decodeResult = decodeResult2;
        }
        return decodeResult;
    }

    public PartialFunction<ByteString, DecodeResult<RedisReply>> decodeReplyPF() {
        return this.decodeReplyPF;
    }

    public PartialFunction<ByteString, DecodeResult<Status>> decodeReplyStatus() {
        return this.decodeReplyStatus;
    }

    public PartialFunction<ByteString, DecodeResult<Integer>> decodeReplyInteger() {
        return this.decodeReplyInteger;
    }

    public PartialFunction<ByteString, DecodeResult<Bulk>> decodeReplyBulk() {
        return this.decodeReplyBulk;
    }

    public PartialFunction<ByteString, DecodeResult<MultiBulk>> decodeReplyMultiBulk() {
        return this.decodeReplyMultiBulk;
    }

    public PartialFunction<ByteString, DecodeResult<Error>> decodeReplyError() {
        return this.decodeReplyError;
    }

    public DecodeResult<Integer> decodeInteger(ByteString bs) {
        return this.decodeString(bs).map((Function1 & Serializable & scala.Serializable)string -> new Integer((ByteString)string));
    }

    public DecodeResult<ByteString> decodeString(ByteString bs2) {
        Product product;
        int index = bs2.indexOf((Object)BoxesRunTime.boxToCharacter((char)'\n'));
        if (index >= 0 && bs2.length() >= index + 1) {
            ByteString reply = bs2.take(index + 1 - this.LS().length);
            ByteString tail = bs2.drop(index + 1);
            FullyDecoded<ByteString> r = new FullyDecoded<ByteString>(reply, tail);
            product = r;
        } else {
            product = new PartiallyDecoded<ByteString>(bs2, (Function1 & Serializable & scala.Serializable)bs -> this.decodeString((ByteString)bs));
        }
        return product;
    }

    public DecodeResult<Bulk> decodeBulk(ByteString bs) {
        return this.decodeInteger(bs).flatMap((Function2 & Serializable & scala.Serializable)(integer, bsRest) -> this.decodeBulkBody$1((Integer)integer, (ByteString)bsRest));
    }

    public DecodeResult<MultiBulk> decodeMultiBulk(ByteString bs) {
        return this.decodeInteger(bs).flatMap((Function2 & Serializable & scala.Serializable)(integer, bsRest) -> {
            DecodeResult<MultiBulk> decodeResult;
            int i = integer.toInt();
            if (i < 0) {
                decodeResult = new FullyDecoded<MultiBulk>(new MultiBulk((Option<Vector<RedisReply>>)None$.MODULE$), (ByteString)bsRest);
            } else if (i == 0) {
                decodeResult = new FullyDecoded<MultiBulk>(new MultiBulk((Option<Vector<RedisReply>>)new Some((Object)package$.MODULE$.Vector().empty())), (ByteString)bsRest);
            } else {
                Builder builder = package$.MODULE$.Vector().newBuilder();
                builder.sizeHint(i);
                decodeResult = this.bulks(i, (Builder<RedisReply, Vector<RedisReply>>)builder, (ByteString)bsRest);
            }
            return decodeResult;
        });
    }

    public DecodeResult<MultiBulk> bulks(int i2, Builder<RedisReply, Vector<RedisReply>> builder, ByteString byteString) {
        return this.helper$1(i2, byteString, builder).flatMap((Function2 & Serializable & scala.Serializable)(i, bs) -> RedisProtocolReply$.$anonfun$bulks$2(this, builder, BoxesRunTime.unboxToInt((Object)i), bs));
    }

    private final DecodeResult decodeBulkBody$1(Integer integer, ByteString bsRest) {
        FullyDecoded<Bulk> fullyDecoded;
        int i = integer.toInt();
        if (i < 0) {
            fullyDecoded = new FullyDecoded<Bulk>(new Bulk((Option<ByteString>)None$.MODULE$), bsRest);
        } else if (bsRest.length() < i + this.LS().length) {
            fullyDecoded = new PartiallyDecoded(bsRest, (Function1 & Serializable & scala.Serializable)x$8 -> this.decodeBulkBody$1(integer, (ByteString)x$8));
        } else {
            ByteString data = bsRest.take(i);
            fullyDecoded = new FullyDecoded<Bulk>(new Bulk((Option<ByteString>)new Some((Object)data)), bsRest.drop(i).drop(this.LS().length));
        }
        return fullyDecoded;
    }

    public static final /* synthetic */ int $anonfun$bulks$1(Builder builder$1, int i$1, RedisReply r) {
        builder$1.$plus$eq((Object)r);
        return i$1 - 1;
    }

    private final DecodeResult helper$1(int i, ByteString bs, Builder builder$1) {
        DecodeResult<java.lang.Integer> decodeResult;
        block2: {
            while (i > 0) {
                DecodeResult reply = this.decodeReply(bs).map((Function1 & Serializable & scala.Serializable)r -> BoxesRunTime.boxToInteger((int)RedisProtocolReply$.$anonfun$bulks$1(builder$1, i, r)));
                if (reply.isFullyDecoded()) {
                    bs = reply.rest();
                    --i;
                    continue;
                }
                decodeResult = reply;
                break block2;
            }
            decodeResult = new FullyDecoded<java.lang.Integer>(BoxesRunTime.boxToInteger((int)0), bs);
        }
        return decodeResult;
    }

    public static final /* synthetic */ DecodeResult $anonfun$bulks$2(RedisProtocolReply$ $this, Builder builder$1, int i, ByteString bs) {
        return i > 0 ? $this.bulks(i, (Builder<RedisReply, Vector<RedisReply>>)builder$1, bs) : new FullyDecoded<MultiBulk>(new MultiBulk((Option<Vector<RedisReply>>)new Some(builder$1.result())), bs);
    }

    private RedisProtocolReply$() {
        MODULE$ = this;
        this.ERROR = (char)45;
        this.STATUS = (char)43;
        this.INTEGER = (char)58;
        this.BULK = (char)36;
        this.MULTIBULK = (char)42;
        this.LS = "\r\n".getBytes("UTF-8");
        this.decodeReplyPF = new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends ByteString, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                Object object = A1.head() == RedisProtocolReply$.MODULE$.INTEGER() ? RedisProtocolReply$.MODULE$.decodeInteger(A1.tail()) : (A1.head() == RedisProtocolReply$.MODULE$.STATUS() ? RedisProtocolReply$.MODULE$.decodeString(A1.tail()).map((Function1 & Serializable & scala.Serializable)x$5 -> new Status((ByteString)x$5)) : (A1.head() == RedisProtocolReply$.MODULE$.BULK() ? RedisProtocolReply$.MODULE$.decodeBulk(A1.tail()) : (A1.head() == RedisProtocolReply$.MODULE$.MULTIBULK() ? RedisProtocolReply$.MODULE$.decodeMultiBulk(A1.tail()) : function1.apply(x1))));
                return (B1)object;
            }

            public final boolean isDefinedAt(ByteString x1) {
                ByteString byteString = x1;
                boolean bl = byteString.head() == RedisProtocolReply$.MODULE$.INTEGER() ? true : (byteString.head() == RedisProtocolReply$.MODULE$.STATUS() ? true : (byteString.head() == RedisProtocolReply$.MODULE$.BULK() ? true : byteString.head() == RedisProtocolReply$.MODULE$.MULTIBULK()));
                return bl;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(akka.util.ByteString )}, serializedLambda);
            }
        };
        this.decodeReplyStatus = new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends ByteString, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                A1 A1 = x2;
                DecodeResult<B> decodeResult = A1.head() == RedisProtocolReply$.MODULE$.STATUS() ? RedisProtocolReply$.MODULE$.decodeString(A1.tail()).map((Function1 & Serializable & scala.Serializable)x$6 -> new Status((ByteString)x$6)) : function1.apply(x2);
                return (B1)decodeResult;
            }

            public final boolean isDefinedAt(ByteString x2) {
                ByteString byteString = x2;
                boolean bl = byteString.head() == RedisProtocolReply$.MODULE$.STATUS();
                return bl;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$2(akka.util.ByteString )}, serializedLambda);
            }
        };
        this.decodeReplyInteger = new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends ByteString, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                A1 A1 = x3;
                Object object = A1.head() == RedisProtocolReply$.MODULE$.INTEGER() ? RedisProtocolReply$.MODULE$.decodeInteger(A1.tail()) : function1.apply(x3);
                return (B1)object;
            }

            public final boolean isDefinedAt(ByteString x3) {
                ByteString byteString = x3;
                boolean bl = byteString.head() == RedisProtocolReply$.MODULE$.INTEGER();
                return bl;
            }
        };
        this.decodeReplyBulk = new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends ByteString, B1> B1 applyOrElse(A1 x4, Function1<A1, B1> function1) {
                A1 A1 = x4;
                Object object = A1.head() == RedisProtocolReply$.MODULE$.BULK() ? RedisProtocolReply$.MODULE$.decodeBulk(A1.tail()) : function1.apply(x4);
                return (B1)object;
            }

            public final boolean isDefinedAt(ByteString x4) {
                ByteString byteString = x4;
                boolean bl = byteString.head() == RedisProtocolReply$.MODULE$.BULK();
                return bl;
            }
        };
        this.decodeReplyMultiBulk = new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends ByteString, B1> B1 applyOrElse(A1 x5, Function1<A1, B1> function1) {
                A1 A1 = x5;
                Object object = A1.head() == RedisProtocolReply$.MODULE$.MULTIBULK() ? RedisProtocolReply$.MODULE$.decodeMultiBulk(A1.tail()) : function1.apply(x5);
                return (B1)object;
            }

            public final boolean isDefinedAt(ByteString x5) {
                ByteString byteString = x5;
                boolean bl = byteString.head() == RedisProtocolReply$.MODULE$.MULTIBULK();
                return bl;
            }
        };
        this.decodeReplyError = new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends ByteString, B1> B1 applyOrElse(A1 x6, Function1<A1, B1> function1) {
                A1 A1 = x6;
                DecodeResult<B> decodeResult = A1.head() == RedisProtocolReply$.MODULE$.ERROR() ? RedisProtocolReply$.MODULE$.decodeString(A1.tail()).map((Function1 & Serializable & scala.Serializable)x$7 -> new Error((ByteString)x$7)) : function1.apply(x6);
                return (B1)decodeResult;
            }

            public final boolean isDefinedAt(ByteString x6) {
                ByteString byteString = x6;
                boolean bl = byteString.head() == RedisProtocolReply$.MODULE$.ERROR();
                return bl;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$3(akka.util.ByteString )}, serializedLambda);
            }
        };
    }
}

