/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.tsid;

import java.io.Serializable;
import java.math.BigInteger;
import java.time.Instant;
import java.util.SplittableRandom;
import java.util.concurrent.atomic.AtomicInteger;

public final class Tsid
implements Serializable,
Comparable<Tsid> {
    private static final long serialVersionUID = -5446820982139116297L;
    private final long number;
    public static final int TSID_BYTES = 8;
    public static final int TSID_CHARS = 13;
    public static final long TSID_EPOCH = Instant.parse("2020-01-01T00:00:00.000Z").toEpochMilli();
    static final int RANDOM_BITS = 22;
    static final int RANDOM_MASK = 0x3FFFFF;
    private static final char[] ALPHABET_UPPERCASE = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'J', 'K', 'M', 'N', 'P', 'Q', 'R', 'S', 'T', 'V', 'W', 'X', 'Y', 'Z'};
    private static final char[] ALPHABET_LOWERCASE = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'j', 'k', 'm', 'n', 'p', 'q', 'r', 's', 't', 'v', 'w', 'x', 'y', 'z'};
    private static final long[] ALPHABET_VALUES = new long[128];

    public Tsid(long number) {
        this.number = number;
    }

    public static Tsid from(long number) {
        return new Tsid(number);
    }

    public static Tsid from(byte[] bytes) {
        if (bytes == null || bytes.length != 8) {
            throw new IllegalArgumentException("Invalid TSID bytes");
        }
        long number = 0L;
        number |= ((long)bytes[0] & 0xFFL) << 56;
        number |= ((long)bytes[1] & 0xFFL) << 48;
        number |= ((long)bytes[2] & 0xFFL) << 40;
        number |= ((long)bytes[3] & 0xFFL) << 32;
        number |= ((long)bytes[4] & 0xFFL) << 24;
        number |= ((long)bytes[5] & 0xFFL) << 16;
        number |= ((long)bytes[6] & 0xFFL) << 8;
        return new Tsid(number |= (long)bytes[7] & 0xFFL);
    }

    public static Tsid from(String string) {
        char[] chars = Tsid.toCharArray(string);
        long number = 0L;
        number |= ALPHABET_VALUES[chars[0]] << 60;
        number |= ALPHABET_VALUES[chars[1]] << 55;
        number |= ALPHABET_VALUES[chars[2]] << 50;
        number |= ALPHABET_VALUES[chars[3]] << 45;
        number |= ALPHABET_VALUES[chars[4]] << 40;
        number |= ALPHABET_VALUES[chars[5]] << 35;
        number |= ALPHABET_VALUES[chars[6]] << 30;
        number |= ALPHABET_VALUES[chars[7]] << 25;
        number |= ALPHABET_VALUES[chars[8]] << 20;
        number |= ALPHABET_VALUES[chars[9]] << 15;
        number |= ALPHABET_VALUES[chars[10]] << 10;
        number |= ALPHABET_VALUES[chars[11]] << 5;
        return new Tsid(number |= ALPHABET_VALUES[chars[12]]);
    }

    public long toLong() {
        return this.number;
    }

    public byte[] toBytes() {
        byte[] bytes = new byte[]{(byte)(this.number >>> 56), (byte)(this.number >>> 48), (byte)(this.number >>> 40), (byte)(this.number >>> 32), (byte)(this.number >>> 24), (byte)(this.number >>> 16), (byte)(this.number >>> 8), (byte)this.number};
        return bytes;
    }

    public static Tsid fast() {
        long time = System.currentTimeMillis() - TSID_EPOCH << 22;
        long tail = LazyHolder.counter.incrementAndGet() & 0x3FFFFF;
        return new Tsid(time | tail);
    }

    public String toString() {
        return this.toString(ALPHABET_UPPERCASE);
    }

    public String toLowerCase() {
        return this.toString(ALPHABET_LOWERCASE);
    }

    public Instant getInstant() {
        return Instant.ofEpochMilli(this.getUnixMilliseconds());
    }

    public Instant getInstant(Instant customEpoch) {
        return Instant.ofEpochMilli(this.getUnixMilliseconds(customEpoch.toEpochMilli()));
    }

    public long getUnixMilliseconds() {
        return this.getTime() + TSID_EPOCH;
    }

    public long getUnixMilliseconds(long customEpoch) {
        return this.getTime() + customEpoch;
    }

    long getTime() {
        return this.number >>> 22;
    }

    long getRandom() {
        return this.number & 0x3FFFFFL;
    }

    public static boolean isValid(String string) {
        return string != null && Tsid.isValidCharArray(string.toCharArray());
    }

    public int hashCode() {
        return (int)(this.number ^ this.number >>> 32);
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other.getClass() != Tsid.class) {
            return false;
        }
        Tsid that = (Tsid)other;
        return this.number == that.number;
    }

    @Override
    public int compareTo(Tsid that) {
        long min = Long.MIN_VALUE;
        long a = this.number + Long.MIN_VALUE;
        long b = that.number + Long.MIN_VALUE;
        if (a > b) {
            return 1;
        }
        if (a < b) {
            return -1;
        }
        return 0;
    }

    public String encode(int base) {
        if (base < 2 || base > 62) {
            throw new IllegalArgumentException(String.format("Invalid base: %s", base));
        }
        return BaseN.encode(this, base);
    }

    public static Tsid decode(String string, int base) {
        if (base < 2 || base > 62) {
            throw new IllegalArgumentException(String.format("Invalid base: %s", base));
        }
        return BaseN.decode(string, base);
    }

    public String format(String format) {
        if (format != null) {
            int i = format.indexOf("%");
            if (i < 0 || i == format.length() - 1) {
                throw new IllegalArgumentException(String.format("Invalid format string: \"%s\"", format));
            }
            String head = format.substring(0, i);
            String tail = format.substring(i + 2);
            char placeholder = format.charAt(i + 1);
            switch (placeholder) {
                case 'S': {
                    return head + this.toString() + tail;
                }
                case 's': {
                    return head + this.toLowerCase() + tail;
                }
                case 'X': {
                    return head + BaseN.encode(this, 16) + tail;
                }
                case 'x': {
                    return head + BaseN.encode(this, 16).toLowerCase() + tail;
                }
                case 'd': {
                    return head + BaseN.encode(this, 10) + tail;
                }
                case 'z': {
                    return head + BaseN.encode(this, 62) + tail;
                }
            }
            throw new IllegalArgumentException(String.format("Invalid placeholder: \"%%%s\"", Character.valueOf(placeholder)));
        }
        throw new IllegalArgumentException(String.format("Invalid format string: \"%s\"", format));
    }

    public static Tsid unformat(String formatted, String format) {
        if (formatted != null && format != null) {
            int i = format.indexOf("%");
            if (i < 0 || i == format.length() - 1) {
                throw new IllegalArgumentException(String.format("Invalid format string: \"%s\"", format));
            }
            String head = format.substring(0, i);
            String tail = format.substring(i + 2);
            char placeholder = format.charAt(i + 1);
            int length = formatted.length() - head.length() - tail.length();
            if (formatted.startsWith(head) && formatted.endsWith(tail)) {
                switch (placeholder) {
                    case 'S': {
                        return Tsid.from(formatted.substring(i, i + length));
                    }
                    case 's': {
                        return Tsid.from(formatted.substring(i, i + length));
                    }
                    case 'X': {
                        return BaseN.decode(formatted.substring(i, i + length).toUpperCase(), 16);
                    }
                    case 'x': {
                        return BaseN.decode(formatted.substring(i, i + length).toUpperCase(), 16);
                    }
                    case 'd': {
                        return BaseN.decode(formatted.substring(i, i + length), 10);
                    }
                    case 'z': {
                        return BaseN.decode(formatted.substring(i, i + length), 62);
                    }
                }
                throw new IllegalArgumentException(String.format("Invalid placeholder: \"%%%s\"", Character.valueOf(placeholder)));
            }
        }
        throw new IllegalArgumentException(String.format("Invalid formatted string: \"%s\"", formatted));
    }

    String toString(char[] alphabet) {
        char[] chars = new char[]{alphabet[(int)(this.number >>> 60 & 0x1FL)], alphabet[(int)(this.number >>> 55 & 0x1FL)], alphabet[(int)(this.number >>> 50 & 0x1FL)], alphabet[(int)(this.number >>> 45 & 0x1FL)], alphabet[(int)(this.number >>> 40 & 0x1FL)], alphabet[(int)(this.number >>> 35 & 0x1FL)], alphabet[(int)(this.number >>> 30 & 0x1FL)], alphabet[(int)(this.number >>> 25 & 0x1FL)], alphabet[(int)(this.number >>> 20 & 0x1FL)], alphabet[(int)(this.number >>> 15 & 0x1FL)], alphabet[(int)(this.number >>> 10 & 0x1FL)], alphabet[(int)(this.number >>> 5 & 0x1FL)], alphabet[(int)(this.number & 0x1FL)]};
        return new String(chars);
    }

    static char[] toCharArray(String string) {
        char[] chars;
        char[] cArray = chars = string == null ? null : string.toCharArray();
        if (!Tsid.isValidCharArray(chars)) {
            throw new IllegalArgumentException(String.format("Invalid TSID string: \"%s\"", string));
        }
        return chars;
    }

    static boolean isValidCharArray(char[] chars) {
        if (chars == null || chars.length != 13) {
            return false;
        }
        if ((ALPHABET_VALUES[chars[0]] & 0x10L) != 0L) {
            return false;
        }
        for (int i = 0; i < chars.length; ++i) {
            if (ALPHABET_VALUES[chars[i]] != -1L) continue;
            return false;
        }
        return true;
    }

    static {
        for (int i = 0; i < ALPHABET_VALUES.length; ++i) {
            Tsid.ALPHABET_VALUES[i] = -1L;
        }
        Tsid.ALPHABET_VALUES[48] = 0L;
        Tsid.ALPHABET_VALUES[49] = 1L;
        Tsid.ALPHABET_VALUES[50] = 2L;
        Tsid.ALPHABET_VALUES[51] = 3L;
        Tsid.ALPHABET_VALUES[52] = 4L;
        Tsid.ALPHABET_VALUES[53] = 5L;
        Tsid.ALPHABET_VALUES[54] = 6L;
        Tsid.ALPHABET_VALUES[55] = 7L;
        Tsid.ALPHABET_VALUES[56] = 8L;
        Tsid.ALPHABET_VALUES[57] = 9L;
        Tsid.ALPHABET_VALUES[97] = 10L;
        Tsid.ALPHABET_VALUES[98] = 11L;
        Tsid.ALPHABET_VALUES[99] = 12L;
        Tsid.ALPHABET_VALUES[100] = 13L;
        Tsid.ALPHABET_VALUES[101] = 14L;
        Tsid.ALPHABET_VALUES[102] = 15L;
        Tsid.ALPHABET_VALUES[103] = 16L;
        Tsid.ALPHABET_VALUES[104] = 17L;
        Tsid.ALPHABET_VALUES[106] = 18L;
        Tsid.ALPHABET_VALUES[107] = 19L;
        Tsid.ALPHABET_VALUES[109] = 20L;
        Tsid.ALPHABET_VALUES[110] = 21L;
        Tsid.ALPHABET_VALUES[112] = 22L;
        Tsid.ALPHABET_VALUES[113] = 23L;
        Tsid.ALPHABET_VALUES[114] = 24L;
        Tsid.ALPHABET_VALUES[115] = 25L;
        Tsid.ALPHABET_VALUES[116] = 26L;
        Tsid.ALPHABET_VALUES[118] = 27L;
        Tsid.ALPHABET_VALUES[119] = 28L;
        Tsid.ALPHABET_VALUES[120] = 29L;
        Tsid.ALPHABET_VALUES[121] = 30L;
        Tsid.ALPHABET_VALUES[122] = 31L;
        Tsid.ALPHABET_VALUES[111] = 0L;
        Tsid.ALPHABET_VALUES[105] = 1L;
        Tsid.ALPHABET_VALUES[108] = 1L;
        Tsid.ALPHABET_VALUES[65] = 10L;
        Tsid.ALPHABET_VALUES[66] = 11L;
        Tsid.ALPHABET_VALUES[67] = 12L;
        Tsid.ALPHABET_VALUES[68] = 13L;
        Tsid.ALPHABET_VALUES[69] = 14L;
        Tsid.ALPHABET_VALUES[70] = 15L;
        Tsid.ALPHABET_VALUES[71] = 16L;
        Tsid.ALPHABET_VALUES[72] = 17L;
        Tsid.ALPHABET_VALUES[74] = 18L;
        Tsid.ALPHABET_VALUES[75] = 19L;
        Tsid.ALPHABET_VALUES[77] = 20L;
        Tsid.ALPHABET_VALUES[78] = 21L;
        Tsid.ALPHABET_VALUES[80] = 22L;
        Tsid.ALPHABET_VALUES[81] = 23L;
        Tsid.ALPHABET_VALUES[82] = 24L;
        Tsid.ALPHABET_VALUES[83] = 25L;
        Tsid.ALPHABET_VALUES[84] = 26L;
        Tsid.ALPHABET_VALUES[86] = 27L;
        Tsid.ALPHABET_VALUES[87] = 28L;
        Tsid.ALPHABET_VALUES[88] = 29L;
        Tsid.ALPHABET_VALUES[89] = 30L;
        Tsid.ALPHABET_VALUES[90] = 31L;
        Tsid.ALPHABET_VALUES[79] = 0L;
        Tsid.ALPHABET_VALUES[73] = 1L;
        Tsid.ALPHABET_VALUES[76] = 1L;
    }

    private static class LazyHolder {
        private static final AtomicInteger counter = new AtomicInteger(new SplittableRandom().nextInt());

        private LazyHolder() {
        }
    }

    static class BaseN {
        private static final BigInteger MAX = BigInteger.valueOf(2L).pow(64);
        private static final String ALPHABET = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";

        BaseN() {
        }

        static String encode(Tsid tsid, int base) {
            int length;
            BigInteger x = new BigInteger(1, tsid.toBytes());
            BigInteger radix = BigInteger.valueOf(base);
            int b = length = (int)Math.ceil(64.0 / (Math.log(base) / Math.log(2.0)));
            char[] buffer = new char[length];
            while (x.compareTo(BigInteger.ZERO) > 0) {
                BigInteger[] result = x.divideAndRemainder(radix);
                buffer[--b] = ALPHABET.charAt(result[1].intValue());
                x = result[0];
            }
            while (b > 0) {
                buffer[--b] = 48;
            }
            return new String(buffer);
        }

        static Tsid decode(String string, int base) {
            BigInteger x = BigInteger.ZERO;
            BigInteger radix = BigInteger.valueOf(base);
            int length = (int)Math.ceil(64.0 / (Math.log(base) / Math.log(2.0)));
            if (string == null) {
                throw new IllegalArgumentException(String.format("Invalid base-%d string: null", base));
            }
            if (string.length() != length) {
                throw new IllegalArgumentException(String.format("Invalid base-%d length: %s", base, string.length()));
            }
            for (int i = 0; i < string.length(); ++i) {
                long plus = ALPHABET.indexOf(string.charAt(i));
                if (plus < 0L || plus >= (long)base) {
                    throw new IllegalArgumentException(String.format("Invalid base-%d character: %s", base, Character.valueOf(string.charAt(i))));
                }
                x = x.multiply(radix).add(BigInteger.valueOf(plus));
            }
            if (x.compareTo(MAX) > 0) {
                throw new IllegalArgumentException(String.format("Invalid base-%d value (overflow): %s", base, x));
            }
            return new Tsid(x.longValue());
        }
    }
}

