/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.ulid.guid;

import com.github.f4b6a3.ulid.exception.UlidCreatorException;
import com.github.f4b6a3.ulid.random.Xorshift128PlusRandom;
import com.github.f4b6a3.ulid.timestamp.DefaultTimestampStrategy;
import com.github.f4b6a3.ulid.timestamp.TimestampStrategy;
import com.github.f4b6a3.ulid.util.FingerprintUtil;
import com.github.f4b6a3.ulid.util.UlidUtil;
import java.security.SecureRandom;
import java.util.Random;
import java.util.UUID;

public class GuidCreator {
    protected static final long MAX_LOW = -1L;
    protected static final long MAX_HIGH = 65535L;
    protected long previousTimestamp;
    protected boolean enableOverflowException = true;
    protected Random random;
    protected long low;
    protected long high;
    protected static final String OVERFLOW_MESSAGE = "The system caused an overflow in the generator by requesting too many IDs.";
    protected TimestampStrategy timestampStrategy;

    public GuidCreator() {
        this.reset();
        this.timestampStrategy = new DefaultTimestampStrategy();
    }

    public synchronized UUID create() {
        long timestamp = this.getTimestamp();
        long msb = timestamp << 16 | this.high;
        long lsb = this.low;
        return new UUID(msb, lsb);
    }

    public synchronized String createUlid() {
        UUID guid = this.create();
        return UlidUtil.fromUuidToUlid(guid);
    }

    public synchronized byte[] createBytes() {
        UUID guid = this.create();
        return UlidUtil.fromUuidToBytes(guid);
    }

    protected synchronized long getTimestamp() {
        long timestamp = this.timestampStrategy.getTimestamp();
        if (timestamp == this.previousTimestamp) {
            this.increment();
        } else {
            this.reset();
        }
        this.previousTimestamp = timestamp;
        return timestamp;
    }

    protected synchronized void reset() {
        if (this.random == null) {
            this.low = SecureRandomLazyHolder.INSTANCE.nextLong();
            this.high = SecureRandomLazyHolder.INSTANCE.nextLong() & 0xFFFFL;
        } else {
            this.low = this.random.nextLong();
            this.high = this.random.nextLong() & 0xFFFFL;
        }
    }

    protected synchronized void increment() {
        if (this.low++ == -1L && this.high++ == 65535L) {
            this.high = 0L;
            if (this.enableOverflowException) {
                throw new UlidCreatorException(OVERFLOW_MESSAGE);
            }
        }
    }

    public synchronized <T extends GuidCreator> T withTimestampStrategy(TimestampStrategy timestampStrategy) {
        this.timestampStrategy = timestampStrategy;
        return (T)this;
    }

    public synchronized <T extends GuidCreator> T withRandomGenerator(Random random) {
        this.random = random;
        return (T)this;
    }

    public synchronized <T extends GuidCreator> T withFastRandomGenerator() {
        int salt = (int)FingerprintUtil.getFingerprint();
        this.random = new Xorshift128PlusRandom(salt);
        return (T)this;
    }

    public synchronized <T extends GuidCreator> T withoutOverflowException() {
        this.enableOverflowException = false;
        return (T)this;
    }

    private static class SecureRandomLazyHolder {
        static final Random INSTANCE = new SecureRandom();

        private SecureRandomLazyHolder() {
        }
    }
}

