/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.ulid.util;

import java.math.BigInteger;
import java.nio.charset.StandardCharsets;

public class Base32Util {
    public static final String ALPHABET_BASE_32 = "ABCDEFGHIJKLMNOPQRSTUVWXYZ234567";
    public static final String ALPHABET_BASE_32_HEX = "0123456789ABCDEFGHIJKLMNOPQRSTUV";
    public static final String ALPHABET_BASE_32_Z = "ybndrfg8ejkmcpqxot1uwisza345h769";
    public static final String ALPHABET_BASE_32_CROCKFORD = "0123456789ABCDEFGHJKMNPQRSTVWXYZ";
    private static final char[] _ALPHABET_BASE_32 = "ABCDEFGHIJKLMNOPQRSTUVWXYZ234567".toCharArray();
    private static final char[] _ALPHABET_BASE_32_HEX = "0123456789ABCDEFGHIJKLMNOPQRSTUV".toCharArray();
    private static final char[] _ALPHABET_BASE_32_Z = "ybndrfg8ejkmcpqxot1uwisza345h769".toCharArray();
    private static final char[] _ALPHABET_BASE_32_CROCKFORD = "0123456789ABCDEFGHJKMNPQRSTVWXYZ".toCharArray();
    private static final int[] PADDING_ENCODE = new int[]{0, 6, 4, 3, 1};
    private static final int[] PADDING_DECODE = new int[]{0, 4, 4, 3, 3, 2, 2, 1};
    private static final int BASE = 32;

    private Base32Util() {
    }

    public static String toBase32(long number) {
        return Base32Util.encodeLong(number, _ALPHABET_BASE_32);
    }

    public static String toBase32(BigInteger number) {
        return Base32Util.encodeBigInteger(number, _ALPHABET_BASE_32);
    }

    public static String toBase32(byte[] bytes) {
        return Base32Util.encode(bytes, _ALPHABET_BASE_32, Character.valueOf('='));
    }

    public static String toBase32(String string) {
        return Base32Util.toBase32(Base32Util.toBytes(string));
    }

    public static byte[] fromBase32(String string) {
        return Base32Util.decode(Base32Util.normalize(string), _ALPHABET_BASE_32, Character.valueOf('='));
    }

    public static String fromBase32AsString(String string) {
        return Base32Util.toString(Base32Util.fromBase32(string));
    }

    public static long fromBase32AsLong(String string) {
        return Base32Util.decodeLong(Base32Util.normalize(string), _ALPHABET_BASE_32);
    }

    public static BigInteger fromBase32AsBigInteger(String string) {
        return Base32Util.decodeBigInteger(Base32Util.normalize(string), _ALPHABET_BASE_32);
    }

    public static String toBase32Hex(long number) {
        return Base32Util.encodeLong(number, _ALPHABET_BASE_32_HEX);
    }

    public static String toBase32Hex(BigInteger number) {
        return Base32Util.encodeBigInteger(number, _ALPHABET_BASE_32_HEX);
    }

    public static String toBase32Hex(byte[] bytes) {
        return Base32Util.encode(bytes, _ALPHABET_BASE_32_HEX, Character.valueOf('='));
    }

    public static String toBase32Hex(String string) {
        return Base32Util.toBase32Hex(Base32Util.toBytes(string));
    }

    public static byte[] fromBase32Hex(String string) {
        return Base32Util.decode(Base32Util.normalize(string), _ALPHABET_BASE_32_HEX, Character.valueOf('='));
    }

    public static String fromBase32HexAsString(String string) {
        return Base32Util.toString(Base32Util.fromBase32Hex(string));
    }

    public static long fromBase32HexAsLong(String string) {
        return Base32Util.decodeLong(Base32Util.normalize(string), _ALPHABET_BASE_32_HEX);
    }

    public static BigInteger fromBase32HexAsBigInteger(String string) {
        return Base32Util.decodeBigInteger(Base32Util.normalize(string), _ALPHABET_BASE_32_HEX);
    }

    public static String toBase32Crockford(long number) {
        return Base32Util.encodeLong(number, _ALPHABET_BASE_32_CROCKFORD);
    }

    public static String toBase32Crockford(BigInteger number) {
        return Base32Util.encodeBigInteger(number, _ALPHABET_BASE_32_CROCKFORD);
    }

    public static String toBase32Crockford(byte[] bytes) {
        return Base32Util.encode(bytes, _ALPHABET_BASE_32_CROCKFORD, null);
    }

    public static String toBase32Crockford(String string) {
        return Base32Util.toBase32Crockford(Base32Util.toBytes(string));
    }

    public static byte[] fromBase32Crockford(String string) {
        return Base32Util.decode(Base32Util.normalizeCrockford(string), _ALPHABET_BASE_32_CROCKFORD, null);
    }

    public static String fromBase32CrockfordAsString(String string) {
        return Base32Util.toString(Base32Util.fromBase32Crockford(string));
    }

    public static long fromBase32CrockfordAsLong(String string) {
        return Base32Util.decodeLong(Base32Util.normalizeCrockford(string), _ALPHABET_BASE_32_CROCKFORD);
    }

    public static BigInteger fromBase32CrockfordAsBigInteger(String string) {
        return Base32Util.decodeBigInteger(Base32Util.normalizeCrockford(string), _ALPHABET_BASE_32_CROCKFORD);
    }

    public static String toBase32Z(long number) {
        return Base32Util.encodeLong(number, _ALPHABET_BASE_32_Z);
    }

    public static String toBase32Z(BigInteger number) {
        return Base32Util.encodeBigInteger(number, _ALPHABET_BASE_32_Z);
    }

    public static String toBase32Z(byte[] bytes) {
        return Base32Util.encode(bytes, _ALPHABET_BASE_32_Z, null);
    }

    public static String toBase32Z(String string) {
        return Base32Util.toBase32Z(Base32Util.toBytes(string));
    }

    public static byte[] fromBase32Z(String string) {
        return Base32Util.decode(Base32Util.normalizeZ(string), _ALPHABET_BASE_32_Z, null);
    }

    public static String fromBase32ZAsString(String string) {
        return Base32Util.toString(Base32Util.fromBase32Z(string));
    }

    public static long fromBase32ZAsLong(String string) {
        return Base32Util.decodeLong(Base32Util.normalizeZ(string), _ALPHABET_BASE_32_Z);
    }

    public static BigInteger fromBase32ZAsBigInteger(String string) {
        return Base32Util.decodeBigInteger(Base32Util.normalizeZ(string), _ALPHABET_BASE_32_Z);
    }

    public static byte[] toBytes(String string) {
        return string.getBytes(StandardCharsets.UTF_8);
    }

    public static String toString(byte[] bytes) {
        return new String(bytes, StandardCharsets.UTF_8);
    }

    public static String encodeLong(long number, char[] alphabet) {
        StringBuilder builder = new StringBuilder();
        for (long n = number; n > 0L; n /= 32L) {
            builder.append(alphabet[(int)(n % 32L)]);
        }
        return builder.reverse().toString();
    }

    public static String encodeBigInteger(BigInteger number, char[] alphabet) {
        BigInteger n = number;
        BigInteger b = BigInteger.valueOf(32L);
        StringBuilder builder = new StringBuilder();
        while (n.compareTo(BigInteger.ZERO) > 0) {
            builder.append(alphabet[n.remainder(b).intValue()]);
            n = n.divide(b);
        }
        return builder.reverse().toString();
    }

    public static long decodeLong(String string, char[] alphabet) {
        long n = 0L;
        for (char c : string.toCharArray()) {
            int d = Base32Util.map(c, alphabet);
            n = 32L * n + (long)d;
        }
        return n;
    }

    public static BigInteger decodeBigInteger(String string, char[] alphabet) {
        BigInteger n = BigInteger.ZERO;
        BigInteger b = BigInteger.valueOf(32L);
        for (char c : string.toCharArray()) {
            int d = Base32Util.map(c, alphabet);
            n = b.multiply(n).add(BigInteger.valueOf(d));
        }
        return n;
    }

    public static String encode(byte[] bytes, char[] alphabet, Character padding) {
        if (bytes == null || bytes.length == 0) {
            return "";
        }
        int div = bytes.length / 5;
        int mod = bytes.length % 5;
        int blocks = div + (mod == 0 ? 0 : 1);
        byte[] input = new byte[5 * blocks];
        char[] output = new char[8 * blocks];
        System.arraycopy(bytes, 0, input, 0, bytes.length);
        for (int i = 0; i < blocks; ++i) {
            byte[] blk = new byte[5];
            System.arraycopy(input, i * 5, blk, 0, 5);
            int[] out = new int[]{(blk[0] & 0xF8) >>> 3, (blk[0] & 7) << 2 | (blk[1] & 0xC0) >>> 6, (blk[1] & 0x3E) >>> 1, (blk[1] & 1) << 4 | (blk[2] & 0xF0) >>> 4, (blk[2] & 0xF) << 1 | (blk[3] & 0x80) >>> 7, (blk[3] & 0x7C) >>> 2, (blk[3] & 3) << 3 | (blk[4] & 0xE0) >>> 5, blk[4] & 0x1F};
            char[] chars = new char[8];
            for (int j = 0; j < 8; ++j) {
                chars[j] = alphabet[out[j]];
            }
            System.arraycopy(chars, 0, output, i * 8, 8);
        }
        int outputSize = output.length - PADDING_ENCODE[mod];
        if (padding != null) {
            for (int i = outputSize; i < output.length; ++i) {
                output[i] = padding.charValue();
            }
        } else {
            char[] temp = new char[outputSize];
            System.arraycopy(output, 0, temp, 0, outputSize);
            output = temp;
        }
        return new String(output);
    }

    public static byte[] decode(String string, char[] alphabet, Character padding) {
        if (string == null || string.length() == 0) {
            return new byte[0];
        }
        char[] chars = null;
        char[] alph = alphabet;
        chars = padding != null ? string.replaceAll(padding.toString(), "").toCharArray() : string.toCharArray();
        Base32Util.validate(chars, alph);
        int div = chars.length / 8;
        int mod = chars.length % 8;
        int size = div + (mod == 0 ? 0 : 1);
        char[] input = new char[8 * size];
        byte[] output = new byte[5 * size];
        System.arraycopy(chars, 0, input, 0, chars.length);
        for (int i = 0; i < size; ++i) {
            char[] blk = new char[8];
            System.arraycopy(input, i * 8, blk, 0, 8);
            byte[] out = new byte[]{(byte)(Base32Util.map(blk[0], alph) << 3 | Base32Util.map(blk[1], alph) >>> 2), (byte)(Base32Util.map(blk[1], alph) << 6 | Base32Util.map(blk[2], alph) << 1 | Base32Util.map(blk[3], alph) >>> 4), (byte)(Base32Util.map(blk[3], alph) << 4 | Base32Util.map(blk[4], alph) >>> 1), (byte)(Base32Util.map(blk[4], alph) << 7 | Base32Util.map(blk[5], alph) << 2 | Base32Util.map(blk[6], alph) >>> 3), (byte)(Base32Util.map(blk[6], alph) << 5 | Base32Util.map(blk[7], alph))};
            System.arraycopy(out, 0, output, i * 5, 5);
        }
        int outputSize = output.length - PADDING_DECODE[mod];
        byte[] temp = new byte[outputSize];
        System.arraycopy(output, 0, temp, 0, outputSize);
        output = temp;
        return output;
    }

    protected static void validate(char[] chars, char[] alphabet) {
        for (int i = 0; i < chars.length; ++i) {
            boolean found = false;
            for (int j = 0; j < alphabet.length; ++j) {
                if (chars[i] != alphabet[j]) continue;
                found = true;
                break;
            }
            if (found) continue;
            throw new Base32UtilException("Invalid character");
        }
    }

    private static int map(char c, char[] alphabet) {
        for (int i = 0; i < alphabet.length; ++i) {
            if (alphabet[i] != c) continue;
            return (byte)i;
        }
        return 48;
    }

    protected static String normalize(String string) {
        if (string == null) {
            return "";
        }
        return string.toUpperCase();
    }

    protected static String normalizeZ(String string) {
        if (string == null) {
            return "";
        }
        return string.toLowerCase();
    }

    protected static String normalizeCrockford(String string) {
        if (string == null) {
            return "";
        }
        String normalized = string.toUpperCase();
        normalized = normalized.replaceAll("-", "");
        normalized = normalized.replaceAll("I", "1");
        normalized = normalized.replaceAll("L", "1");
        normalized = normalized.replaceAll("O", "0");
        return normalized;
    }

    public static class Base32UtilException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public Base32UtilException(String message) {
            super(message);
        }
    }
}

