/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.ulid;

import java.io.Serializable;
import java.time.Instant;
import java.util.UUID;

public final class Ulid
implements Serializable,
Comparable<Ulid> {
    private static final long serialVersionUID = 2625269413446854731L;
    private final long msb;
    private final long lsb;
    public static final int ULID_LENGTH = 26;
    public static final int TIME_LENGTH = 10;
    public static final int RANDOM_LENGTH = 16;
    public static final int ULID_BYTES_LENGTH = 16;
    public static final int TIME_BYTES_LENGTH = 6;
    public static final int RANDOM_BYTES_LENGTH = 10;
    private static final char[] ALPHABET_UPPERCASE = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'J', 'K', 'M', 'N', 'P', 'Q', 'R', 'S', 'T', 'V', 'W', 'X', 'Y', 'Z'};
    private static final char[] ALPHABET_LOWERCASE = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'j', 'k', 'm', 'n', 'p', 'q', 'r', 's', 't', 'v', 'w', 'x', 'y', 'z'};
    private static final long[] ALPHABET_VALUES = new long[128];
    private static final long INCREMENT_OVERFLOW = 0L;

    public Ulid(Ulid ulid) {
        this.msb = ulid.getMostSignificantBits();
        this.lsb = ulid.getLeastSignificantBits();
    }

    public Ulid(long mostSignificantBits, long leastSignificantBits) {
        this.msb = mostSignificantBits;
        this.lsb = leastSignificantBits;
    }

    public Ulid(long time, byte[] random) {
        if ((time & 0xFFFF000000000000L) != 0L) {
            throw new IllegalArgumentException("Invalid time value");
        }
        if (random == null || random.length != 10) {
            throw new IllegalArgumentException("Invalid random bytes");
        }
        long long0 = 0L;
        long long1 = 0L;
        long0 |= time << 16;
        long0 |= (long)(random[0] & 0xFF) << 8;
        long0 |= (long)(random[1] & 0xFF);
        long1 |= (long)(random[2] & 0xFF) << 56;
        long1 |= (long)(random[3] & 0xFF) << 48;
        long1 |= (long)(random[4] & 0xFF) << 40;
        long1 |= (long)(random[5] & 0xFF) << 32;
        long1 |= (long)(random[6] & 0xFF) << 24;
        long1 |= (long)(random[7] & 0xFF) << 16;
        long1 |= (long)(random[8] & 0xFF) << 8;
        this.msb = long0;
        this.lsb = long1 |= (long)(random[9] & 0xFF);
    }

    public static Ulid from(UUID uuid) {
        return new Ulid(uuid.getMostSignificantBits(), uuid.getLeastSignificantBits());
    }

    public static Ulid from(byte[] bytes) {
        if (bytes == null || bytes.length != 16) {
            throw new IllegalArgumentException("Invalid ULID bytes");
        }
        long msb = 0L;
        long lsb = 0L;
        msb |= ((long)bytes[0] & 0xFFL) << 56;
        msb |= ((long)bytes[1] & 0xFFL) << 48;
        msb |= ((long)bytes[2] & 0xFFL) << 40;
        msb |= ((long)bytes[3] & 0xFFL) << 32;
        msb |= ((long)bytes[4] & 0xFFL) << 24;
        msb |= ((long)bytes[5] & 0xFFL) << 16;
        msb |= ((long)bytes[6] & 0xFFL) << 8;
        msb |= (long)bytes[7] & 0xFFL;
        lsb |= ((long)bytes[8] & 0xFFL) << 56;
        lsb |= ((long)bytes[9] & 0xFFL) << 48;
        lsb |= ((long)bytes[10] & 0xFFL) << 40;
        lsb |= ((long)bytes[11] & 0xFFL) << 32;
        lsb |= ((long)bytes[12] & 0xFFL) << 24;
        lsb |= ((long)bytes[13] & 0xFFL) << 16;
        lsb |= ((long)bytes[14] & 0xFFL) << 8;
        return new Ulid(msb, lsb |= (long)bytes[15] & 0xFFL);
    }

    public static Ulid from(String string) {
        char[] chars = Ulid.toCharArray(string);
        long time = 0L;
        long random0 = 0L;
        long random1 = 0L;
        time |= ALPHABET_VALUES[chars[0]] << 45;
        time |= ALPHABET_VALUES[chars[1]] << 40;
        time |= ALPHABET_VALUES[chars[2]] << 35;
        time |= ALPHABET_VALUES[chars[3]] << 30;
        time |= ALPHABET_VALUES[chars[4]] << 25;
        time |= ALPHABET_VALUES[chars[5]] << 20;
        time |= ALPHABET_VALUES[chars[6]] << 15;
        time |= ALPHABET_VALUES[chars[7]] << 10;
        time |= ALPHABET_VALUES[chars[8]] << 5;
        time |= ALPHABET_VALUES[chars[9]];
        random0 |= ALPHABET_VALUES[chars[10]] << 35;
        random0 |= ALPHABET_VALUES[chars[11]] << 30;
        random0 |= ALPHABET_VALUES[chars[12]] << 25;
        random0 |= ALPHABET_VALUES[chars[13]] << 20;
        random0 |= ALPHABET_VALUES[chars[14]] << 15;
        random0 |= ALPHABET_VALUES[chars[15]] << 10;
        random0 |= ALPHABET_VALUES[chars[16]] << 5;
        random0 |= ALPHABET_VALUES[chars[17]];
        random1 |= ALPHABET_VALUES[chars[18]] << 35;
        random1 |= ALPHABET_VALUES[chars[19]] << 30;
        random1 |= ALPHABET_VALUES[chars[20]] << 25;
        random1 |= ALPHABET_VALUES[chars[21]] << 20;
        random1 |= ALPHABET_VALUES[chars[22]] << 15;
        random1 |= ALPHABET_VALUES[chars[23]] << 10;
        random1 |= ALPHABET_VALUES[chars[24]] << 5;
        long msb = time << 16 | random0 >>> 24;
        long lsb = random0 << 40 | (random1 |= ALPHABET_VALUES[chars[25]]) & 0xFFFFFFFFFFL;
        return new Ulid(msb, lsb);
    }

    public UUID toUuid() {
        return new UUID(this.msb, this.lsb);
    }

    public byte[] toBytes() {
        byte[] bytes = new byte[]{(byte)(this.msb >>> 56), (byte)(this.msb >>> 48), (byte)(this.msb >>> 40), (byte)(this.msb >>> 32), (byte)(this.msb >>> 24), (byte)(this.msb >>> 16), (byte)(this.msb >>> 8), (byte)this.msb, (byte)(this.lsb >>> 56), (byte)(this.lsb >>> 48), (byte)(this.lsb >>> 40), (byte)(this.lsb >>> 32), (byte)(this.lsb >>> 24), (byte)(this.lsb >>> 16), (byte)(this.lsb >>> 8), (byte)this.lsb};
        return bytes;
    }

    public String toUpperCase() {
        return this.toString(ALPHABET_UPPERCASE);
    }

    public String toLowerCase() {
        return this.toString(ALPHABET_LOWERCASE);
    }

    public Ulid toRfc4122() {
        long msb4 = this.msb & 0xFFFFFFFFFFFF0FFFL | 0x4000L;
        long lsb4 = this.lsb & 0x3FFFFFFFFFFFFFFFL | Long.MIN_VALUE;
        return new Ulid(msb4, lsb4);
    }

    public Instant getInstant() {
        return Instant.ofEpochMilli(this.getTime());
    }

    public static Instant getInstant(String string) {
        return Instant.ofEpochMilli(Ulid.getTime(string));
    }

    public long getTime() {
        return this.msb >>> 16;
    }

    public static long getTime(String string) {
        char[] chars = Ulid.toCharArray(string);
        long time = 0L;
        time |= ALPHABET_VALUES[chars[0]] << 45;
        time |= ALPHABET_VALUES[chars[1]] << 40;
        time |= ALPHABET_VALUES[chars[2]] << 35;
        time |= ALPHABET_VALUES[chars[3]] << 30;
        time |= ALPHABET_VALUES[chars[4]] << 25;
        time |= ALPHABET_VALUES[chars[5]] << 20;
        time |= ALPHABET_VALUES[chars[6]] << 15;
        time |= ALPHABET_VALUES[chars[7]] << 10;
        time |= ALPHABET_VALUES[chars[8]] << 5;
        return time |= ALPHABET_VALUES[chars[9]];
    }

    public byte[] getRandom() {
        byte[] bytes = new byte[]{(byte)(this.msb >>> 8), (byte)this.msb, (byte)(this.lsb >>> 56), (byte)(this.lsb >>> 48), (byte)(this.lsb >>> 40), (byte)(this.lsb >>> 32), (byte)(this.lsb >>> 24), (byte)(this.lsb >>> 16), (byte)(this.lsb >>> 8), (byte)this.lsb};
        return bytes;
    }

    public static byte[] getRandom(String string) {
        char[] chars = Ulid.toCharArray(string);
        long random0 = 0L;
        long random1 = 0L;
        random0 |= ALPHABET_VALUES[chars[10]] << 35;
        random0 |= ALPHABET_VALUES[chars[11]] << 30;
        random0 |= ALPHABET_VALUES[chars[12]] << 25;
        random0 |= ALPHABET_VALUES[chars[13]] << 20;
        random0 |= ALPHABET_VALUES[chars[14]] << 15;
        random0 |= ALPHABET_VALUES[chars[15]] << 10;
        random0 |= ALPHABET_VALUES[chars[16]] << 5;
        random0 |= ALPHABET_VALUES[chars[17]];
        random1 |= ALPHABET_VALUES[chars[18]] << 35;
        random1 |= ALPHABET_VALUES[chars[19]] << 30;
        random1 |= ALPHABET_VALUES[chars[20]] << 25;
        random1 |= ALPHABET_VALUES[chars[21]] << 20;
        random1 |= ALPHABET_VALUES[chars[22]] << 15;
        random1 |= ALPHABET_VALUES[chars[23]] << 10;
        random1 |= ALPHABET_VALUES[chars[24]] << 5;
        byte[] bytes = new byte[]{(byte)(random0 >>> 32), (byte)(random0 >>> 24), (byte)(random0 >>> 16), (byte)(random0 >>> 8), (byte)random0, (byte)((random1 |= ALPHABET_VALUES[chars[25]]) >>> 32), (byte)(random1 >>> 24), (byte)(random1 >>> 16), (byte)(random1 >>> 8), (byte)random1};
        return bytes;
    }

    public long getMostSignificantBits() {
        return this.msb;
    }

    public long getLeastSignificantBits() {
        return this.lsb;
    }

    public Ulid increment() {
        long newMsb = this.msb;
        long newLsb = this.lsb + 1L;
        if (newLsb == 0L) {
            newMsb = newMsb & 0xFFFFFFFFFFFF0000L | newMsb + 1L & 0xFFFFL;
        }
        return new Ulid(newMsb, newLsb);
    }

    public static boolean isValid(String string) {
        return string != null && Ulid.isValidCharArray(string.toCharArray());
    }

    public String toString() {
        return this.toUpperCase();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.lsb ^ this.lsb >>> 32);
        result = 31 * result + (int)(this.msb ^ this.msb >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Ulid other = (Ulid)obj;
        if (this.lsb != other.lsb) {
            return false;
        }
        return this.msb == other.msb;
    }

    @Override
    public int compareTo(Ulid other) {
        if (this.msb < other.msb) {
            return -1;
        }
        if (this.msb > other.msb) {
            return 1;
        }
        if (this.lsb < other.lsb) {
            return -1;
        }
        if (this.lsb > other.lsb) {
            return 1;
        }
        return 0;
    }

    protected String toString(char[] alphabet) {
        char[] chars = new char[26];
        long time = this.msb >>> 16;
        long random0 = (this.msb & 0xFFFFL) << 24 | this.lsb >>> 40;
        long random1 = this.lsb & 0xFFFFFFFFFFL;
        chars[0] = alphabet[(int)(time >>> 45 & 0x1FL)];
        chars[1] = alphabet[(int)(time >>> 40 & 0x1FL)];
        chars[2] = alphabet[(int)(time >>> 35 & 0x1FL)];
        chars[3] = alphabet[(int)(time >>> 30 & 0x1FL)];
        chars[4] = alphabet[(int)(time >>> 25 & 0x1FL)];
        chars[5] = alphabet[(int)(time >>> 20 & 0x1FL)];
        chars[6] = alphabet[(int)(time >>> 15 & 0x1FL)];
        chars[7] = alphabet[(int)(time >>> 10 & 0x1FL)];
        chars[8] = alphabet[(int)(time >>> 5 & 0x1FL)];
        chars[9] = alphabet[(int)(time & 0x1FL)];
        chars[10] = alphabet[(int)(random0 >>> 35 & 0x1FL)];
        chars[11] = alphabet[(int)(random0 >>> 30 & 0x1FL)];
        chars[12] = alphabet[(int)(random0 >>> 25 & 0x1FL)];
        chars[13] = alphabet[(int)(random0 >>> 20 & 0x1FL)];
        chars[14] = alphabet[(int)(random0 >>> 15 & 0x1FL)];
        chars[15] = alphabet[(int)(random0 >>> 10 & 0x1FL)];
        chars[16] = alphabet[(int)(random0 >>> 5 & 0x1FL)];
        chars[17] = alphabet[(int)(random0 & 0x1FL)];
        chars[18] = alphabet[(int)(random1 >>> 35 & 0x1FL)];
        chars[19] = alphabet[(int)(random1 >>> 30 & 0x1FL)];
        chars[20] = alphabet[(int)(random1 >>> 25 & 0x1FL)];
        chars[21] = alphabet[(int)(random1 >>> 20 & 0x1FL)];
        chars[22] = alphabet[(int)(random1 >>> 15 & 0x1FL)];
        chars[23] = alphabet[(int)(random1 >>> 10 & 0x1FL)];
        chars[24] = alphabet[(int)(random1 >>> 5 & 0x1FL)];
        chars[25] = alphabet[(int)(random1 & 0x1FL)];
        return new String(chars);
    }

    protected static char[] toCharArray(String string) {
        char[] chars;
        char[] cArray = chars = string == null ? null : string.toCharArray();
        if (!Ulid.isValidCharArray(chars)) {
            throw new IllegalArgumentException(String.format("Invalid ULID: \"%s\"", string));
        }
        return chars;
    }

    protected static boolean isValidCharArray(char[] chars) {
        if (chars == null || chars.length != 26) {
            return false;
        }
        if ((ALPHABET_VALUES[chars[0]] & 0x18L) != 0L) {
            return false;
        }
        for (int i = 0; i < chars.length; ++i) {
            if (ALPHABET_VALUES[chars[i]] != -1L) continue;
            return false;
        }
        return true;
    }

    static {
        for (int i = 0; i < ALPHABET_VALUES.length; ++i) {
            Ulid.ALPHABET_VALUES[i] = -1L;
        }
        Ulid.ALPHABET_VALUES[48] = 0L;
        Ulid.ALPHABET_VALUES[49] = 1L;
        Ulid.ALPHABET_VALUES[50] = 2L;
        Ulid.ALPHABET_VALUES[51] = 3L;
        Ulid.ALPHABET_VALUES[52] = 4L;
        Ulid.ALPHABET_VALUES[53] = 5L;
        Ulid.ALPHABET_VALUES[54] = 6L;
        Ulid.ALPHABET_VALUES[55] = 7L;
        Ulid.ALPHABET_VALUES[56] = 8L;
        Ulid.ALPHABET_VALUES[57] = 9L;
        Ulid.ALPHABET_VALUES[97] = 10L;
        Ulid.ALPHABET_VALUES[98] = 11L;
        Ulid.ALPHABET_VALUES[99] = 12L;
        Ulid.ALPHABET_VALUES[100] = 13L;
        Ulid.ALPHABET_VALUES[101] = 14L;
        Ulid.ALPHABET_VALUES[102] = 15L;
        Ulid.ALPHABET_VALUES[103] = 16L;
        Ulid.ALPHABET_VALUES[104] = 17L;
        Ulid.ALPHABET_VALUES[106] = 18L;
        Ulid.ALPHABET_VALUES[107] = 19L;
        Ulid.ALPHABET_VALUES[109] = 20L;
        Ulid.ALPHABET_VALUES[110] = 21L;
        Ulid.ALPHABET_VALUES[112] = 22L;
        Ulid.ALPHABET_VALUES[113] = 23L;
        Ulid.ALPHABET_VALUES[114] = 24L;
        Ulid.ALPHABET_VALUES[115] = 25L;
        Ulid.ALPHABET_VALUES[116] = 26L;
        Ulid.ALPHABET_VALUES[118] = 27L;
        Ulid.ALPHABET_VALUES[119] = 28L;
        Ulid.ALPHABET_VALUES[120] = 29L;
        Ulid.ALPHABET_VALUES[121] = 30L;
        Ulid.ALPHABET_VALUES[122] = 31L;
        Ulid.ALPHABET_VALUES[111] = 0L;
        Ulid.ALPHABET_VALUES[105] = 1L;
        Ulid.ALPHABET_VALUES[108] = 1L;
        Ulid.ALPHABET_VALUES[65] = 10L;
        Ulid.ALPHABET_VALUES[66] = 11L;
        Ulid.ALPHABET_VALUES[67] = 12L;
        Ulid.ALPHABET_VALUES[68] = 13L;
        Ulid.ALPHABET_VALUES[69] = 14L;
        Ulid.ALPHABET_VALUES[70] = 15L;
        Ulid.ALPHABET_VALUES[71] = 16L;
        Ulid.ALPHABET_VALUES[72] = 17L;
        Ulid.ALPHABET_VALUES[74] = 18L;
        Ulid.ALPHABET_VALUES[75] = 19L;
        Ulid.ALPHABET_VALUES[77] = 20L;
        Ulid.ALPHABET_VALUES[78] = 21L;
        Ulid.ALPHABET_VALUES[80] = 22L;
        Ulid.ALPHABET_VALUES[81] = 23L;
        Ulid.ALPHABET_VALUES[82] = 24L;
        Ulid.ALPHABET_VALUES[83] = 25L;
        Ulid.ALPHABET_VALUES[84] = 26L;
        Ulid.ALPHABET_VALUES[86] = 27L;
        Ulid.ALPHABET_VALUES[87] = 28L;
        Ulid.ALPHABET_VALUES[88] = 29L;
        Ulid.ALPHABET_VALUES[89] = 30L;
        Ulid.ALPHABET_VALUES[90] = 31L;
        Ulid.ALPHABET_VALUES[79] = 0L;
        Ulid.ALPHABET_VALUES[73] = 1L;
        Ulid.ALPHABET_VALUES[76] = 1L;
    }
}

