/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.ulid;

import com.github.f4b6a3.ulid.Ulid;
import java.security.SecureRandom;
import java.time.Clock;
import java.util.Random;
import java.util.function.LongFunction;
import java.util.function.Supplier;

public final class UlidFactory {
    private final Clock clock;
    private final LongFunction<Ulid> ulidFunction;

    public UlidFactory() {
        this(new UlidFunction(UlidFactory.getRandomSupplier(null)));
    }

    private UlidFactory(LongFunction<Ulid> ulidFunction) {
        this(ulidFunction, null);
    }

    private UlidFactory(LongFunction<Ulid> ulidFunction, Clock clock) {
        this.ulidFunction = ulidFunction;
        this.clock = clock != null ? clock : Clock.systemUTC();
    }

    public static UlidFactory newInstance() {
        return UlidFactory.newInstance(UlidFactory.getRandomSupplier(null));
    }

    public static UlidFactory newInstance(Random random) {
        return UlidFactory.newInstance(UlidFactory.getRandomSupplier(random));
    }

    public static UlidFactory newInstance(Supplier<byte[]> randomSupplier) {
        return new UlidFactory(new UlidFunction(randomSupplier));
    }

    public static UlidFactory newMonotonicInstance() {
        return UlidFactory.newMonotonicInstance(UlidFactory.getRandomSupplier(null));
    }

    public static UlidFactory newMonotonicInstance(Random random) {
        return UlidFactory.newMonotonicInstance(UlidFactory.getRandomSupplier(random));
    }

    public static UlidFactory newMonotonicInstance(Supplier<byte[]> randomSupplier) {
        return new UlidFactory(new MonotonicFunction(randomSupplier));
    }

    protected static UlidFactory newMonotonicInstance(Supplier<byte[]> randomSupplier, Clock clock) {
        return new UlidFactory(new MonotonicFunction(randomSupplier), clock);
    }

    public Ulid create() {
        return this.create(this.clock.millis());
    }

    public Ulid create(long time) {
        return this.ulidFunction.apply(time);
    }

    protected static Supplier<byte[]> getRandomSupplier(Random random) {
        Random entropy = random != null ? random : new SecureRandom();
        return () -> {
            byte[] payload = new byte[10];
            entropy.nextBytes(payload);
            return payload;
        };
    }

    protected static final class MonotonicFunction
    implements LongFunction<Ulid> {
        private long lastTime;
        private Ulid lastUlid;
        protected static final int CLOCK_DRIFT_TOLERANCE = 10000;
        private Supplier<byte[]> randomSupplier;

        public MonotonicFunction(Supplier<byte[]> randomSupplier) {
            this.randomSupplier = randomSupplier;
            this.lastTime = Clock.systemUTC().millis();
            this.lastUlid = new Ulid(this.lastTime, randomSupplier.get());
        }

        @Override
        public synchronized Ulid apply(long time) {
            if (time > this.lastTime - 10000L && time <= this.lastTime) {
                this.lastUlid = this.lastUlid.increment();
            } else {
                this.lastTime = time;
                this.lastUlid = new Ulid(time, this.randomSupplier.get());
            }
            return new Ulid(this.lastUlid);
        }
    }

    protected static final class UlidFunction
    implements LongFunction<Ulid> {
        private Supplier<byte[]> randomSupplier;

        public UlidFunction(Supplier<byte[]> randomSupplier) {
            this.randomSupplier = randomSupplier;
        }

        @Override
        public Ulid apply(long time) {
            return new Ulid(time, this.randomSupplier.get());
        }
    }
}

