/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.nodeid;

import com.github.f4b6a3.uuid.nodeid.NodeIdentifierStrategy;
import com.github.f4b6a3.uuid.util.ByteUtil;
import com.github.f4b6a3.uuid.util.NodeIdentifierUtil;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.security.SecureRandom;
import java.util.Enumeration;
import java.util.List;
import java.util.Random;

public class MacNodeIdentifierStrategy
implements NodeIdentifierStrategy {
    protected long nodeIdentifier;
    protected Random random = new SecureRandom();

    public MacNodeIdentifierStrategy() {
        this.nodeIdentifier = this.getHardwareAddress();
    }

    @Override
    public long getNodeIdentifier() {
        return this.nodeIdentifier;
    }

    protected long getHardwareAddress() {
        try {
            Enumeration<NetworkInterface> enm = NetworkInterface.getNetworkInterfaces();
            while (enm.hasMoreElements()) {
                NetworkInterface nic = enm.nextElement();
                List<InterfaceAddress> list = nic.getInterfaceAddresses();
                byte[] mac = nic.getHardwareAddress();
                if (mac == null || list.isEmpty() || nic.isLoopback() || nic.isVirtual()) continue;
                return ByteUtil.toNumber(mac);
            }
        }
        catch (NullPointerException | SocketException e) {
            return this.getRandomMulticastNodeIdentifier();
        }
        return this.getRandomMulticastNodeIdentifier();
    }

    protected long getRandomMulticastNodeIdentifier() {
        return NodeIdentifierUtil.setMulticastNodeIdentifier(this.random.nextLong());
    }
}

