/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.timestamp;

import com.github.f4b6a3.uuid.timestamp.TimestampStrategy;
import java.time.Clock;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;

public class DeltaTimestampStrategy
implements TimestampStrategy {
    protected static final long NANOSECONDS_PER_SECOND = 1000000000L;
    protected static final long TIMESTAMP_RESOLUTION = 100L;
    protected static final long GREGORIAN_SECONDS = LocalDate.parse("1582-10-15").atStartOfDay(ZoneId.of("UTC")).toInstant().getEpochSecond();
    protected static final NanosClock clock = new NanosClock();

    @Override
    public long getTimestamp() {
        Instant instant = Instant.now(clock);
        long seconds = (instant.getEpochSecond() - GREGORIAN_SECONDS) * 10000000L;
        long milliseconds = (long)instant.getNano() / 100L;
        return seconds + milliseconds;
    }

    public static class NanosClock
    extends Clock {
        private final Clock clock;
        private Instant initialInstant;
        private long initialNanoseconds;
        private static final int SYNC_THRESHOLD = 1000000;

        public NanosClock() {
            this(Clock.systemUTC());
        }

        public NanosClock(Clock clock) {
            this.clock = clock;
            this.sync();
        }

        @Override
        public ZoneId getZone() {
            return this.clock.getZone();
        }

        @Override
        public synchronized Instant instant() {
            return this.initialInstant.plusNanos(this.getSystemNanos() - this.initialNanoseconds);
        }

        @Override
        public Clock withZone(ZoneId zone) {
            return new NanosClock(this.clock.withZone(zone));
        }

        protected synchronized long getSystemNanos() {
            long currentNanoseconds = System.nanoTime();
            if (Math.abs(currentNanoseconds - this.initialNanoseconds) > 1000000L) {
                this.sync();
                return this.initialNanoseconds;
            }
            return currentNanoseconds;
        }

        protected void sync() {
            this.initialInstant = this.clock.instant();
            this.initialNanoseconds = System.nanoTime();
        }
    }
}

