/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid;

import com.github.f4b6a3.uuid.factory.CombGuidCreator;
import com.github.f4b6a3.uuid.factory.DceSecurityUuidCreator;
import com.github.f4b6a3.uuid.factory.MssqlGuidCreator;
import com.github.f4b6a3.uuid.factory.NameBasedMd5UuidCreator;
import com.github.f4b6a3.uuid.factory.NameBasedSha1UuidCreator;
import com.github.f4b6a3.uuid.factory.RandomUuidCreator;
import com.github.f4b6a3.uuid.factory.SequentialUuidCreator;
import com.github.f4b6a3.uuid.factory.TimeBasedUuidCreator;
import com.github.f4b6a3.uuid.factory.abst.AbstractNameBasedUuidCreator;
import java.util.UUID;

public class UuidCreator {
    private static SequentialUuidCreator sequentialCreator;
    private static SequentialUuidCreator sequentialWithMacCreator;
    private static TimeBasedUuidCreator timeBasedCreator;
    private static TimeBasedUuidCreator timeBasedWithMacCreator;
    private static AbstractNameBasedUuidCreator nameBasedMd5Creator;
    private static AbstractNameBasedUuidCreator nameBasedSha1Creator;
    private static RandomUuidCreator randomCreator;
    private static RandomUuidCreator fastRandomCreator;
    private static DceSecurityUuidCreator dceSecurityCreator;
    private static DceSecurityUuidCreator dceSecurityWithMacCreator;
    private static MssqlGuidCreator mssqlGuidCreator;
    private static CombGuidCreator combGuidCreator;

    public static UUID getRandom() {
        if (randomCreator == null) {
            randomCreator = UuidCreator.getRandomCreator();
        }
        return randomCreator.create();
    }

    public static UUID getFastRandom() {
        if (fastRandomCreator == null) {
            fastRandomCreator = UuidCreator.getRandomCreator().withFastRandomGenerator();
        }
        return fastRandomCreator.create();
    }

    public static UUID getSequential() {
        if (sequentialCreator == null) {
            sequentialCreator = UuidCreator.getSequentialCreator();
        }
        return sequentialCreator.create();
    }

    public static UUID getSequentialWithMac() {
        if (sequentialWithMacCreator == null) {
            sequentialWithMacCreator = (SequentialUuidCreator)UuidCreator.getSequentialCreator().withHardwareAddress();
        }
        return sequentialWithMacCreator.create();
    }

    public static UUID getTimeBased() {
        if (timeBasedCreator == null) {
            timeBasedCreator = UuidCreator.getTimeBasedCreator();
        }
        return timeBasedCreator.create();
    }

    public static UUID getTimeBasedWithMac() {
        if (timeBasedWithMacCreator == null) {
            timeBasedWithMacCreator = (TimeBasedUuidCreator)UuidCreator.getTimeBasedCreator().withHardwareAddress();
        }
        return timeBasedWithMacCreator.create();
    }

    public static UUID getDceSecurity(byte localDomain, int localIdentifier) {
        if (dceSecurityCreator == null) {
            dceSecurityCreator = UuidCreator.getDceSecurityCreator();
        }
        return dceSecurityCreator.create(localDomain, localIdentifier);
    }

    public static UUID getDceSecurityWithMac(byte localDomain, int localIdentifier) {
        if (dceSecurityWithMacCreator == null) {
            dceSecurityWithMacCreator = (DceSecurityUuidCreator)UuidCreator.getDceSecurityCreator().withHardwareAddress();
        }
        return dceSecurityCreator.create(localDomain, localIdentifier);
    }

    public static UUID getNameBasedMd5(String name) {
        if (nameBasedMd5Creator == null) {
            nameBasedMd5Creator = UuidCreator.getNameBasedMd5Creator();
        }
        return nameBasedMd5Creator.create(name);
    }

    public static UUID getNameBasedMd5(UUID namespace, String name) {
        if (nameBasedMd5Creator == null) {
            nameBasedMd5Creator = UuidCreator.getNameBasedMd5Creator();
        }
        return nameBasedMd5Creator.create(namespace, name);
    }

    public static UUID getNameBasedSha1(String name) {
        if (nameBasedSha1Creator == null) {
            nameBasedSha1Creator = UuidCreator.getNameBasedSha1Creator();
        }
        return nameBasedSha1Creator.create(name);
    }

    public static UUID getNameBasedSha1(UUID namespace, String name) {
        if (nameBasedSha1Creator == null) {
            nameBasedSha1Creator = UuidCreator.getNameBasedSha1Creator();
        }
        return nameBasedSha1Creator.create(namespace, name);
    }

    public static UUID getMssqlGuid() {
        if (mssqlGuidCreator == null) {
            mssqlGuidCreator = UuidCreator.getMssqlCreator();
        }
        return mssqlGuidCreator.create();
    }

    public static UUID getCombGuid() {
        if (combGuidCreator == null) {
            combGuidCreator = UuidCreator.getCombCreator();
        }
        return combGuidCreator.create();
    }

    public static SequentialUuidCreator getSequentialCreator() {
        return new SequentialUuidCreator();
    }

    public static TimeBasedUuidCreator getTimeBasedCreator() {
        return new TimeBasedUuidCreator();
    }

    public static DceSecurityUuidCreator getDceSecurityCreator() {
        return new DceSecurityUuidCreator();
    }

    public static NameBasedMd5UuidCreator getNameBasedMd5Creator() {
        return new NameBasedMd5UuidCreator();
    }

    public static RandomUuidCreator getRandomCreator() {
        return new RandomUuidCreator();
    }

    public static RandomUuidCreator getFastRandomCreator() {
        return new RandomUuidCreator().withFastRandomGenerator();
    }

    public static NameBasedSha1UuidCreator getNameBasedSha1Creator() {
        return new NameBasedSha1UuidCreator();
    }

    public static MssqlGuidCreator getMssqlCreator() {
        return new MssqlGuidCreator();
    }

    public static CombGuidCreator getCombCreator() {
        return new CombGuidCreator();
    }
}

