/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.factory.abst;

import com.github.f4b6a3.uuid.clockseq.ClockSequenceStrategy;
import com.github.f4b6a3.uuid.clockseq.DefaultClockSequenceStrategy;
import com.github.f4b6a3.uuid.clockseq.FixedClockSequenceStrategy;
import com.github.f4b6a3.uuid.enums.UuidVersion;
import com.github.f4b6a3.uuid.factory.abst.AbstractUuidCreator;
import com.github.f4b6a3.uuid.nodeid.DefaultNodeIdentifierStrategy;
import com.github.f4b6a3.uuid.nodeid.FixedNodeIdentifierStrategy;
import com.github.f4b6a3.uuid.nodeid.MacNodeIdentifierStrategy;
import com.github.f4b6a3.uuid.nodeid.NodeIdentifierStrategy;
import com.github.f4b6a3.uuid.timestamp.DefaultTimestampStrategy;
import com.github.f4b6a3.uuid.timestamp.FixedTimestampStretegy;
import com.github.f4b6a3.uuid.timestamp.TimestampStrategy;
import com.github.f4b6a3.uuid.util.SettingsUtil;
import com.github.f4b6a3.uuid.util.TimestampUtil;
import com.github.f4b6a3.uuid.util.UuidUtil;
import java.time.Instant;
import java.util.UUID;

public abstract class AbstractTimeBasedUuidCreator
extends AbstractUuidCreator {
    protected TimestampStrategy timestampStrategy = new DefaultTimestampStrategy();
    protected ClockSequenceStrategy clockSequenceStrategy;
    protected NodeIdentifierStrategy nodeIdentifierStrategy = new DefaultNodeIdentifierStrategy();

    protected AbstractTimeBasedUuidCreator(UuidVersion version) {
        super(version);
        if (SettingsUtil.isStateEnabled()) {
            long timestamp = this.timestampStrategy.getTimestamp();
            long nodeIdentifier = this.nodeIdentifierStrategy.getNodeIdentifier();
            this.clockSequenceStrategy = new DefaultClockSequenceStrategy(timestamp, nodeIdentifier);
        } else {
            this.clockSequenceStrategy = new DefaultClockSequenceStrategy();
        }
    }

    public synchronized UUID create() {
        long timestamp = this.timestampStrategy.getTimestamp();
        long nodeIdentifier = this.nodeIdentifierStrategy.getNodeIdentifier();
        long clockSequence = this.clockSequenceStrategy.getClockSequence(timestamp, nodeIdentifier);
        long msb = this.formatMostSignificantBits(timestamp);
        long lsb = this.formatLeastSignificantBits(nodeIdentifier, clockSequence);
        return new UUID(msb, lsb);
    }

    public <T extends AbstractTimeBasedUuidCreator> T withTimestampStrategy(TimestampStrategy timestampStrategy) {
        this.timestampStrategy = timestampStrategy;
        return (T)this;
    }

    public <T extends AbstractTimeBasedUuidCreator> T withNodeIdentifierStrategy(NodeIdentifierStrategy nodeIdentifierStrategy) {
        this.nodeIdentifierStrategy = nodeIdentifierStrategy;
        return (T)this;
    }

    public <T extends AbstractTimeBasedUuidCreator> T withClockSequenceStrategy(ClockSequenceStrategy clockSequenceStrategy) {
        this.clockSequenceStrategy = clockSequenceStrategy;
        return (T)this;
    }

    public <T extends AbstractTimeBasedUuidCreator> T withInstant(Instant instant) {
        this.timestampStrategy = new FixedTimestampStretegy(TimestampUtil.toTimestamp(instant));
        return (T)this;
    }

    public <T extends AbstractTimeBasedUuidCreator> T withTimestamp(long timestamp) {
        this.timestampStrategy = new FixedTimestampStretegy(timestamp);
        return (T)this;
    }

    public <T extends AbstractTimeBasedUuidCreator> T withNodeIdentifier(long nodeIdentifier) {
        this.nodeIdentifierStrategy = new FixedNodeIdentifierStrategy(nodeIdentifier);
        return (T)this;
    }

    public <T extends AbstractTimeBasedUuidCreator> T withHardwareAddress() {
        this.nodeIdentifierStrategy = new MacNodeIdentifierStrategy();
        return (T)this;
    }

    public <T extends AbstractTimeBasedUuidCreator> T withClockSequence(int clockSequence) {
        this.clockSequenceStrategy = new FixedClockSequenceStrategy(clockSequence);
        return (T)this;
    }

    public abstract long formatMostSignificantBits(long var1);

    public long formatLeastSignificantBits(long nodeIdentifier, long clockSequence) {
        return UuidUtil.formatRfc4122LeastSignificantBits(nodeIdentifier, clockSequence);
    }
}

