/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.factory.abst;

import com.github.f4b6a3.uuid.enums.UuidVersion;
import java.util.UUID;

public abstract class AbstractUuidCreator {
    protected final UuidVersion version;
    public static final UUID NIL_UUID = new UUID(0L, 0L);
    public static final long RFC4122_VARIANT_BITS = Long.MIN_VALUE;
    protected static final long[] RFC4122_VERSION_BITS = new long[]{0L, 4096L, 8192L, 12288L, 16384L, 20480L};

    public AbstractUuidCreator(UuidVersion version) {
        this.version = version;
    }

    public UuidVersion getVersion() {
        return this.version;
    }

    public boolean valid(long msb, long lsb) {
        long variantBits = this.getVariantBits(lsb);
        long versionBits = this.getVersionBits(msb);
        return variantBits == Long.MIN_VALUE && versionBits == RFC4122_VERSION_BITS[this.version.getValue()];
    }

    protected long getVariantBits(long lsb) {
        return lsb & 0xC000000000000000L;
    }

    protected long setVariantBits(long lsb) {
        return lsb & 0x3FFFFFFFFFFFFFFFL | Long.MIN_VALUE;
    }

    protected long getVersionBits(long msb) {
        return msb & 0xF000L;
    }

    protected long setVersionBits(long msb) {
        return msb & 0xFFFFFFFFFFFF0FFFL | RFC4122_VERSION_BITS[this.version.getValue()];
    }
}

