/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.distrib;

import com.github.f4b6a3.uuid.distrib.Distributor;
import com.github.f4b6a3.uuid.util.RandomUtil;

public class CyclicDistributor
implements Distributor {
    private double offset = -1.0;
    private double perimeter;
    private double iteration;
    private double remaining;
    private double arc;

    public CyclicDistributor(int range) {
        this.perimeter = range;
        this.reset();
    }

    protected synchronized void reset() {
        this.iteration = 0.0;
        this.remaining = 0.0;
        this.arc = 0.0;
    }

    protected synchronized long first() {
        this.reset();
        this.offset = RandomUtil.nextInt((int)this.perimeter);
        return (long)this.offset;
    }

    @Override
    public synchronized long handOut() {
        if (this.offset == -1.0) {
            return this.first();
        }
        if (this.remaining == 0.0) {
            this.remaining = (float)Math.pow(2.0, this.iteration);
            this.arc = this.perimeter / this.remaining;
            this.iteration += 1.0;
            if (this.remaining > this.perimeter / 2.0) {
                this.offset = (this.offset + this.arc / 2.0) % this.perimeter;
                this.reset();
                return (int)this.offset;
            }
        }
        return (int)((this.offset + this.arc * (this.remaining -= 1.0) + this.arc / 2.0) % this.perimeter);
    }
}

