/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.creator.nonstandard;

import com.github.f4b6a3.uuid.creator.AbstractRandomBasedUuidCreator;
import com.github.f4b6a3.uuid.enums.UuidVersion;
import com.github.f4b6a3.uuid.util.ByteUtil;
import java.util.UUID;

public final class ShortPrefixCombCreator
extends AbstractRandomBasedUuidCreator {
    protected static final int ONE_MINUTE = 60000;

    public ShortPrefixCombCreator() {
        super(UuidVersion.VERSION_RANDOM_BASED);
    }

    @Override
    public synchronized UUID create() {
        long timestamp = System.currentTimeMillis() / 60000L;
        byte[] bytes = new byte[14];
        this.randomStrategy.nextBytes(bytes);
        long msb = ByteUtil.toNumber(bytes, 8, 14);
        long lsb = ByteUtil.toNumber(bytes, 0, 8);
        msb = msb & 0xFFFFFFFFFFFFL | (timestamp & 0xFFFFL) << 48;
        return new UUID(this.applyVersionBits(msb), this.applyVariantBits(lsb));
    }
}

