/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.creator;

import com.github.f4b6a3.uuid.creator.AbstractUuidCreator;
import com.github.f4b6a3.uuid.enums.UuidNamespace;
import com.github.f4b6a3.uuid.enums.UuidVersion;
import com.github.f4b6a3.uuid.exception.UuidCreatorException;
import com.github.f4b6a3.uuid.util.ByteUtil;
import com.github.f4b6a3.uuid.util.UuidConverter;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.UUID;

public abstract class AbstractNameBasedUuidCreator
extends AbstractUuidCreator {
    protected byte[] namespace = null;
    protected MessageDigest md = null;
    protected static final String MESSAGE_DIGEST_MD5 = "MD5";
    protected static final String MESSAGE_DIGEST_SHA1 = "SHA-1";

    public AbstractNameBasedUuidCreator(UuidVersion version, String messageDigest) {
        super(version);
        try {
            this.md = MessageDigest.getInstance(messageDigest);
        }
        catch (NoSuchAlgorithmException e) {
            throw new UuidCreatorException("Message digest algorithm not supported.");
        }
    }

    public UUID create(byte[] name) {
        return this.create(this.namespace, name);
    }

    public UUID create(String name) {
        return this.create(this.namespace, name.getBytes(StandardCharsets.UTF_8));
    }

    public UUID create(UUID namespace, byte[] name) {
        return this.create(UuidConverter.toBytes(namespace), name);
    }

    public UUID create(UUID namespace, String name) {
        return this.create(UuidConverter.toBytes(namespace), name.getBytes(StandardCharsets.UTF_8));
    }

    public UUID create(String namespace, byte[] name) {
        return this.create(UuidConverter.fromString(namespace), name);
    }

    public UUID create(String namespace, String name) {
        return this.create(UuidConverter.fromString(namespace), name.getBytes(StandardCharsets.UTF_8));
    }

    public UUID create(UuidNamespace namespace, byte[] name) {
        return this.create(namespace.getValue(), name);
    }

    public UUID create(UuidNamespace namespace, String name) {
        return this.create(namespace.getValue(), name.getBytes(StandardCharsets.UTF_8));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UUID create(byte[] namespace, byte[] name) {
        byte[] hash;
        MessageDigest messageDigest = this.md;
        synchronized (messageDigest) {
            this.md.reset();
            if (namespace != null) {
                this.md.update(namespace);
            }
            hash = this.md.digest(name);
        }
        long msb = ByteUtil.toNumber(hash, 0, 8);
        long lsb = ByteUtil.toNumber(hash, 8, 16);
        return new UUID(this.applyVersionBits(msb), this.applyVariantBits(lsb));
    }

    public synchronized <T extends AbstractNameBasedUuidCreator> T withNamespace(UUID namespace) {
        this.namespace = UuidConverter.toBytes(namespace);
        return (T)this;
    }

    public synchronized <T extends AbstractNameBasedUuidCreator> T withNamespace(String namespace) {
        this.namespace = UuidConverter.toBytes(UuidConverter.fromString(namespace));
        return (T)this;
    }

    public synchronized <T extends AbstractNameBasedUuidCreator> T withNamespace(UuidNamespace namespace) {
        this.namespace = UuidConverter.toBytes(namespace.getValue());
        return (T)this;
    }
}

