/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.creator;

import com.github.f4b6a3.uuid.creator.AbstractUuidCreator;
import com.github.f4b6a3.uuid.creator.NoArgumentsUuidCreator;
import com.github.f4b6a3.uuid.enums.UuidVersion;
import com.github.f4b6a3.uuid.strategy.RandomStrategy;
import com.github.f4b6a3.uuid.strategy.random.DefaultRandomStrategy;
import com.github.f4b6a3.uuid.strategy.random.OtherRandomStrategy;
import com.github.f4b6a3.uuid.util.ByteUtil;
import java.util.Random;
import java.util.UUID;

public abstract class AbstractRandomBasedUuidCreator
extends AbstractUuidCreator
implements NoArgumentsUuidCreator {
    protected RandomStrategy randomStrategy = new DefaultRandomStrategy();

    public AbstractRandomBasedUuidCreator(UuidVersion version) {
        super(version);
    }

    @Override
    public UUID create() {
        byte[] bytes = new byte[16];
        this.randomStrategy.nextBytes(bytes);
        long msb = ByteUtil.toNumber(bytes, 0, 8);
        long lsb = ByteUtil.toNumber(bytes, 8, 16);
        return new UUID(this.applyVersionBits(msb), this.applyVariantBits(lsb));
    }

    public synchronized <T extends AbstractRandomBasedUuidCreator> T withRandomStrategy(RandomStrategy randomStrategy) {
        this.randomStrategy = randomStrategy;
        return (T)this;
    }

    public synchronized <T extends AbstractRandomBasedUuidCreator> T withRandomGenerator(Random random) {
        this.randomStrategy = new OtherRandomStrategy(random);
        return (T)this;
    }
}

