/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.strategy.timestamp;

import com.github.f4b6a3.uuid.strategy.TimestampStrategy;
import com.github.f4b6a3.uuid.util.TlsSecureRandom;
import com.github.f4b6a3.uuid.util.UuidTime;
import java.util.concurrent.atomic.AtomicInteger;

public final class DefaultTimestampStrategy
implements TimestampStrategy {
    private AtomicInteger counter;
    private long lastTimestamp = 0L;
    protected static final int COUNTER_MAX = 10000;
    private static final int COUNTER_INITIAL_MASK = 255;

    public DefaultTimestampStrategy() {
        int initial = TlsSecureRandom.get().nextInt() & 0xFF;
        this.counter = new AtomicInteger(initial);
    }

    @Override
    public long getTimestamp() {
        long timestamp = UuidTime.getCurrentTimestamp();
        if (timestamp == this.lastTimestamp) {
            if (this.counter.incrementAndGet() >= 10000) {
                this.resetCounter();
                timestamp = this.nextTimestamp(timestamp);
            }
        } else {
            this.resetCounter();
        }
        this.lastTimestamp = timestamp;
        return timestamp + (long)this.counter.get();
    }

    private long nextTimestamp(long timestamp) {
        while (timestamp <= this.lastTimestamp) {
            timestamp = UuidTime.getCurrentTimestamp();
        }
        return timestamp;
    }

    private void resetCounter() {
        this.counter.updateAndGet(x -> ++x & 0xFF);
    }
}

