/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.util;

import com.github.f4b6a3.uuid.util.ByteUtil;
import com.github.f4b6a3.uuid.util.NetworkData;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;

public final class Fingerprint {
    private static MessageDigest messageDigest;

    private Fingerprint() {
    }

    public static long getFingerprint() {
        byte[] hash = Fingerprint.getHashBytes();
        return ByteUtil.toNumber(hash, hash.length - 8, hash.length);
    }

    public static String getHashString() {
        byte[] hash = Fingerprint.getHashBytes();
        return ByteUtil.toHexadecimal(hash);
    }

    public static byte[] getHashBytes() {
        if (messageDigest == null) {
            messageDigest = Fingerprint.getMessageDigest();
        }
        String string = Fingerprint.getSystemData();
        return messageDigest.digest(string.getBytes());
    }

    public static String getSystemData() {
        String os = Fingerprint.getOperatingSystem();
        String jvm = Fingerprint.getJavaVirtualMachine();
        String net = Fingerprint.getNetwork();
        String loc = Fingerprint.getLocalization();
        String res = Fingerprint.getResources();
        return String.join((CharSequence)" ", os, jvm, net, loc, res);
    }

    protected static String getOperatingSystem() {
        String name = System.getProperty("os.name");
        String version = System.getProperty("os.version");
        String arch = System.getProperty("os.arch");
        return String.join((CharSequence)" ", name, version, arch);
    }

    protected static String getJavaVirtualMachine() {
        String vendor = System.getProperty("java.vendor");
        String version = System.getProperty("java.version");
        String rtName = System.getProperty("java.runtime.name");
        String rtVersion = System.getProperty("java.runtime.version");
        String vmName = System.getProperty("java.vm.name");
        String vmVersion = System.getProperty("java.vm.version");
        return String.join((CharSequence)" ", vendor, version, rtName, rtVersion, vmName, vmVersion);
    }

    protected static String getLocalization() {
        String locale = Locale.getDefault().toString();
        String charset = Charset.defaultCharset().toString();
        String encoding = System.getProperty("file.encoding");
        String timezone = TimeZone.getDefault().getID();
        return String.join((CharSequence)" ", locale, charset, encoding, timezone);
    }

    protected static String getResources() {
        int procs = Runtime.getRuntime().availableProcessors();
        long memory = Runtime.getRuntime().maxMemory();
        return String.join((CharSequence)" ", procs + " processors", memory + " bytes");
    }

    protected static String getNetwork() {
        List<NetworkData> networkDataList;
        NetworkData networkData = NetworkData.getNetworkData();
        if (networkData == null && (networkDataList = NetworkData.getNetworkDataList()) != null && !networkDataList.isEmpty()) {
            networkData = networkDataList.get(0);
        }
        if (networkData == null) {
            return null;
        }
        return networkData.toString();
    }

    private static MessageDigest getMessageDigest() {
        try {
            return MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new InternalError("Message digest algorithm not supported.", e);
        }
    }
}

