/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.util;

import com.github.f4b6a3.uuid.util.UuidUtil;
import com.github.f4b6a3.uuid.util.internal.ByteUtil;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.UUID;

public final class MachineId {
    private static Long id;
    private static UUID uuid;
    private static String hexa;
    private static byte[] hash;
    private static String string;

    private MachineId() {
    }

    public static long getMachineId() {
        if (id == null) {
            byte[] bytes = MachineId.getMachineHash();
            id = ByteUtil.toNumber(bytes, 0, 8);
        }
        return id;
    }

    public static UUID getMachineUuid() {
        if (uuid == null) {
            byte[] bytes = MachineId.getMachineHash();
            long msb = ByteUtil.toNumber(bytes, 0, 8);
            long lsb = ByteUtil.toNumber(bytes, 8, 16);
            uuid = new UUID(msb, lsb);
            UuidUtil.applyVersion(uuid, 4);
        }
        return uuid;
    }

    public static String getMachineHexa() {
        if (hexa == null) {
            byte[] bytes = MachineId.getMachineHash();
            hexa = ByteUtil.toHexadecimal(bytes);
        }
        return hexa;
    }

    public static byte[] getMachineHash() {
        if (hash == null) {
            String string = MachineId.getMachineString();
            hash = MessageDigestHolder.digest(string);
        }
        return hash;
    }

    public static String getMachineString() {
        if (string != null) {
            return string;
        }
        String hostName = null;
        String nicMac = null;
        String nicAddr = null;
        try {
            hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        try {
            Enumeration<NetworkInterface> nics = NetworkInterface.getNetworkInterfaces();
            while (nics.hasMoreElements()) {
                NetworkInterface nic = nics.nextElement();
                if (nic == null || nic.isLoopback()) continue;
                byte[] mac = nic.getHardwareAddress();
                Enumeration<InetAddress> ips = nic.getInetAddresses();
                if (mac == null || mac.length != 6 || !ips.hasMoreElements()) continue;
                nicMac = MachineId.formatMac(mac);
                ArrayList<String> list = new ArrayList<String>();
                while (ips.hasMoreElements()) {
                    InetAddress ip = ips.nextElement();
                    list.add(ip.getHostAddress());
                }
                nicAddr = String.join((CharSequence)" ", list);
                break;
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        string = String.join((CharSequence)" ", hostName, nicMac, nicAddr);
        return string;
    }

    private static String formatMac(byte[] mac) {
        CharSequence[] hex = new String[mac.length];
        for (int i = 0; i < mac.length; ++i) {
            hex[i] = String.format("%02X", mac[i]);
        }
        return String.join((CharSequence)"-", hex);
    }

    private static class MessageDigestHolder {
        static final MessageDigest INSTANCE = MessageDigestHolder.getMessageDigest();

        private MessageDigestHolder() {
        }

        static synchronized byte[] digest(String string) {
            return INSTANCE.digest(string.getBytes());
        }

        private static MessageDigest getMessageDigest() {
            try {
                return MessageDigest.getInstance("SHA-256");
            }
            catch (NoSuchAlgorithmException e) {
                throw new InternalError("Message digest algorithm not supported.", e);
            }
        }
    }
}

