/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.factory;

import com.github.f4b6a3.uuid.enums.UuidVersion;
import com.github.f4b6a3.uuid.factory.NoArgsFactory;
import com.github.f4b6a3.uuid.factory.UuidFactory;
import com.github.f4b6a3.uuid.factory.function.RandomFunction;
import java.util.Random;
import java.util.UUID;

public abstract class AbstRandomBasedFactory
extends UuidFactory
implements NoArgsFactory {
    protected RandomFunction randomFunction;
    protected static final int UUID_BYTES = 16;

    protected AbstRandomBasedFactory(UuidVersion version, RandomFunction randomFunction) {
        super(version);
        this.randomFunction = randomFunction;
    }

    @Override
    public UUID create() {
        byte[] bytes = (byte[])this.randomFunction.apply(16);
        return this.getUuid(bytes);
    }

    protected static RandomFunction getRandomFunction(Random random) {
        return length -> {
            byte[] bytes = new byte[length];
            random.nextBytes(bytes);
            return bytes;
        };
    }
}

