/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.factory.nonstandard;

import com.github.f4b6a3.uuid.enums.UuidVersion;
import com.github.f4b6a3.uuid.factory.AbstRandomBasedFactory;
import com.github.f4b6a3.uuid.factory.function.RandomFunction;
import com.github.f4b6a3.uuid.factory.function.impl.DefaultRandomFunction;
import com.github.f4b6a3.uuid.util.internal.ByteUtil;
import java.time.Clock;
import java.util.Random;
import java.util.UUID;

public final class PrefixCombFactory
extends AbstRandomBasedFactory {
    private final Clock clock;

    public PrefixCombFactory() {
        this(new DefaultRandomFunction());
    }

    public PrefixCombFactory(Clock clock) {
        this(new DefaultRandomFunction(), clock);
    }

    public PrefixCombFactory(Random random) {
        this(PrefixCombFactory.getRandomFunction(random));
    }

    public PrefixCombFactory(Random random, Clock clock) {
        this(PrefixCombFactory.getRandomFunction(random), clock);
    }

    public PrefixCombFactory(RandomFunction randomFunction) {
        this(randomFunction, Clock.systemUTC());
    }

    public PrefixCombFactory(RandomFunction randomFunction, Clock clock) {
        super(UuidVersion.VERSION_RANDOM_BASED, randomFunction);
        this.clock = clock;
    }

    @Override
    public UUID create() {
        byte[] bytes = (byte[])this.randomFunction.apply(10);
        long msb = ((long)bytes[8] & 0xFFL) << 8 | (long)(bytes[9] & 0xFF);
        long lsb = ByteUtil.toNumber(bytes, 0, 8);
        long timestamp = this.clock.millis();
        return this.getUuid(msb |= (timestamp & 0xFFFFFFFFFFFFL) << 16, lsb);
    }
}

