/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.factory.nonstandard;

import com.github.f4b6a3.uuid.enums.UuidVersion;
import com.github.f4b6a3.uuid.factory.AbstRandomBasedFactory;
import com.github.f4b6a3.uuid.factory.function.RandomFunction;
import com.github.f4b6a3.uuid.factory.function.impl.DefaultRandomFunction;
import com.github.f4b6a3.uuid.util.internal.ByteUtil;
import java.time.Clock;
import java.util.Random;
import java.util.UUID;

public final class SuffixCombFactory
extends AbstRandomBasedFactory {
    private final Clock clock;

    public SuffixCombFactory() {
        this(new DefaultRandomFunction());
    }

    public SuffixCombFactory(Clock clock) {
        this(new DefaultRandomFunction(), clock);
    }

    public SuffixCombFactory(Random random) {
        this(SuffixCombFactory.getRandomFunction(random));
    }

    public SuffixCombFactory(Random random, Clock clock) {
        this(SuffixCombFactory.getRandomFunction(random), clock);
    }

    public SuffixCombFactory(RandomFunction randomFunction) {
        this(randomFunction, Clock.systemUTC());
    }

    public SuffixCombFactory(RandomFunction randomFunction, Clock clock) {
        super(UuidVersion.VERSION_RANDOM_BASED, randomFunction);
        this.clock = clock;
    }

    @Override
    public UUID create() {
        byte[] bytes = (byte[])this.randomFunction.apply(10);
        long msb = ByteUtil.toNumber(bytes, 0, 8);
        long lsb = ((long)bytes[8] & 0xFFL) << 8 | (long)(bytes[9] & 0xFF);
        long timestamp = this.clock.millis();
        lsb = lsb << 48 | timestamp & 0xFFFFFFFFFFFFL;
        return this.getUuid(msb, lsb);
    }
}

