/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.factory;

import com.github.f4b6a3.uuid.enums.UuidVersion;
import com.github.f4b6a3.uuid.factory.AbstRandomBasedFactory;
import com.github.f4b6a3.uuid.factory.function.RandomFunction;
import java.time.Clock;
import java.util.Random;

public abstract class AbstCombFactory
extends AbstRandomBasedFactory {
    protected Clock clock;
    protected static final Clock DEFAULT_CLOCK = Clock.systemUTC();

    protected AbstCombFactory(UuidVersion version, Builder<?> builder) {
        super(version, builder.getRandomFunction());
        this.clock = builder.getClock();
    }

    public static abstract class Builder<T> {
        protected Clock clock;
        protected RandomFunction randomFunction;

        protected Clock getClock() {
            if (this.clock == null) {
                this.clock = DEFAULT_CLOCK;
            }
            return this.clock;
        }

        protected RandomFunction getRandomFunction() {
            if (this.randomFunction == null) {
                this.randomFunction = AbstRandomBasedFactory.newRandomFunction(null);
            }
            return this.randomFunction;
        }

        public Builder<T> withClock(Clock clock) {
            this.clock = clock;
            return this;
        }

        public Builder<T> withRandom(Random random) {
            this.randomFunction = AbstRandomBasedFactory.newRandomFunction(random);
            return this;
        }

        public Builder<T> withRandomFunction(RandomFunction randomFunction) {
            this.randomFunction = randomFunction;
            return this;
        }

        public abstract T build();
    }
}

