/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.codec.base;

import com.github.f4b6a3.uuid.exception.InvalidUuidException;
import com.github.f4b6a3.uuid.util.immutable.CharArray;
import com.github.f4b6a3.uuid.util.immutable.LongArray;

public final class BaseN {
    private final int radix;
    private final int length;
    private final char padding;
    private final boolean sensitive;
    private final CharArray alphabet;
    private final LongArray map;
    protected static final int RADIX_MIN = 2;
    protected static final int RADIX_MAX = 64;
    protected static final String ALPHABET_36 = "0123456789abcdefghijklmnopqrstuvwxyz";
    protected static final String ALPHABET_64 = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz-_";
    private static final int BIT_LENGTH = 128;

    public BaseN(int radix) {
        this(BaseN.expand(radix));
    }

    public BaseN(String alphabet) {
        String charset;
        String string = charset = alphabet.indexOf(45) >= 0 ? BaseN.expand(alphabet) : alphabet;
        if (charset.length() < 2 || charset.length() > 64) {
            throw new IllegalArgumentException("Unsupported length: " + charset.length());
        }
        this.radix = charset.length();
        this.length = (int)Math.ceil(128.0 / (Math.log(this.radix) / Math.log(2.0)));
        this.padding = charset.charAt(0);
        this.sensitive = BaseN.sensitive(charset);
        this.alphabet = CharArray.from(charset.toCharArray());
        this.map = BaseN.map(charset, this.sensitive);
    }

    public int getRadix() {
        return this.radix;
    }

    public int getLength() {
        return this.length;
    }

    public char getPadding() {
        return this.padding;
    }

    public boolean isSensitive() {
        return this.sensitive;
    }

    public CharArray getAlphabet() {
        return this.alphabet;
    }

    public LongArray getMap() {
        return this.map;
    }

    public boolean isValid(String string) {
        if (string == null || string.length() != this.length) {
            return false;
        }
        for (int i = 0; i < this.length; ++i) {
            if (this.map.get(string.charAt(i)) != -1L) continue;
            return false;
        }
        return true;
    }

    public void validate(String string) {
        if (!this.isValid(string)) {
            throw InvalidUuidException.newInstance(string);
        }
    }

    private static boolean sensitive(String charset) {
        String lowercase = charset.toLowerCase();
        String uppercase = charset.toUpperCase();
        return !charset.equals(lowercase) && !charset.equals(uppercase);
    }

    private static LongArray map(String alphabet, boolean sensitive) {
        int i;
        long[] mapping = new long[128];
        for (i = 0; i < mapping.length; ++i) {
            mapping[i] = -1L;
        }
        for (i = 0; i < alphabet.length(); ++i) {
            if (sensitive) {
                mapping[alphabet.charAt((int)i)] = i;
                continue;
            }
            mapping[alphabet.toLowerCase().charAt((int)i)] = i;
            mapping[alphabet.toUpperCase().charAt((int)i)] = i;
        }
        return LongArray.from(mapping);
    }

    private static String expand(int radix) {
        if (radix < 2 || radix > 64) {
            throw new IllegalArgumentException("Unsupported radix: " + radix);
        }
        if (radix > 36) {
            return ALPHABET_64.substring(0, radix);
        }
        return ALPHABET_36.substring(0, radix);
    }

    protected static String expand(String string) {
        StringBuilder buffer = new StringBuilder();
        for (int i = 1; i <= string.length(); ++i) {
            char a = string.charAt(i - 1);
            if (i < string.length() - 1 && string.charAt(i) == '-') {
                char b = string.charAt(i + 1);
                char[] expanded = BaseN.expand(a, b);
                if (expanded.length != 0) {
                    i += 2;
                    buffer.append(expanded);
                    continue;
                }
                buffer.append(a);
                continue;
            }
            buffer.append(a);
        }
        return buffer.toString();
    }

    protected static char[] expand(char a, char b) {
        char[] expanded = BaseN.expand(a, b, '0', '9');
        if (expanded.length == 0) {
            expanded = BaseN.expand(a, b, 'a', 'z');
        }
        if (expanded.length == 0) {
            expanded = BaseN.expand(a, b, 'A', 'Z');
        }
        return expanded;
    }

    private static char[] expand(char a, char b, char min, char max) {
        if (a > b || a < min || a > max || b < min || b > max) {
            return new char[0];
        }
        char[] buffer = new char[b - a + 1];
        for (int i = 0; i < buffer.length; ++i) {
            buffer[i] = (char)(a + i);
        }
        return buffer;
    }
}

