/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.factory.nonstandard;

import com.github.f4b6a3.uuid.enums.UuidVersion;
import com.github.f4b6a3.uuid.factory.AbstCombFactory;
import com.github.f4b6a3.uuid.factory.AbstRandomBasedFactory;
import com.github.f4b6a3.uuid.util.internal.ByteUtil;
import java.time.Clock;
import java.util.Random;
import java.util.UUID;
import java.util.function.IntFunction;
import java.util.function.LongSupplier;

public final class ShortPrefixCombFactory
extends AbstCombFactory {
    protected final int interval;
    protected static final int DEFAULT_INTERVAL = 60000;

    public ShortPrefixCombFactory() {
        this(ShortPrefixCombFactory.builder());
    }

    public ShortPrefixCombFactory(Clock clock) {
        this((Builder)ShortPrefixCombFactory.builder().withClock(clock));
    }

    public ShortPrefixCombFactory(Random random) {
        this((Builder)ShortPrefixCombFactory.builder().withRandom(random));
    }

    public ShortPrefixCombFactory(Random random, Clock clock) {
        this((Builder)((Builder)ShortPrefixCombFactory.builder().withRandom(random)).withClock(clock));
    }

    public ShortPrefixCombFactory(LongSupplier randomFunction) {
        this((Builder)ShortPrefixCombFactory.builder().withRandomFunction(randomFunction));
    }

    public ShortPrefixCombFactory(IntFunction<byte[]> randomFunction) {
        this((Builder)ShortPrefixCombFactory.builder().withRandomFunction((IntFunction)randomFunction));
    }

    public ShortPrefixCombFactory(LongSupplier randomFunction, Clock clock) {
        this((Builder)((Builder)ShortPrefixCombFactory.builder().withRandomFunction(randomFunction)).withClock(clock));
    }

    public ShortPrefixCombFactory(IntFunction<byte[]> randomFunction, Clock clock) {
        this((Builder)((Builder)ShortPrefixCombFactory.builder().withRandomFunction((IntFunction)randomFunction)).withClock(clock));
    }

    private ShortPrefixCombFactory(Builder builder) {
        super(UuidVersion.VERSION_RANDOM_BASED, builder);
        this.interval = builder.getInterval();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public synchronized UUID create() {
        long time = this.timeFunction.getAsLong() / (long)this.interval;
        if (this.random instanceof AbstRandomBasedFactory.ByteRandom) {
            byte[] bytes = this.random.nextBytes(14);
            long long1 = ByteUtil.toNumber(bytes, 0, 6);
            long long2 = ByteUtil.toNumber(bytes, 6, 14);
            return this.make(time, long1, long2);
        }
        long long1 = this.random.nextLong();
        long long2 = this.random.nextLong();
        return this.make(time, long1, long2);
    }

    private UUID make(long time, long long1, long long2) {
        return this.toUuid(time << 48 | long1 & 0xFFFFFFFFFFFFL, long2);
    }

    public static class Builder
    extends AbstCombFactory.Builder<ShortPrefixCombFactory, Builder> {
        private Integer interval;

        protected int getInterval() {
            if (this.interval == null) {
                this.interval = 60000;
            }
            return this.interval;
        }

        public Builder withInterval(int interval) {
            this.interval = interval;
            return this;
        }

        @Override
        public ShortPrefixCombFactory build() {
            return new ShortPrefixCombFactory(this);
        }
    }
}

