/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.auth;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCognitoIdentityProvider;
import com.amazonaws.auth.AnonymousAWSCredentials;
import com.amazonaws.auth.IdentityChangedListener;
import com.amazonaws.regions.Region;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.cognitoidentity.AmazonCognitoIdentity;
import com.amazonaws.services.cognitoidentity.AmazonCognitoIdentityClient;
import com.amazonaws.services.cognitoidentity.model.GetIdRequest;
import com.amazonaws.services.cognitoidentity.model.GetIdResult;
import com.amazonaws.services.cognitoidentity.model.GetOpenIdTokenRequest;
import com.amazonaws.services.cognitoidentity.model.GetOpenIdTokenResult;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AWSAbstractCognitoIdentityProvider
implements AWSCognitoIdentityProvider {
    protected final AmazonCognitoIdentity cib;
    protected String identityId;
    private final String accountId;
    private final String identityPoolId;
    protected String token;
    protected Set<IdentityChangedListener> listeners;
    protected Map<String, String> loginsMap;

    public AWSAbstractCognitoIdentityProvider(String accountId, String identityPoolId, AmazonCognitoIdentity cibClient) {
        this.accountId = accountId;
        this.identityPoolId = identityPoolId;
        this.loginsMap = new HashMap<String, String>();
        this.listeners = new HashSet<IdentityChangedListener>();
        this.cib = cibClient;
    }

    @Deprecated
    public AWSAbstractCognitoIdentityProvider(String accountId, String identityPoolId, ClientConfiguration clientConfiguration) {
        this(accountId, identityPoolId, new AmazonCognitoIdentityClient(new AnonymousAWSCredentials(), clientConfiguration));
    }

    public AWSAbstractCognitoIdentityProvider(String accountId, String identityPoolId, ClientConfiguration clientConfiguration, Regions region) {
        this(accountId, identityPoolId, new AmazonCognitoIdentityClient(new AnonymousAWSCredentials(), clientConfiguration));
        this.cib.setRegion(Region.getRegion(region));
    }

    @Deprecated
    public AWSAbstractCognitoIdentityProvider(String accountId, String identityPoolId) {
        this(accountId, identityPoolId, new ClientConfiguration());
    }

    public AWSAbstractCognitoIdentityProvider(String accountId, String identityPoolId, Regions region) {
        this(accountId, identityPoolId, new ClientConfiguration(), region);
    }

    public abstract String getProviderName();

    @Override
    public String getIdentityId() {
        if (this.identityId == null) {
            GetIdRequest getIdRequest = new GetIdRequest().withAccountId(this.getAccountId()).withIdentityPoolId(this.getIdentityPoolId()).withLogins(this.loginsMap);
            this.appendUserAgent(getIdRequest, this.getUserAgent());
            GetIdResult getIdResult = this.cib.getId(getIdRequest);
            if (getIdResult.getIdentityId() != null) {
                this.identityChanged(getIdResult.getIdentityId());
            }
        }
        return this.identityId;
    }

    protected void setIdentityId(String identityId) {
        this.identityId = identityId;
    }

    @Override
    public String getToken() {
        if (this.token == null) {
            GetOpenIdTokenRequest getTokenRequest = new GetOpenIdTokenRequest().withIdentityId(this.getIdentityId()).withLogins(this.loginsMap);
            this.appendUserAgent(getTokenRequest, this.getUserAgent());
            GetOpenIdTokenResult getTokenResult = this.cib.getOpenIdToken(getTokenRequest);
            if (!getTokenResult.getIdentityId().equals(this.getIdentityId())) {
                this.identityChanged(getTokenResult.getIdentityId());
            }
            this.token = getTokenResult.getToken();
        }
        return this.token;
    }

    protected void setToken(String token) {
        this.token = token;
    }

    @Override
    public String getIdentityPoolId() {
        return this.identityPoolId;
    }

    public String getAccountId() {
        return this.accountId;
    }

    @Override
    public Map<String, String> getLogins() {
        return this.loginsMap;
    }

    @Override
    public void setLogins(Map<String, String> logins) {
        this.loginsMap = logins;
    }

    @Override
    public boolean isAuthenticated() {
        return this.loginsMap != null && this.loginsMap.size() > 0;
    }

    @Override
    public void unregisterIdentityChangedListener(IdentityChangedListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void registerIdentityChangedListener(IdentityChangedListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void identityChanged(String newIdentityId) {
        if (this.identityId != null && this.identityId.equals(newIdentityId)) {
            return;
        }
        String oldIdentityId = this.identityId;
        this.identityId = newIdentityId;
        for (IdentityChangedListener listener : this.listeners) {
            listener.identityChanged(oldIdentityId, this.identityId);
        }
    }

    protected void appendUserAgent(AmazonWebServiceRequest request, String userAgent) {
        request.getRequestClientOptions().appendUserAgent(userAgent);
    }

    @Override
    public void clearListeners() {
        this.listeners.clear();
    }

    protected String getUserAgent() {
        return "";
    }

    protected void update(String identityId, String token) {
        if (this.identityId == null || !this.identityId.equals(identityId)) {
            this.identityChanged(identityId);
        }
        if (this.token == null || !this.token.equals(token)) {
            this.token = token;
        }
    }

    @Override
    public String refresh() {
        this.getIdentityId();
        String token = this.getToken();
        this.update(this.getIdentityId(), token);
        return token;
    }
}

