/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.core.configuration;

import com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.core.AnalyticsContext;
import com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.core.configuration.Configuration;
import com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.core.log.Logger;
import com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.core.system.Preferences;
import com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.core.util.Preconditions;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.json.JSONException;
import org.json.JSONObject;

public class PreferencesConfiguration
implements Configuration {
    private static final Logger logger = Logger.getLogger(PreferencesConfiguration.class);
    private static final String CONFIG_KEY = "configuration";
    private final AnalyticsContext context;
    private Map<String, String> properties = new ConcurrentHashMap<String, String>();

    public static PreferencesConfiguration newInstance(AnalyticsContext context) {
        return new PreferencesConfiguration(context);
    }

    PreferencesConfiguration(AnalyticsContext context) {
        String configurationJsonString;
        Preconditions.checkNotNull(context);
        this.context = context;
        JSONObject configJson = null;
        Preferences preferences = this.getContext().getSystem().getPreferences();
        if (preferences != null && (configurationJsonString = preferences.getString(CONFIG_KEY, null)) != null) {
            try {
                configJson = new JSONObject(configurationJsonString);
            }
            catch (JSONException e) {
                logger.e("could not create Json object of Config", e);
            }
        }
        this.updateMappings(configJson);
    }

    public Long getLong(String propertyName) {
        Long value = null;
        String valueString = this.properties.get(propertyName);
        if (valueString != null) {
            try {
                value = Long.decode(valueString);
            }
            catch (Exception ex) {
                logger.e(String.format("Could not get Long for propertyName: %s", propertyName), ex);
            }
        }
        return value;
    }

    public String getString(String propertyName) {
        String value = this.properties.get(propertyName);
        return value;
    }

    public Integer getInt(String propertyName) {
        Integer value = null;
        String valueString = this.properties.get(propertyName);
        if (valueString != null) {
            try {
                value = Integer.decode(valueString);
            }
            catch (Exception ex) {
                logger.e(String.format("Could not get Integer for propertyName: %s", propertyName), ex);
            }
        }
        return value;
    }

    public Double getDouble(String propertyName) {
        Double value = null;
        String valueString = this.properties.get(propertyName);
        if (valueString != null) {
            try {
                value = Double.parseDouble(valueString);
            }
            catch (Exception ex) {
                logger.e(String.format("Could not get Double for propertyName: %s", propertyName), ex);
            }
        }
        return value;
    }

    public Boolean getBoolean(String propertyName) {
        Boolean value = null;
        String valueString = this.properties.get(propertyName);
        if (valueString != null) {
            try {
                value = Boolean.parseBoolean(valueString);
            }
            catch (Exception ex) {
                logger.e(String.format("Could not get Boolean for propertyName: %s", propertyName), ex);
            }
        }
        return value;
    }

    public Short getShort(String propertyName) {
        Short value = null;
        String valueString = this.properties.get(propertyName);
        if (valueString != null) {
            try {
                if (this.properties.containsKey(propertyName)) {
                    value = Short.decode(valueString);
                }
            }
            catch (Exception ex) {
                logger.e(String.format("Could not get Short for propertyName: %s", propertyName), ex);
            }
        }
        return value;
    }

    public Long optLong(String propertyName, Long optValue) {
        Long value = this.getLong(propertyName);
        return value != null ? value : optValue;
    }

    public String optString(String propertyName, String optValue) {
        String value = this.getString(propertyName);
        return value != null ? value : optValue;
    }

    public Integer optInt(String propertyName, Integer optValue) {
        Integer value = this.getInt(propertyName);
        return value != null ? value : optValue;
    }

    public Short optShort(String propertyName, Short optValue) {
        Short value = this.getShort(propertyName);
        return value != null ? value : optValue;
    }

    public Double optDouble(String propertyName, Double optValue) {
        Double value = this.getDouble(propertyName);
        return value != null ? value : optValue;
    }

    public Boolean optBoolean(String propertyName, Boolean optValue) {
        Boolean value = this.getBoolean(propertyName);
        return value != null ? value : optValue;
    }

    private void updateMappings(JSONObject configJson) {
        HashMap<String, String> newProperties = new HashMap<String, String>();
        if (configJson != null) {
            Iterator keys = configJson.keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                try {
                    String value = configJson.getString(key);
                    newProperties.put(key, value);
                }
                catch (JSONException e) {
                    logger.e("could not update property mappings", e);
                }
            }
        }
        this.properties.putAll(newProperties);
    }

    private AnalyticsContext getContext() {
        return this.context;
    }
}

