/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.core.idresolver;

import android.content.Context;
import android.content.SharedPreferences;
import com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.core.AnalyticsContext;
import com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.core.idresolver.Id;
import com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.core.idresolver.RandomUUIDGenerator;
import com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.core.idresolver.UniqueIdGenerator;
import com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.core.idresolver.UniqueIdService;
import com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.core.log.Logger;
import com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.core.system.Preferences;

public class SharedPrefsUniqueIdService
implements UniqueIdService {
    private static Logger logger = Logger.getLogger(SharedPrefsUniqueIdService.class);
    protected static final String PREFS_NAME = SharedPrefsUniqueIdService.class.getName();
    protected static final String UNIQUE_ID_KEY = "UniqueId";
    private String appId = null;
    private Context applicationContext = null;
    private final UniqueIdGenerator generator;

    public static UniqueIdService newInstance(String appId, Context applicationContext) {
        return new SharedPrefsUniqueIdService(new RandomUUIDGenerator(), appId, applicationContext);
    }

    public SharedPrefsUniqueIdService(UniqueIdGenerator generator, String appId, Context applicationContext) {
        this.generator = generator;
        this.appId = appId;
        this.applicationContext = applicationContext;
    }

    public Id getUniqueId(AnalyticsContext context) {
        if (context == null || context.getSystem() == null || context.getSystem().getPreferences() == null) {
            logger.devd("Unable to generate unique id, context has not been fully initialized");
            return Id.getEmptyId();
        }
        Id uniqueId = this.getIdFromPreferences(context.getSystem().getPreferences());
        if (uniqueId == Id.getEmptyId()) {
            uniqueId = new Id(this.generator.generateUniqueIdString());
            this.storeUniqueId(context.getSystem().getPreferences(), uniqueId);
        }
        return uniqueId;
    }

    private Id getIdFromPreferences(Preferences preferences) {
        Id uniqueId = Id.getEmptyId();
        if (this.getLegacyId() != Id.getEmptyId()) {
            return this.getLegacyId();
        }
        String uniqueIdString = preferences.getString(UNIQUE_ID_KEY, null);
        if (uniqueIdString != null) {
            uniqueId = new Id(uniqueIdString);
        }
        return uniqueId;
    }

    private Id getLegacyId() {
        if (this.appId == null || this.applicationContext == null) {
            return Id.getEmptyId();
        }
        SharedPreferences legacyPreferences = this.applicationContext.getSharedPreferences(this.appId, 0);
        String legacyId = legacyPreferences.getString(UNIQUE_ID_KEY, null);
        if (legacyId != null) {
            return new Id(legacyId);
        }
        return Id.getEmptyId();
    }

    private void storeUniqueId(Preferences preferences, Id uniqueId) {
        try {
            preferences.putString(UNIQUE_ID_KEY, uniqueId.getValue());
        }
        catch (Exception ex) {
            logger.e("There was an exception when trying to store the unique id into the Preferences", ex);
        }
    }
}

