/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.core.system;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.core.log.Logger;
import com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.core.system.AppDetails;

public class AndroidAppDetails
implements AppDetails {
    private static Logger logger = Logger.getLogger(AndroidAppDetails.class);
    private Context applicationContext;
    private String appTitle;
    private String packageName;
    private String versionCode;
    private String versionName;
    private String appId;

    public AndroidAppDetails(Context context, String appId) {
        this.applicationContext = context.getApplicationContext();
        try {
            PackageManager packageManager = this.applicationContext.getPackageManager();
            PackageInfo packageInfo = packageManager.getPackageInfo(this.applicationContext.getPackageName(), 0);
            ApplicationInfo appInfo = packageManager.getApplicationInfo(packageInfo.packageName, 0);
            this.appTitle = (String)packageManager.getApplicationLabel(appInfo);
            this.packageName = packageInfo.packageName;
            this.versionCode = String.valueOf(packageInfo.versionCode);
            this.versionName = packageInfo.versionName;
            this.appId = appId;
        }
        catch (PackageManager.NameNotFoundException e) {
            logger.w("Unable to get details for package " + this.applicationContext.getPackageName());
            this.appTitle = "Unknown";
            this.packageName = "Unknown";
            this.versionCode = "Unknown";
            this.versionName = "Unknown";
        }
    }

    public AndroidAppDetails(String packageName, String versionCode, String versionName, String appTitle, String appId) {
        this.packageName = packageName;
        this.versionCode = versionCode;
        this.versionName = versionName;
        this.appTitle = appTitle;
        this.appId = appId;
    }

    public String packageName() {
        return this.packageName;
    }

    public String versionName() {
        return this.versionName;
    }

    public String versionCode() {
        return this.versionCode;
    }

    public String getAppTitle() {
        return this.appTitle;
    }

    public String getAppId() {
        return this.appId;
    }
}

