/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.core.system;

import android.content.ContentResolver;
import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.provider.Settings;
import com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.core.log.Logger;
import com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.core.system.Connectivity;

public class AndroidConnectivity
implements Connectivity {
    private static final Logger logger = Logger.getLogger(Connectivity.class);
    protected boolean hasWifi;
    protected boolean hasMobile;
    protected boolean inAirplaneMode;
    private Context context;

    public AndroidConnectivity(Context context) {
        this.context = context;
    }

    public boolean isConnected() {
        this.determineAvailability();
        return this.hasWifi() || this.hasWAN();
    }

    public boolean hasWifi() {
        return this.hasWifi;
    }

    public boolean hasWAN() {
        return this.hasMobile && !this.inAirplaneMode;
    }

    private void determineAvailability() {
        ConnectivityManager cm = (ConnectivityManager)this.context.getSystemService("connectivity");
        this.inAirplaneMode = Settings.System.getInt((ContentResolver)this.context.getContentResolver(), (String)"airplane_mode_on", (int)0) != 0;
        logger.v("Airplane mode: " + this.inAirplaneMode);
        NetworkInfo networkInfo = cm != null ? cm.getActiveNetworkInfo() : null;
        int networkType = 0;
        this.hasWifi = false;
        boolean bl = this.hasMobile = cm != null;
        if (networkInfo != null) {
            if (networkInfo.isConnectedOrConnecting()) {
                networkType = networkInfo.getType();
                this.hasWifi = networkType == 1 || networkType == 6;
                this.hasMobile = networkType == 0 || networkType == 4 || networkType == 5 || networkType == 2 || networkType == 3;
            } else {
                this.hasMobile = false;
            }
        }
        logger.v(String.format("Device Connectivity (%s)", this.hasWifi ? "On Wifi" : (this.hasMobile ? "On Mobile" : "No network connectivity")));
    }
}

