/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.core.system;

import android.content.Context;
import android.telephony.TelephonyManager;
import com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.core.system.AndroidAppDetails;
import com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.core.system.AndroidConnectivity;
import com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.core.system.AndroidDeviceDetails;
import com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.core.system.AndroidPreferences;
import com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.core.system.AppDetails;
import com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.core.system.Connectivity;
import com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.core.system.DefaultFileManager;
import com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.core.system.DeviceDetails;
import com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.core.system.FileManager;
import com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.core.system.Preferences;
import com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.core.system.System;

public class AndroidSystem
implements System {
    private final Preferences preferences;
    private final FileManager fileManager;
    private final Connectivity connectivity;
    private final AppDetails appDetails;
    private final DeviceDetails deviceDetails;
    private static final String PREFERENCES_AND_FILE_MANAGER_SUFFIX = "515d6767-01b7-49e5-8273-c8d11b0f331d";

    public AndroidSystem(Context context, String appId) {
        this.preferences = new AndroidPreferences(context, appId + PREFERENCES_AND_FILE_MANAGER_SUFFIX);
        this.fileManager = new DefaultFileManager(context.getDir(appId + PREFERENCES_AND_FILE_MANAGER_SUFFIX, 0));
        this.connectivity = new AndroidConnectivity(context);
        this.appDetails = new AndroidAppDetails(context, appId);
        this.deviceDetails = new AndroidDeviceDetails(this.getCarrier(context));
    }

    private String getCarrier(Context context) {
        try {
            TelephonyManager telephony = (TelephonyManager)context.getSystemService("phone");
            if (null != telephony.getNetworkOperatorName() && !telephony.getNetworkOperatorName().equals("")) {
                return telephony.getNetworkOperatorName();
            }
            return "Unknown";
        }
        catch (Exception ex) {
            return "Unknown";
        }
    }

    public FileManager getFileManager() {
        return this.fileManager;
    }

    public Preferences getPreferences() {
        return this.preferences;
    }

    public Connectivity getConnectivity() {
        return this.connectivity;
    }

    public AppDetails getAppDetails() {
        return this.appDetails;
    }

    public DeviceDetails getDeviceDetails() {
        return this.deviceDetails;
    }
}

