/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.delivery;

import com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.core.AnalyticsContext;
import com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.core.log.Logger;
import com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.core.system.FileManager;
import com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.delivery.EventStore;
import com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.delivery.EventStoreException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.concurrent.locks.ReentrantLock;

public class FileEventStore
implements EventStore {
    private static final Logger logger = Logger.getLogger(FileEventStore.class);
    static final String EVENTS_DIRECTORY = "events";
    static final String EVENT_FILE_NAME = "eventsFile";
    static final String KEY_MAX_STORAGE_SIZE = "maxStorageSize";
    static final long MAX_STORAGE_SIZE = 0x500000L;
    static final double ERROR_LENGTH_THRESHOLD_PERCENTAGE = 1.1;
    private final ReentrantLock accessLock = new ReentrantLock(true);
    private final AnalyticsContext context;
    private File eventsFile;

    public static FileEventStore newInstance(AnalyticsContext context) {
        return new FileEventStore(context);
    }

    public FileEventStore(AnalyticsContext context) {
        this.context = context;
        this.tryCreateEventsFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean put(String event) throws EventStoreException {
        boolean success = false;
        BufferedWriter writer = null;
        this.accessLock.lock();
        try {
            writer = this.tryInitializeWriter();
            if (writer != null) {
                long maxStorageSize = this.context.getConfiguration().optLong(KEY_MAX_STORAGE_SIZE, 0x500000L);
                if (this.eventsFile.length() + (long)event.length() <= maxStorageSize) {
                    writer.write(event);
                    writer.flush();
                    writer.newLine();
                    success = true;
                } else {
                    logger.e("The events file exceeded its allowed size of " + maxStorageSize + " bytes");
                }
            }
        }
        catch (IOException e) {
            logger.e("Failed to persist the event", e);
        }
        finally {
            this.accessLock.unlock();
            this.tryCloseWriter(writer);
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tryCreateEventsFile() {
        if (this.eventsFile != null && this.eventsFile.exists()) {
            return true;
        }
        FileEventStore fileEventStore = this;
        synchronized (fileEventStore) {
            if (this.eventsFile != null && this.eventsFile.exists()) {
                return true;
            }
            try {
                FileManager fileManager = this.context.getSystem().getFileManager();
                File eventsDir = fileManager.createDirectory(EVENTS_DIRECTORY);
                this.eventsFile = fileManager.createFile(new File(eventsDir, EVENT_FILE_NAME));
                return true;
            }
            catch (IOException e) {
                logger.deve("Unable to open events file");
                logger.e("An error occurred while attempting to create/open the events file", e);
                return false;
            }
        }
    }

    private BufferedWriter tryInitializeWriter() throws EventStoreException {
        BufferedWriter writer = null;
        try {
            if (!this.tryCreateEventsFile()) {
                throw new EventStoreException("Unable to create eventsFile");
            }
            OutputStream stream = this.context.getSystem().getFileManager().newOutputStream(this.eventsFile, true);
            writer = new BufferedWriter(new OutputStreamWriter(stream));
        }
        catch (EventStoreException e) {
            throw e;
        }
        catch (FileNotFoundException e) {
            logger.e("Events file not found to persist event to", e);
            throw new EventStoreException("Unable to open events file writer", e);
        }
        catch (Exception e) {
            logger.e("Unexpected exception", e);
            throw new EventStoreException("Unexpected error while creating eventsFile writer", e);
        }
        return writer;
    }

    private void tryCloseWriter(Writer writer) throws EventStoreException {
        if (writer != null) {
            try {
                writer.close();
            }
            catch (IOException e) {
                logger.e("Unable to close writer for events file", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private File deleteReadEvents(int lineNumber) {
        block46: {
            File eventsDir;
            block43: {
                IOException e3222;
                PrintWriter writer;
                BufferedReader reader;
                boolean errorsOccurred;
                File tempEventsFile;
                FileManager fileManager;
                block42: {
                    fileManager = this.context.getSystem().getFileManager();
                    eventsDir = fileManager.createDirectory(EVENTS_DIRECTORY);
                    tempEventsFile = null;
                    try {
                        File tempFile = new File(eventsDir, "eventsFile.tmp");
                        if (tempFile.exists() && !tempFile.delete()) {
                            logger.e("Failed to delete previous temp file");
                        }
                        tempEventsFile = fileManager.createFile(tempFile);
                    }
                    catch (IOException e2) {
                        logger.e("An error occurred while attempting to create/open the temporary events file", e2);
                        return this.eventsFile;
                    }
                    errorsOccurred = false;
                    if (tempEventsFile == null || !this.eventsFile.exists() || !tempEventsFile.exists()) break block46;
                    reader = null;
                    writer = null;
                    reader = new BufferedReader(new FileReader(this.eventsFile));
                    writer = new PrintWriter(new FileWriter(tempEventsFile, true));
                    String line = null;
                    int currentLineNumber = 0;
                    while ((line = reader.readLine()) != null) {
                        if (++currentLineNumber <= lineNumber) continue;
                        writer.println(line);
                        writer.flush();
                    }
                    Object var11_14 = null;
                    if (writer != null) {
                        writer.close();
                    }
                    if (reader == null) break block42;
                    try {
                        reader.close();
                    }
                    catch (IOException e3222) {
                        // empty catch block
                    }
                }
                if (errorsOccurred) break block43;
                if (this.eventsFile.delete()) {
                    if (!tempEventsFile.renameTo(this.eventsFile)) {
                        logger.e("Failed to rename temp file to events file");
                    }
                    try {
                        this.eventsFile = fileManager.createFile(new File(eventsDir, EVENT_FILE_NAME));
                    }
                    catch (IOException e3222) {
                        logger.e("An error occurred while attempting to create the eventsFile", e3222);
                    }
                } else {
                    logger.e("Failed to delete previous events file");
                    {
                        break block43;
                        catch (FileNotFoundException e4) {
                            IOException e3222;
                            errorsOccurred = true;
                            logger.e("The events file count not be found", e4);
                            Object var11_15 = null;
                            if (writer != null) {
                                writer.close();
                            }
                            if (reader != null) {
                                try {
                                    reader.close();
                                }
                                catch (IOException e3222) {
                                    // empty catch block
                                }
                            }
                            if (!errorsOccurred) {
                                if (this.eventsFile.delete()) {
                                    if (!tempEventsFile.renameTo(this.eventsFile)) {
                                        logger.e("Failed to rename temp file to events file");
                                    }
                                    try {
                                        this.eventsFile = fileManager.createFile(new File(eventsDir, EVENT_FILE_NAME));
                                    }
                                    catch (IOException e3222) {
                                        logger.e("An error occurred while attempting to create the eventsFile", e3222);
                                    }
                                } else {
                                    logger.e("Failed to delete previous events file");
                                }
                            }
                            break block43;
                        }
                        catch (IOException e5) {
                            IOException e3222;
                            logger.e("An error occurred while attempting to delete the read events", e5);
                            errorsOccurred = true;
                            Object var11_16 = null;
                            if (writer != null) {
                                writer.close();
                            }
                            if (reader != null) {
                                try {
                                    reader.close();
                                }
                                catch (IOException e3222) {
                                    // empty catch block
                                }
                            }
                            if (!errorsOccurred) {
                                if (this.eventsFile.delete()) {
                                    if (!tempEventsFile.renameTo(this.eventsFile)) {
                                        logger.e("Failed to rename temp file to events file");
                                    }
                                    try {
                                        this.eventsFile = fileManager.createFile(new File(eventsDir, EVENT_FILE_NAME));
                                    }
                                    catch (IOException e3222) {
                                        logger.e("An error occurred while attempting to create the eventsFile", e3222);
                                    }
                                } else {
                                    logger.e("Failed to delete previous events file");
                                }
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        IOException e3222;
                        Object var11_17 = null;
                        if (writer != null) {
                            writer.close();
                        }
                        if (reader != null) {
                            try {
                                reader.close();
                            }
                            catch (IOException e3222) {
                                // empty catch block
                            }
                        }
                        if (!errorsOccurred) {
                            if (this.eventsFile.delete()) {
                                if (!tempEventsFile.renameTo(this.eventsFile)) {
                                    logger.e("Failed to rename temp file to events file");
                                }
                                try {
                                    this.eventsFile = fileManager.createFile(new File(eventsDir, EVENT_FILE_NAME));
                                }
                                catch (IOException e3222) {
                                    logger.e("An error occurred while attempting to create the eventsFile", e3222);
                                }
                            } else {
                                logger.e("Failed to delete previous events file");
                            }
                        }
                        throw throwable;
                    }
                }
            }
            File tempFile = new File(eventsDir, "eventsFile.tmp");
            if (tempFile.exists() && !tempFile.delete()) {
                logger.e("Failed to delete temp file");
            }
        }
        return this.eventsFile;
    }

    public EventStore.EventIterator iterator() {
        return new EventStore.EventIterator(){
            int linesRead = 0;
            String nextBuffer = null;
            BufferedReader reader = null;
            boolean isEndOfFile = false;

            private boolean tryOpenReader() {
                if (this.reader != null) {
                    return true;
                }
                if (!this.isEndOfFile) {
                    InputStreamReader streamReader = null;
                    try {
                        streamReader = new InputStreamReader(FileEventStore.this.context.getSystem().getFileManager().newInputStream(FileEventStore.this.eventsFile));
                    }
                    catch (FileNotFoundException e) {
                        logger.e("Could not open the events file", e);
                    }
                    if (streamReader != null) {
                        this.reader = new BufferedReader(streamReader);
                        return true;
                    }
                }
                return false;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void tryCloseReader() {
                if (this.reader != null) {
                    try {
                        this.reader.close();
                    }
                    catch (IOException ioe) {
                        logger.e("Unable to close reader for events file", ioe);
                    }
                    finally {
                        this.reader = null;
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean hasNext() {
                boolean hasNext = false;
                FileEventStore.this.accessLock.lock();
                try {
                    if (this.nextBuffer != null) {
                        hasNext = true;
                    } else {
                        if (!this.tryOpenReader()) {
                            boolean bl = hasNext;
                            return bl;
                        }
                        boolean found = false;
                        while (!found) {
                            try {
                                this.nextBuffer = this.reader.readLine();
                                found = true;
                            }
                            catch (IOException e) {
                                this.nextBuffer = null;
                                found = true;
                            }
                        }
                        if (this.nextBuffer != null) {
                            hasNext = true;
                        } else {
                            this.isEndOfFile = true;
                            this.tryCloseReader();
                        }
                    }
                    boolean bl = hasNext;
                    return bl;
                }
                finally {
                    FileEventStore.this.accessLock.unlock();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public String next() {
                String next = null;
                FileEventStore.this.accessLock.lock();
                try {
                    if (this.nextBuffer != null) {
                        next = this.nextBuffer;
                        ++this.linesRead;
                        this.nextBuffer = null;
                    } else {
                        if (!this.tryOpenReader()) {
                            String string = next;
                            return string;
                        }
                        boolean found = false;
                        while (!found) {
                            try {
                                next = this.reader.readLine();
                                found = true;
                            }
                            catch (IOException e) {
                                next = null;
                                found = true;
                            }
                        }
                        if (next != null) {
                            ++this.linesRead;
                        } else {
                            this.isEndOfFile = true;
                            this.tryCloseReader();
                        }
                    }
                    String string = next;
                    return string;
                }
                finally {
                    FileEventStore.this.accessLock.unlock();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public String peek() {
                FileEventStore.this.accessLock.lock();
                try {
                    this.hasNext();
                    String string = this.nextBuffer;
                    return string;
                }
                finally {
                    FileEventStore.this.accessLock.unlock();
                }
            }

            public void remove() {
                throw new UnsupportedOperationException("The remove() operation is not supported for this iterator");
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void removeReadEvents() {
                FileEventStore.this.accessLock.lock();
                try {
                    FileEventStore.this.deleteReadEvents(this.linesRead);
                    this.resetReader();
                }
                finally {
                    FileEventStore.this.accessLock.unlock();
                }
            }

            private void resetReader() {
                this.tryCloseReader();
                this.linesRead = 0;
                this.nextBuffer = null;
            }
        };
    }
}

