/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.event;

import com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.core.AnalyticsContext;
import com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.core.idresolver.Id;
import com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.core.log.Logger;
import com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.core.system.AppDetails;
import com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.core.system.DeviceDetails;
import com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.core.util.JSONBuilder;
import com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.core.util.SDKInfo;
import com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.event.ClientContext;
import com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.event.InternalEvent;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DefaultEvent
implements InternalEvent {
    private static Logger logger = Logger.getLogger(DefaultEvent.class);
    private final String eventType;
    private final String sdkName;
    private final String sdkVersion;
    private final String sessionId;
    private final Long sessionStart;
    private final Long sessionStop;
    private final Long sessionDuration;
    private final Map<String, String> attributes = new ConcurrentHashMap<String, String>();
    private final Map<String, Double> metrics = new ConcurrentHashMap<String, Double>();
    private final Long timestamp;
    private final Id uniqueId;
    private final AppDetails appDetails;
    private final DeviceDetails deviceDetails;

    public static DefaultEvent createFromEvent(AnalyticsContext context, String sessionId, long timestamp, InternalEvent copyEvent) {
        return new DefaultEvent(copyEvent.getEventType(), copyEvent.getAllAttributes(), copyEvent.getAllMetrics(), context.getSDKInfo(), sessionId, copyEvent.getSessionStart(), copyEvent.getSessionStop(), copyEvent.getSessionDuration(), timestamp, context.getUniqueId(), context.getSystem().getAppDetails(), context.getSystem().getDeviceDetails());
    }

    public static DefaultEvent newInstance(AnalyticsContext context, String sessionId, Long sessionStart, Long sessionEnd, Long duration, long timestamp, String eventType) {
        return new DefaultEvent(eventType, null, null, context.getSDKInfo(), sessionId, sessionStart, sessionEnd, duration, timestamp, context.getUniqueId(), context.getSystem().getAppDetails(), context.getSystem().getDeviceDetails());
    }

    public static DefaultEvent newInstance(String eventType, Map<String, String> attributes, Map<String, Double> metrics, SDKInfo sdkInfo, String sessionId, Long sessionStart, Long sessionStop, Long sessionDuration, long timestamp, Id uniqueId, AppDetails appDetails, DeviceDetails deviceDetails) {
        return new DefaultEvent(eventType, attributes, metrics, sdkInfo, sessionId, sessionStart, sessionStop, sessionDuration, timestamp, uniqueId, appDetails, deviceDetails);
    }

    DefaultEvent(String eventType, Map<String, String> attributes, Map<String, Double> metrics, SDKInfo sdkInfo, String sessionId, long sessionStart, Long sessionEnd, Long sessionDuration, long timestamp, Id uniqueId, AppDetails appDetails, DeviceDetails deviceDetails) {
        this.sdkName = sdkInfo.getName();
        this.sdkVersion = sdkInfo.getVersion();
        this.sessionId = sessionId;
        this.sessionStart = sessionStart;
        this.sessionStop = sessionEnd;
        this.sessionDuration = sessionDuration;
        this.timestamp = timestamp;
        this.uniqueId = uniqueId;
        this.eventType = eventType;
        this.appDetails = appDetails;
        this.deviceDetails = deviceDetails;
        if (null != attributes) {
            for (Map.Entry<String, Object> entry : attributes.entrySet()) {
                this.addAttribute(entry.getKey(), (String)entry.getValue());
            }
        }
        if (null != metrics) {
            for (Map.Entry<String, Object> entry : metrics.entrySet()) {
                this.addMetric(entry.getKey(), (Double)entry.getValue());
            }
        }
    }

    @Override
    public void addAttribute(String name, String value) {
        if (null == name) {
            return;
        }
        if (null != value) {
            this.attributes.put(name, value);
        } else {
            this.attributes.remove(name);
        }
    }

    @Override
    public boolean hasAttribute(String attributeName) {
        if (attributeName == null) {
            return false;
        }
        return this.attributes.containsKey(attributeName);
    }

    @Override
    public void addMetric(String name, Double value) {
        if (null == name) {
            return;
        }
        if (null != value) {
            this.metrics.put(name, value);
        } else {
            this.metrics.remove(name);
        }
    }

    @Override
    public boolean hasMetric(String metricName) {
        if (metricName == null) {
            return false;
        }
        return this.metrics.containsKey(metricName);
    }

    @Override
    public String getEventType() {
        return this.eventType;
    }

    @Override
    public String getAttribute(String name) {
        if (name == null) {
            return null;
        }
        return this.attributes.get(name);
    }

    @Override
    public Double getMetric(String name) {
        if (name == null) {
            return null;
        }
        return this.metrics.get(name);
    }

    @Override
    public String getSessionId() {
        return this.sessionId;
    }

    @Override
    public Long getEventTimestamp() {
        return this.timestamp;
    }

    @Override
    public Id getUniqueId() {
        return this.uniqueId;
    }

    @Override
    public String getSdkName() {
        return this.sdkName;
    }

    @Override
    public String getSdkVersion() {
        return this.sdkVersion;
    }

    @Override
    public DefaultEvent withAttribute(String name, String value) {
        this.addAttribute(name, value);
        return this;
    }

    @Override
    public DefaultEvent withMetric(String name, Double value) {
        this.addMetric(name, value);
        return this;
    }

    @Override
    public Map<String, String> getAllAttributes() {
        return Collections.unmodifiableMap(this.attributes);
    }

    @Override
    public Map<String, Double> getAllMetrics() {
        return Collections.unmodifiableMap(this.metrics);
    }

    public String toString() {
        JSONObject json = this.toJSONObject();
        try {
            return json.toString(4);
        }
        catch (JSONException e) {
            return json.toString();
        }
    }

    @Override
    public JSONObject toJSONObject() {
        Locale locale = this.deviceDetails.locale();
        String localeString = locale != null ? locale.toString() : "UNKNOWN";
        JSONBuilder builder = new JSONBuilder(this);
        builder.withAttribute("event_type", this.getEventType());
        builder.withAttribute("unique_id", this.getUniqueId().getValue());
        builder.withAttribute("timestamp", this.getEventTimestamp());
        builder.withAttribute("platform", this.deviceDetails.platform());
        builder.withAttribute("platform_version", this.deviceDetails.platformVersion());
        builder.withAttribute("make", this.deviceDetails.manufacturer());
        builder.withAttribute("model", this.deviceDetails.model());
        builder.withAttribute("locale", localeString);
        builder.withAttribute("carrier", this.deviceDetails.carrier());
        JSONObject sessionObject = new JSONObject();
        try {
            sessionObject.put("id", (Object)this.sessionId);
            if (this.sessionStart != null) {
                sessionObject.put("startTimestamp", (Object)this.sessionStart);
            }
            if (this.sessionStop != null) {
                sessionObject.put("stopTimestamp", (Object)this.sessionStop);
            }
            if (this.sessionDuration != null) {
                sessionObject.put("duration", this.sessionDuration.longValue());
            }
        }
        catch (JSONException e) {
            logger.e("Error serializing session information", e);
        }
        builder.withAttribute("session", sessionObject);
        builder.withAttribute("sdk_version", this.sdkVersion);
        builder.withAttribute("sdk_name", this.sdkName);
        builder.withAttribute("app_version_name", this.appDetails.versionName());
        builder.withAttribute("app_version_code", this.appDetails.versionCode());
        builder.withAttribute("app_package_name", this.appDetails.packageName());
        builder.withAttribute("app_title", this.appDetails.getAppTitle());
        builder.withAttribute("app_id", this.appDetails.getAppId());
        JSONObject attributesJson = new JSONObject();
        for (Map.Entry<String, String> entry : this.getAllAttributes().entrySet()) {
            try {
                attributesJson.put(entry.getKey(), (Object)entry.getValue());
            }
            catch (JSONException e) {}
        }
        JSONObject metricsJson = new JSONObject();
        for (Map.Entry<String, Double> entry : this.getAllMetrics().entrySet()) {
            try {
                metricsJson.put(entry.getKey(), (Object)entry.getValue());
            }
            catch (JSONException e) {
                logger.w("error serializing metric. key:'" + entry.getKey() + "', value: " + entry.getValue().toString(), e);
            }
        }
        if (attributesJson.length() > 0) {
            builder.withAttribute("attributes", attributesJson);
        }
        if (metricsJson.length() > 0) {
            builder.withAttribute("metrics", metricsJson);
        }
        return builder.toJSONObject();
    }

    @Override
    public ClientContext createClientContext(String networkType) {
        ClientContext.ClientContextBuilder builder = new ClientContext.ClientContextBuilder();
        builder.withAppPackageName(this.appDetails.packageName()).withAppVersionCode(this.appDetails.versionCode()).withAppVersionName(this.appDetails.versionName()).withLocale(this.deviceDetails.locale().toString()).withMake(this.deviceDetails.manufacturer()).withModel(this.deviceDetails.model()).withPlatformVersion(this.deviceDetails.platformVersion()).withUniqueId(this.uniqueId.getValue()).withAppTitle(this.appDetails.getAppTitle()).withNetworkType(networkType).withCarrier(this.deviceDetails.carrier()).withAppId(this.appDetails.getAppId());
        return builder.build();
    }

    @Override
    public long getSessionStart() {
        return this.sessionStart;
    }

    @Override
    public Long getSessionStop() {
        return this.sessionStop;
    }

    @Override
    public Long getSessionDuration() {
        return this.sessionDuration;
    }
}

