/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.event;

import com.amazonaws.mobileconnectors.amazonmobileanalytics.AnalyticsEvent;
import com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.core.AnalyticsContext;
import com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.core.log.Logger;
import com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.core.util.JSONBuilder;
import com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.core.util.JSONSerializable;
import com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.core.util.Preconditions;
import com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.core.util.StringUtil;
import com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.delivery.DeliveryClient;
import com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.event.DefaultEvent;
import com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.event.EventConstraintDecorator;
import com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.event.EventObserver;
import com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.event.InternalEvent;
import com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.event.InternalEventClient;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultEventClient
implements InternalEventClient,
JSONSerializable {
    private static Logger logger = Logger.getLogger(DefaultEventClient.class);
    private static final String ANALYTICS_ENABLED = "isAnalyticsEnabled";
    private static final int MAX_EVENT_TYPE_LENGTH = 50;
    private final DeliveryClient deliveryClient;
    private final AnalyticsContext context;
    private final Map<String, String> globalAttributes = new ConcurrentHashMap<String, String>();
    private final Map<String, Double> globalMetrics = new ConcurrentHashMap<String, Double>();
    private final Map<String, Map<String, String>> eventTypeAttributes = new ConcurrentHashMap<String, Map<String, String>>();
    private final Map<String, Map<String, Double>> eventTypeMetrics = new ConcurrentHashMap<String, Map<String, Double>>();
    private List<EventObserver> observers = new CopyOnWriteArrayList<EventObserver>();
    private boolean allowEventCollection = true;
    private String sessionId;
    private long sessionStartTime;

    public static DefaultEventClient newInstance(AnalyticsContext context, boolean allowEventCollection) {
        DefaultEventClient instance = new DefaultEventClient(context, allowEventCollection);
        return instance;
    }

    DefaultEventClient(AnalyticsContext context, boolean allowEventCollection) {
        Preconditions.checkNotNull(context, "A valid context must be provided");
        Preconditions.checkNotNull(context.getDeliveryClient(), "A valid DeliveryClient must be provided");
        this.allowEventCollection = allowEventCollection;
        this.context = context;
        this.deliveryClient = context.getDeliveryClient();
        this.addEventObserver(this.deliveryClient);
    }

    @Override
    public void recordEvent(AnalyticsEvent event) {
        if (event == null) {
            logger.i("The provided event was null");
            logger.devi("The provided event was null");
            return;
        }
        if (!this.context.getConfiguration().optBoolean(ANALYTICS_ENABLED, true).booleanValue() || !this.getAllowEventCollection()) {
            return;
        }
        InternalEvent eventToRecord = null;
        if (!(event instanceof InternalEvent)) {
            logger.e("Error recording event, this event cannot be stored");
            return;
        }
        eventToRecord = (InternalEvent)event;
        DefaultEvent recordEvent = DefaultEvent.createFromEvent(this.context, this.sessionId, System.currentTimeMillis(), eventToRecord);
        this.notifyObservers(recordEvent);
    }

    @Override
    public AnalyticsEvent createEvent(String eventType) {
        return this.createEvent(eventType, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AnalyticsEvent createEvent(String eventType, boolean applyGlobalAttributes) {
        if (eventType == null) {
            logger.v("Null eventType provided to addGlobalAttribute");
            logger.devi("Null eventType provided to createEvent");
            throw new IllegalArgumentException("The eventType passed into create event was null");
        }
        String trimmedEventType = StringUtil.clipString(eventType, 50, false);
        if (trimmedEventType.length() < eventType.length()) {
            logger.devw("The event type has been trimmed to a length of 50 characters");
        }
        InternalEvent event = this.createInternalEvent(trimmedEventType, this.sessionStartTime, null, null);
        event = EventConstraintDecorator.newInstance(event);
        DefaultEventClient defaultEventClient = this;
        synchronized (defaultEventClient) {
            if (applyGlobalAttributes) {
                if (this.eventTypeAttributes.containsKey(event.getEventType())) {
                    for (Map.Entry<String, String> entry : this.eventTypeAttributes.get(event.getEventType()).entrySet()) {
                        event.addAttribute(entry.getKey(), entry.getValue());
                    }
                }
                for (Map.Entry<String, String> entry : this.globalAttributes.entrySet()) {
                    event.addAttribute(entry.getKey(), entry.getValue());
                }
                if (this.eventTypeMetrics.containsKey(event.getEventType())) {
                    for (Map.Entry<String, Object> entry : this.eventTypeMetrics.get(event.getEventType()).entrySet()) {
                        event.addMetric(entry.getKey(), (Double)entry.getValue());
                    }
                }
                for (Map.Entry<String, Object> entry : this.globalMetrics.entrySet()) {
                    event.addMetric(entry.getKey(), (Double)entry.getValue());
                }
            }
        }
        return event;
    }

    @Override
    public InternalEvent createInternalEvent(String eventType, long sessionStart, Long sessionEnd, Long sessionDuration) {
        return DefaultEvent.newInstance(this.context, this.sessionId, sessionStart, sessionEnd, sessionDuration, System.currentTimeMillis(), eventType);
    }

    @Override
    public void submitEvents() {
        logger.v("Notifying deliveryClient");
        this.deliveryClient.attemptDelivery();
    }

    @Override
    public void addGlobalAttribute(String attributeName, String attributeValue) {
        if (attributeName == null) {
            logger.v("Null attribute name provided to addGlobalAttribute");
            return;
        }
        if (attributeValue == null) {
            logger.v("Null attribute value provided to addGlobalAttribute. attribute name:" + attributeName);
            return;
        }
        this.globalAttributes.put(attributeName, attributeValue);
    }

    @Override
    public void addGlobalAttribute(String eventType, String attributeName, String attributeValue) {
        if (eventType == null) {
            logger.w("Null eventType provided to addGlobalAttribute");
            return;
        }
        if (attributeName == null) {
            logger.w("Null attribute name provided to addGlobalAttribute. eventType:" + eventType);
            return;
        }
        if (attributeValue == null) {
            logger.w("Null value provided to addGlobalAttribute. eventType:" + eventType + ", attributeName:" + attributeName);
            return;
        }
        Map<String, String> eventAttrs = this.eventTypeAttributes.get(eventType);
        if (eventAttrs == null) {
            eventAttrs = new ConcurrentHashMap<String, String>();
            this.eventTypeAttributes.put(eventType, eventAttrs);
        }
        eventAttrs.put(attributeName, attributeValue);
    }

    @Override
    public void addGlobalMetric(String metricName, Double metricValue) {
        if (metricName == null) {
            logger.v("Null metric name provided to addGlobalMetric");
            return;
        }
        if (metricValue == null) {
            logger.v("Null metric value provided to addGlobalMetric.  metric name:" + metricName);
            return;
        }
        this.globalMetrics.put(metricName, metricValue);
    }

    @Override
    public void addGlobalMetric(String eventType, String metricName, Double metricValue) {
        if (eventType == null) {
            logger.v("Null eventType provided to addGlobalMetric");
            return;
        }
        if (metricName == null) {
            logger.v("Null metric name provided to addGlobalMetric. eventType:" + eventType);
            return;
        }
        if (metricValue == null) {
            logger.v("Null metric value provided to addGlobalMetric. eventType:" + eventType + ", metric name:" + metricName);
            return;
        }
        Map<String, Double> eventMetrics = this.eventTypeMetrics.get(eventType);
        if (eventMetrics == null) {
            eventMetrics = new ConcurrentHashMap<String, Double>();
            this.eventTypeMetrics.put(eventType, eventMetrics);
        }
        eventMetrics.put(metricName, metricValue);
    }

    @Override
    public void addEventObserver(EventObserver observer) {
        logger.v("Adding EventObserver");
        if (observer == null) {
            logger.v("Null EventObserver provided to addObserver");
            return;
        }
        if (logger.isLoggingEnabled(Logger.LogLevel.VERBOSE)) {
            logger.v(observer.toString());
        }
        if (!this.getEventObservers().contains(observer)) {
            this.getEventObservers().add(observer);
        } else {
            logger.v("Observer was already registered with this EventRecorder");
            if (logger.isLoggingEnabled(Logger.LogLevel.VERBOSE)) {
                logger.v(this.toString());
            }
        }
    }

    @Override
    public void removeEventObserver(EventObserver observer) {
        logger.v("Removing EventObserver");
        if (observer == null) {
            logger.v("Null EventObserver provided to removeObserver");
            return;
        }
        if (logger.isLoggingEnabled(Logger.LogLevel.VERBOSE)) {
            logger.v(observer.toString());
        }
        if (this.getEventObservers().contains(observer)) {
            this.getEventObservers().remove(observer);
        } else {
            logger.v("Observer was not registered with this EventRecorder");
            if (logger.isLoggingEnabled(Logger.LogLevel.VERBOSE)) {
                logger.v(this.toString());
            }
        }
    }

    protected List<EventObserver> getEventObservers() {
        if (this.observers == null) {
            this.observers = new ArrayList<EventObserver>();
        }
        return this.observers;
    }

    protected void notifyObservers(InternalEvent event) {
        logger.v("Notifying EventObservers");
        if (logger.isLoggingEnabled(Logger.LogLevel.VERBOSE)) {
            logger.v(event.toString());
        }
        for (EventObserver observer : this.getEventObservers()) {
            observer.notify(event);
        }
    }

    @Override
    public void removeGlobalAttribute(String attributeName) {
        if (attributeName == null) {
            logger.v("Null attribute name provided to removeGlobalAttribute");
            return;
        }
        this.globalAttributes.remove(attributeName);
    }

    @Override
    public void removeGlobalAttribute(String eventType, String attributeName) {
        if (eventType == null) {
            logger.v("Null eventType provided to removeGlobalAttribute");
            return;
        }
        if (attributeName == null) {
            logger.v("Null attribute name provided to removeGlobalAttribute");
            return;
        }
        Map<String, String> eventAttrs = this.eventTypeAttributes.get(eventType);
        if (eventAttrs != null) {
            eventAttrs.remove(attributeName);
        }
    }

    @Override
    public void removeGlobalMetric(String metricName) {
        if (metricName == null) {
            logger.v("Null metric name provided to removeGlobalMetric");
            return;
        }
        this.globalMetrics.remove(metricName);
    }

    @Override
    public void removeGlobalMetric(String eventType, String metricName) {
        if (eventType == null) {
            logger.v("Null eventType provided to removeGlobalMetric");
            return;
        }
        if (metricName == null) {
            logger.v("Null metric name provided to removeGlobalMetric");
            return;
        }
        Map<String, Double> eventMetrics = this.eventTypeMetrics.get(eventType);
        if (eventMetrics != null) {
            eventMetrics.remove(metricName);
        }
    }

    public String toString() {
        JSONObject json = this.toJSONObject();
        try {
            return json.toString(4);
        }
        catch (JSONException e) {
            return json.toString();
        }
    }

    @Override
    public JSONObject toJSONObject() {
        JSONArray observersJSON = new JSONArray();
        if (null != this.observers) {
            for (EventObserver observer : this.observers) {
                if (JSONSerializable.class.isAssignableFrom(observer.getClass())) {
                    observersJSON.put((Object)((JSONSerializable)((Object)observer)).toJSONObject());
                    continue;
                }
                observersJSON.put((Object)observer);
            }
        }
        JSONArray globalAttrs = new JSONArray();
        if (null != this.globalAttributes) {
            for (Map.Entry<String, String> entry : this.globalAttributes.entrySet()) {
                try {
                    JSONObject attr = new JSONObject();
                    attr.put(entry.getKey(), (Object)entry.getValue());
                    globalAttrs.put((Object)attr);
                }
                catch (JSONException e) {}
            }
        }
        JSONArray globalMets = new JSONArray();
        if (null != this.globalMetrics) {
            for (Map.Entry<String, Double> entry : this.globalMetrics.entrySet()) {
                try {
                    JSONObject attr = new JSONObject();
                    attr.put(entry.getKey(), (Object)entry.getValue());
                    globalMets.put((Object)attr);
                }
                catch (JSONException e) {}
            }
        }
        JSONObject eventTypesAttributesJson = new JSONObject();
        if (null != this.eventTypeAttributes) {
            for (Map.Entry<String, Map<String, String>> entry : this.eventTypeAttributes.entrySet()) {
                JSONArray eventTypeAttrs = new JSONArray();
                for (Map.Entry<String, String> attrEntry : entry.getValue().entrySet()) {
                    try {
                        JSONObject attr = new JSONObject();
                        attr.put(attrEntry.getKey(), (Object)attrEntry.getValue());
                        eventTypeAttrs.put((Object)attr);
                    }
                    catch (JSONException e) {}
                }
                try {
                    eventTypesAttributesJson.put(entry.getKey(), (Object)eventTypeAttrs);
                }
                catch (JSONException e) {}
            }
        }
        JSONObject eventTypesMetricsJson = new JSONObject();
        if (null != this.eventTypeMetrics) {
            for (Map.Entry<String, Map<String, Double>> entry : this.eventTypeMetrics.entrySet()) {
                JSONArray eventTypeMets = new JSONArray();
                for (Map.Entry<String, Double> attrEntry : entry.getValue().entrySet()) {
                    try {
                        JSONObject attr = new JSONObject();
                        attr.put(attrEntry.getKey(), (Object)attrEntry.getValue());
                        eventTypeMets.put((Object)attr);
                    }
                    catch (JSONException e) {}
                }
                try {
                    eventTypesMetricsJson.put(entry.getKey(), (Object)eventTypeMets);
                }
                catch (JSONException e) {}
            }
        }
        return new JSONBuilder(this).withAttribute("uniqueId", this.context.getUniqueId()).withAttribute("observers", observersJSON).withAttribute("globalAttributes", globalAttrs).withAttribute("globalMetrics", globalMets).withAttribute("eventTypeAttributes", eventTypesAttributesJson).withAttribute("eventTypeMetrics", eventTypesMetricsJson).toJSONObject();
    }

    public boolean getAllowEventCollection() {
        return this.allowEventCollection;
    }

    @Override
    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    @Override
    public void setSessionStartTime(long sessionStartTime) {
        this.sessionStartTime = sessionStartTime;
    }
}

