/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.event;

import com.amazonaws.mobileconnectors.amazonmobileanalytics.AnalyticsEvent;
import com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.core.idresolver.Id;
import com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.core.log.Logger;
import com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.core.util.StringUtil;
import com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.event.ClientContext;
import com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.event.InternalEvent;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventConstraintDecorator
implements InternalEvent {
    private static Logger logger = Logger.getLogger(EventConstraintDecorator.class);
    private static final int MAX_EVENT_ATTRIBUTE_METRIC_KEY_LENGTH = 40;
    private static final int MAX_EVENT_ATTRIBUTE_VALUE_LENGTH = 200;
    private static final int MAX_NUM_OF_METRICS_AND_ATTRIBUTES = 50;
    private final InternalEvent decoratedEvent;
    private final int maxAttributesAndMetrics;
    private final AtomicInteger currentNumOfAttributesAndMetrics = new AtomicInteger(0);

    public static EventConstraintDecorator newInstance(InternalEvent eventToDecorate) {
        return new EventConstraintDecorator(eventToDecorate, 50);
    }

    public EventConstraintDecorator(InternalEvent eventToDecorate, int maxAttributesAndMetrics) {
        this.decoratedEvent = eventToDecorate;
        this.maxAttributesAndMetrics = maxAttributesAndMetrics;
    }

    @Override
    public synchronized void addAttribute(String name, String value) {
        try {
            if (name != null && value != null && !this.decoratedEvent.hasAttribute(name) && this.currentNumOfAttributesAndMetrics.get() < this.maxAttributesAndMetrics) {
                Pair<String, String> trimmedResult = EventConstraintDecorator.processAttribute(name, value);
                this.decoratedEvent.addAttribute((String)((Pair)trimmedResult).getKey(), (String)((Pair)trimmedResult).getValue());
                this.currentNumOfAttributesAndMetrics.incrementAndGet();
            }
        }
        catch (Exception e) {
            logger.e("addAttribute", e);
        }
    }

    @Override
    public boolean hasAttribute(String attributeName) {
        boolean hasAttribute = false;
        try {
            hasAttribute = this.decoratedEvent.hasAttribute(attributeName);
        }
        catch (Exception e) {
            logger.e("hasAttribute", e);
        }
        return hasAttribute;
    }

    @Override
    public synchronized void addMetric(String name, Double value) {
        try {
            if (name != null && value != null && !this.decoratedEvent.hasMetric(name) && this.currentNumOfAttributesAndMetrics.get() < this.maxAttributesAndMetrics) {
                Pair<String, Double> trimmedResult = EventConstraintDecorator.processMetric(name, value);
                this.decoratedEvent.addMetric((String)((Pair)trimmedResult).getKey(), (Double)((Pair)trimmedResult).getValue());
                this.currentNumOfAttributesAndMetrics.incrementAndGet();
            }
        }
        catch (Exception e) {
            logger.e("addMetric", e);
        }
    }

    @Override
    public boolean hasMetric(String metricName) {
        boolean hasMetric = false;
        try {
            hasMetric = this.decoratedEvent.hasMetric(metricName);
        }
        catch (Exception e) {
            logger.e("hasMetric", e);
        }
        return hasMetric;
    }

    @Override
    public String getEventType() {
        return this.decoratedEvent.getEventType();
    }

    @Override
    public String getAttribute(String name) {
        return this.decoratedEvent.getAttribute(name);
    }

    @Override
    public Double getMetric(String name) {
        return this.decoratedEvent.getMetric(name);
    }

    @Override
    public AnalyticsEvent withAttribute(String name, String value) {
        try {
            this.addAttribute(name, value);
        }
        catch (Exception e) {
            logger.e("withAttribute", e);
        }
        return this.decoratedEvent;
    }

    @Override
    public AnalyticsEvent withMetric(String name, Double value) {
        try {
            this.addMetric(name, value);
        }
        catch (Exception e) {
            logger.e("withMetric", e);
        }
        return this.decoratedEvent;
    }

    @Override
    public Map<String, String> getAllAttributes() {
        return this.decoratedEvent.getAllAttributes();
    }

    @Override
    public Map<String, Double> getAllMetrics() {
        return this.decoratedEvent.getAllMetrics();
    }

    private static Pair<String, String> processAttribute(String key, String value) {
        String trimmedValue;
        String trimmedKey = StringUtil.clipString(key, 40, false);
        if (trimmedKey.length() < key.length()) {
            logger.devw("The attribute key has been trimmed to a length of 40 characters");
        }
        if ((trimmedValue = StringUtil.clipString(value, 200, false)).length() < value.length()) {
            logger.devw("The attribute value has been trimmed to a length of 200 characters");
        }
        return new Pair<String, String>(trimmedKey, trimmedValue);
    }

    private static Pair<String, Double> processMetric(String key, Double value) {
        String trimmedKey = StringUtil.clipString(key, 40, false);
        if (trimmedKey.length() < key.length()) {
            logger.devw("The metric key has been trimmed to a length of 40 characters");
        }
        return new Pair<String, Double>(trimmedKey, value);
    }

    @Override
    public JSONObject toJSONObject() {
        return this.decoratedEvent.toJSONObject();
    }

    @Override
    public Long getEventTimestamp() {
        return this.decoratedEvent.getEventTimestamp();
    }

    @Override
    public Id getUniqueId() {
        return this.decoratedEvent.getUniqueId();
    }

    @Override
    public String getSessionId() {
        return this.decoratedEvent.getSessionId();
    }

    @Override
    public long getSessionStart() {
        return this.decoratedEvent.getSessionStart();
    }

    @Override
    public Long getSessionStop() {
        return this.decoratedEvent.getSessionStop();
    }

    @Override
    public Long getSessionDuration() {
        return this.decoratedEvent.getSessionDuration();
    }

    @Override
    public String getSdkName() {
        return this.decoratedEvent.getSdkName();
    }

    @Override
    public String getSdkVersion() {
        return this.decoratedEvent.getSdkVersion();
    }

    @Override
    public ClientContext createClientContext(String networkType) {
        return this.decoratedEvent.createClientContext(networkType);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Pair<T, U> {
        private T key;
        private U value;

        private T getKey() {
            return this.key;
        }

        private U getValue() {
            return this.value;
        }

        public Pair(T key, U value) {
            this.key = key;
            this.value = value;
        }
    }
}

