/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.event.adapter;

import com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.core.idresolver.Id;
import com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.core.log.Logger;
import com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.core.system.AndroidAppDetails;
import com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.core.system.AndroidDeviceDetails;
import com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.core.util.JSONBuilder;
import com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.core.util.SDKInfo;
import com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.event.DefaultEvent;
import com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.event.InternalEvent;
import com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.event.adapter.EventAdapter;
import java.util.HashMap;
import java.util.Iterator;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSONEventAdapter
implements EventAdapter<JSONObject> {
    private static Logger logger = Logger.getLogger(JSONEventAdapter.class);

    @Override
    public JSONObject translateFromEvent(InternalEvent source) {
        if (null == source) {
            logger.i("The Event provided was null");
            return null;
        }
        JSONObject json = source.toJSONObject();
        if (json.has("class")) {
            json.remove("class");
        }
        if (json.has("hashCode")) {
            json.remove("hashCode");
        }
        return json;
    }

    public String toString() {
        return new JSONBuilder(this).toString();
    }

    @Override
    public InternalEvent translateToEvent(JSONObject source) throws JSONException {
        JSONObject metricsJSON;
        JSONObject attributesJSON;
        HashMap<String, String> attributes = new HashMap<String, String>();
        HashMap<String, Double> metrics = new HashMap<String, Double>();
        AndroidAppDetails appDetails = new AndroidAppDetails(source.optString("app_package_name"), source.optString("app_version_code"), source.optString("app_version_name"), source.optString("app_title"), source.optString("app_id"));
        SDKInfo sdkInfo = new SDKInfo(source.optString("sdk_version"), source.optString("sdk_name"));
        AndroidDeviceDetails deviceDetails = new AndroidDeviceDetails(source.optString("carrier"));
        String eventType = source.getString("event_type");
        String networkType = source.optString("network_type");
        Long timestamp = source.getLong("timestamp");
        Id uniqueId = Id.valueOf(source.getString("unique_id"));
        String sessionId = "";
        Long sessionStart = null;
        Long sessionStop = null;
        Long sessionDuration = null;
        JSONObject sessionJSON = source.getJSONObject("session");
        if (sessionJSON != null) {
            sessionId = sessionJSON.getString("id");
            sessionStart = sessionJSON.getLong("startTimestamp");
            sessionStop = sessionJSON.optLong("stopTimestamp");
            sessionDuration = sessionJSON.optLong("duration");
        }
        if ((attributesJSON = source.optJSONObject("attributes")) != null) {
            Iterator keysIterator = attributesJSON.keys();
            while (keysIterator.hasNext()) {
                String key = (String)keysIterator.next();
                attributes.put(key, attributesJSON.optString(key));
            }
        }
        if ((metricsJSON = source.optJSONObject("metrics")) != null) {
            Iterator keysIterator = metricsJSON.keys();
            while (keysIterator.hasNext()) {
                String key = (String)keysIterator.next();
                try {
                    metrics.put(key, metricsJSON.getDouble(key));
                }
                catch (JSONException e) {
                    logger.e("Failed to convert metric back to double from JSON value", e);
                }
            }
        }
        return DefaultEvent.newInstance(eventType, attributes, metrics, sdkInfo, sessionId, sessionStart, sessionStop, sessionDuration, timestamp, uniqueId, appDetails, deviceDetails);
    }
}

