/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.session;

import com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.core.AnalyticsContext;
import com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.core.log.Logger;
import com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.core.system.FileManager;
import com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.delivery.EventStoreException;
import com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.delivery.FileEventStore;
import com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.session.Session;
import com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.session.SessionStore;
import com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.session.SessionStoreException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class FileSessionStore
implements SessionStore {
    private static final Logger logger = Logger.getLogger(FileEventStore.class);
    protected static final String SESSION_DIRECTORY = "sessions";
    protected static final String SESSION_FILE_NAME = "sessionFile";
    static final String KEY_MAX_STORAGE_SIZE = "maxStorageSize";
    static final long MAX_STORAGE_SIZE = 22560L;
    private final AnalyticsContext context;
    private File sessionFile;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock(true);
    private final ReentrantReadWriteLock.ReadLock readSessionLock = this.lock.readLock();
    private final ReentrantReadWriteLock.WriteLock writeSessionLock = this.lock.writeLock();
    private BufferedReader reader = null;

    public FileSessionStore(AnalyticsContext context) {
        this.context = context;
        FileManager fileManager = this.context.getSystem().getFileManager();
        File sessionDir = fileManager.createDirectory(SESSION_DIRECTORY);
        try {
            this.sessionFile = fileManager.createFile(new File(sessionDir, SESSION_FILE_NAME));
        }
        catch (IOException e) {
            logger.deve("Unable to open session file");
            logger.e("An error occurred while attempting to create/open the session file", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void storeSession(Session session) throws SessionStoreException {
        String serializedSession = session.toJSONObject().toString();
        Writer writer = null;
        this.writeSessionLock.lock();
        try {
            block9: {
                try {
                    block8: {
                        try {
                            writer = this.tryInitializeWriter();
                            if (writer == null) break block8;
                            long maxStorageSize = this.context.getConfiguration().optLong(KEY_MAX_STORAGE_SIZE, 22560L);
                            if (this.sessionFile.length() + (long)serializedSession.length() <= maxStorageSize) {
                                writer.write(serializedSession);
                                writer.flush();
                            } else {
                                logger.e("The session file exceeded its allowed size of " + maxStorageSize + " bytes");
                            }
                        }
                        catch (IOException e) {
                            logger.e("Failed to persist the session", e);
                            Object var7_7 = null;
                            this.tryCloseWriter(writer);
                            break block9;
                        }
                    }
                    Object var7_6 = null;
                }
                catch (Throwable throwable) {
                    Object var7_8 = null;
                    this.tryCloseWriter(writer);
                    throw throwable;
                }
                this.tryCloseWriter(writer);
            }
            Object var9_10 = null;
            this.writeSessionLock.unlock();
            return;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            this.writeSessionLock.unlock();
            throw throwable;
        }
    }

    private Writer tryInitializeWriter() throws SessionStoreException {
        OutputStreamWriter writer = null;
        try {
            OutputStream stream = this.context.getSystem().getFileManager().newOutputStream(this.sessionFile, false);
            writer = new OutputStreamWriter(stream);
        }
        catch (FileNotFoundException e) {
            logger.e("Session file not found to persist session to", e);
            throw new EventStoreException("Unable to open session file writer", e);
        }
        catch (Exception e) {
            logger.e("Unexpected exception", e);
        }
        return writer;
    }

    private void tryCloseWriter(Writer writer) throws SessionStoreException {
        if (writer != null) {
            try {
                writer.close();
            }
            catch (IOException e) {
                logger.e("Unable to close writer for session file", e);
            }
        }
    }

    private boolean tryOpenReader() {
        if (this.reader != null) {
            return true;
        }
        InputStreamReader streamReader = null;
        try {
            streamReader = new InputStreamReader(this.context.getSystem().getFileManager().newInputStream(this.sessionFile));
        }
        catch (FileNotFoundException e) {
            logger.e("Could not open the session file", e);
        }
        if (streamReader != null) {
            this.reader = new BufferedReader(streamReader);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryCloseReader() {
        if (this.reader != null) {
            this.readSessionLock.lock();
            try {
                try {
                    try {
                        this.reader.close();
                    }
                    catch (IOException ioe) {
                        logger.e("Unable to close reader for session file", ioe);
                        Object var3_2 = null;
                        this.reader = null;
                    }
                    Object var3_1 = null;
                    this.reader = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    this.reader = null;
                    throw throwable;
                }
                Object var5_6 = null;
                this.readSessionLock.unlock();
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                this.readSessionLock.unlock();
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Session getSession() {
        String serializedSession = null;
        this.readSessionLock.lock();
        try {
            block14: {
                block13: {
                    this.tryOpenReader();
                    if (this.reader == null) break block13;
                    serializedSession = this.reader.readLine();
                }
                Object var4_2 = null;
                this.tryCloseReader();
                FileManager fileManager = this.context.getSystem().getFileManager();
                try {
                    if (fileManager.deleteFile(this.sessionFile) || !this.sessionFile.exists()) {
                        this.sessionFile = fileManager.createFile(this.sessionFile);
                    }
                    break block14;
                }
                catch (IOException e2) {
                    logger.e("Unable to clear session file", e2);
                }
                break block14;
                {
                    catch (IOException e) {
                        logger.e("Failed to read the session", e);
                        Object var4_3 = null;
                        this.tryCloseReader();
                        fileManager = this.context.getSystem().getFileManager();
                        try {
                            if (fileManager.deleteFile(this.sessionFile) || !this.sessionFile.exists()) {
                                this.sessionFile = fileManager.createFile(this.sessionFile);
                            }
                            break block14;
                        }
                        catch (IOException e2) {
                            logger.e("Unable to clear session file", e2);
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    this.tryCloseReader();
                    fileManager = this.context.getSystem().getFileManager();
                    try {
                        if (fileManager.deleteFile(this.sessionFile) || !this.sessionFile.exists()) {
                            this.sessionFile = fileManager.createFile(this.sessionFile);
                        }
                    }
                    catch (IOException e2) {
                        logger.e("Unable to clear session file", e2);
                    }
                    throw throwable;
                }
            }
            Object var8_13 = null;
            this.readSessionLock.unlock();
        }
        catch (Throwable throwable) {
            Object var8_14 = null;
            this.readSessionLock.unlock();
            throw throwable;
        }
        return Session.getSessionFromSerializedSession(serializedSession);
    }
}

