/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.session.client;

import android.util.Log;
import com.amazonaws.mobileconnectors.amazonmobileanalytics.AnalyticsEvent;
import com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.session.client.DefaultSessionClient;
import com.amazonaws.mobileconnectors.amazonmobileanalytics.internal.session.client.SessionClientState;

public class InactiveSessionState
extends SessionClientState {
    public InactiveSessionState(DefaultSessionClient client) {
        super(client);
    }

    public void resume() {
        AnalyticsEvent e = this.client.eventClient.createEvent("_session.resume");
        this.client.eventClient.recordEvent(e);
        DefaultSessionClient.logger.devi("Session Resume Failed: No session is paused.");
    }

    public void pause() {
        DefaultSessionClient.logger.devi("Session Pause Failed: No session is running.");
    }

    public void start() {
        Log.d((String)"InactiveSession", (String)"InactiveSession starting");
        super.executeStart();
    }

    public void stop() {
        DefaultSessionClient.logger.devi("Session Stop Failed: No session is running.");
    }
}

